/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.cloud.config.client.runtime;

import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;

@ConfigRoot(phase=ConfigPhase.BOOTSTRAP, name="spring-cloud-config")
public class SpringCloudConfigClientConfig {
    protected static final String NAME = "spring-cloud-config";
    @ConfigItem
    public boolean enabled;
    @ConfigItem
    public boolean failFast;
    @ConfigItem(defaultValue="http://localhost:8888")
    public String url;
    @ConfigItem
    public Optional<String> label;
    @ConfigItem(defaultValue="10S")
    public Duration connectionTimeout;
    @ConfigItem(defaultValue="60S")
    public Duration readTimeout;
    @ConfigItem
    public Optional<String> username;
    @ConfigItem
    public Optional<String> password;
    @ConfigItem
    public Optional<Path> trustStore;
    @ConfigItem
    public Optional<String> trustStorePassword;
    @ConfigItem
    public Optional<Path> keyStore;
    @ConfigItem
    public Optional<String> keyStorePassword;
    @ConfigItem
    public Optional<String> keyPassword;
    @ConfigItem(defaultValue="false")
    public boolean trustCerts;
    @ConfigItem
    public Map<String, String> headers;

    public boolean usernameAndPasswordSet() {
        return this.username.isPresent() && this.password.isPresent();
    }
}

