/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.cloud.config.client.runtime;

import io.quarkus.runtime.ApplicationConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ProfileManager;
import io.quarkus.spring.cloud.config.client.runtime.SpringCloudConfigClientConfig;
import io.quarkus.spring.cloud.config.client.runtime.SpringCloudConfigServerClientConfigSourceProvider;
import java.util.Collections;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.jboss.logging.Logger;

@Recorder
public class SpringCloudConfigClientRecorder {
    private static final Logger log = Logger.getLogger(SpringCloudConfigClientRecorder.class);

    public RuntimeValue<ConfigSourceProvider> create(SpringCloudConfigClientConfig springCloudConfigClientConfig, ApplicationConfig applicationConfig) {
        if (!springCloudConfigClientConfig.enabled) {
            log.debug((Object)"No attempt will be made to obtain configuration from the Spring Cloud Config Server because the functionality has been disabled via configuration");
            return this.emptyRuntimeValue();
        }
        if (!applicationConfig.name.isPresent()) {
            log.warn((Object)"No attempt will be made to obtain configuration from the Spring Cloud Config Server because the application name has not been set. Consider setting it via 'quarkus.application.name'");
            return this.emptyRuntimeValue();
        }
        return new RuntimeValue((Object)new SpringCloudConfigServerClientConfigSourceProvider(springCloudConfigClientConfig, (String)applicationConfig.name.get(), ProfileManager.getActiveProfile()));
    }

    private RuntimeValue<ConfigSourceProvider> emptyRuntimeValue() {
        return new RuntimeValue((Object)new EmptyConfigSourceProvider());
    }

    private static class EmptyConfigSourceProvider
    implements ConfigSourceProvider {
        private EmptyConfigSourceProvider() {
        }

        public Iterable<ConfigSource> getConfigSources(ClassLoader forClassLoader) {
            return Collections.emptyList();
        }
    }
}

