/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.cloud.config.client.runtime;

import io.quarkus.runtime.TlsConfig;
import io.quarkus.spring.cloud.config.client.runtime.Response;
import io.quarkus.spring.cloud.config.client.runtime.SpringCloudConfigClientConfig;
import io.quarkus.spring.cloud.config.client.runtime.SpringCloudConfigClientGateway;
import io.quarkus.spring.cloud.config.client.runtime.VertxSpringCloudConfigGateway;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.jboss.logging.Logger;

public class SpringCloudConfigServerClientConfigSourceProvider
implements ConfigSourceProvider {
    private static final Logger log = Logger.getLogger(SpringCloudConfigServerClientConfigSourceProvider.class);
    private final SpringCloudConfigClientConfig springCloudConfigClientConfig;
    private final String applicationName;
    private final String activeProfile;
    private final SpringCloudConfigClientGateway springCloudConfigClientGateway;

    public SpringCloudConfigServerClientConfigSourceProvider(SpringCloudConfigClientConfig springCloudConfigClientConfig, String applicationName, String activeProfile, TlsConfig tlsConfig) {
        this.springCloudConfigClientConfig = springCloudConfigClientConfig;
        this.applicationName = applicationName;
        this.activeProfile = activeProfile;
        this.springCloudConfigClientGateway = new VertxSpringCloudConfigGateway(springCloudConfigClientConfig, tlsConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<ConfigSource> getConfigSources(ClassLoader forClassLoader) {
        ArrayList<ConfigSource> result = new ArrayList<ConfigSource>();
        try {
            boolean connectionTimeoutIsGreaterThanZero = !this.springCloudConfigClientConfig.connectionTimeout.isNegative() && !this.springCloudConfigClientConfig.connectionTimeout.isZero();
            boolean readTimeoutIsGreaterThanZero = !this.springCloudConfigClientConfig.readTimeout.isNegative() && !this.springCloudConfigClientConfig.readTimeout.isZero();
            Response response = connectionTimeoutIsGreaterThanZero || readTimeoutIsGreaterThanZero ? (Response)this.springCloudConfigClientGateway.exchange(this.applicationName, this.activeProfile).await().atMost(this.springCloudConfigClientConfig.connectionTimeout.plus(this.springCloudConfigClientConfig.readTimeout.multipliedBy(2L))) : (Response)this.springCloudConfigClientGateway.exchange(this.applicationName, this.activeProfile).await().indefinitely();
            if (response != null) {
                List<Response.PropertySource> propertySources = response.getPropertySources();
                Collections.reverse(propertySources);
                for (int i = 0; i < propertySources.size(); ++i) {
                    Response.PropertySource propertySource = propertySources.get(i);
                    result.add(new InMemoryConfigSource(450 + i, propertySource.getName(), propertySource.getSource()));
                }
            }
        }
        catch (Exception e) {
            String errorMessage = "Unable to obtain configuration from Spring Cloud Config Server at " + this.springCloudConfigClientConfig.url;
            if (this.springCloudConfigClientConfig.failFast) {
                throw new RuntimeException(errorMessage, e);
            }
            log.error((Object)errorMessage, (Throwable)e);
            List<ConfigSource> list = Collections.emptyList();
            return list;
        }
        finally {
            this.springCloudConfigClientGateway.close();
        }
        return result;
    }

    private static final class InMemoryConfigSource
    implements ConfigSource {
        private final Map<String, String> values = new HashMap<String, String>();
        private final int ordinal;
        private final String name;

        private InMemoryConfigSource(int ordinal, String name, Map<String, String> source) {
            this.ordinal = ordinal;
            this.name = name;
            this.values.putAll(source);
        }

        public Map<String, String> getProperties() {
            return this.values;
        }

        public Set<String> getPropertyNames() {
            return this.values.keySet();
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public String getValue(String propertyName) {
            return this.values.get(propertyName);
        }

        public String getName() {
            return this.name;
        }
    }
}

