/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.data.deployment.generate;

import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.spring.data.deployment.DotNames;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public final class GenerationUtil {
    private GenerationUtil() {
    }

    static List<DotName> extendedSpringDataRepos(ClassInfo repositoryToImplement, IndexView index) {
        ArrayList<DotName> result = new ArrayList<DotName>();
        for (DotName interfaceName : repositoryToImplement.interfaceNames()) {
            if (DotNames.SUPPORTED_REPOSITORIES.contains(interfaceName)) {
                result.add(interfaceName);
                continue;
            }
            ClassInfo intermediateInterfaces = index.getClassByName(interfaceName);
            List dns = intermediateInterfaces.interfaceNames();
            for (DotName in : dns) {
                result.addAll(GenerationUtil.extendedSpringDataRepos(intermediateInterfaces, index));
            }
        }
        return result;
    }

    static boolean isIntermediateRepository(DotName interfaceName, IndexView indexView) {
        if (!DotNames.SUPPORTED_REPOSITORIES.contains(interfaceName)) {
            ClassInfo intermediateInterface = indexView.getClassByName(interfaceName);
            List<DotName> extendedSpringDataRepos = GenerationUtil.extendedSpringDataRepos(intermediateInterface, indexView);
            return DotNames.SUPPORTED_REPOSITORIES.stream().anyMatch(item -> extendedSpringDataRepos.contains(item));
        }
        return false;
    }

    static Set<MethodInfo> interfaceMethods(Collection<DotName> interfaces, IndexView index) {
        HashSet<MethodInfo> result = new HashSet<MethodInfo>();
        for (DotName dotName : interfaces) {
            ClassInfo classInfo = index.getClassByName(dotName);
            result.addAll(classInfo.methods());
            List extendedInterfaces = classInfo.interfaceNames();
            if (extendedInterfaces.isEmpty()) continue;
            result.addAll(GenerationUtil.interfaceMethods(extendedInterfaces, index));
        }
        return result;
    }

    static MethodDescriptor toMethodDescriptor(String generatedClassName, MethodInfo methodInfo) {
        ArrayList<String> parameterTypesStr = new ArrayList<String>();
        for (Type parameter : methodInfo.parameters()) {
            parameterTypesStr.add(parameter.name().toString());
        }
        return MethodDescriptor.ofMethod((String)generatedClassName, (String)methodInfo.name(), (String)methodInfo.returnType().name().toString(), (String[])parameterTypesStr.toArray(new String[0]));
    }
}

