/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.data.deployment.generate;

import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.hibernate.orm.panache.PanacheQuery;
import io.quarkus.panache.common.Page;
import io.quarkus.spring.data.deployment.DotNames;
import io.quarkus.spring.data.runtime.TypesConverter;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.NoResultException;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.SliceImpl;

public abstract class AbstractMethodsAdder {
    protected void handleLongReturnValue(BytecodeCreator methodCreator, ResultHandle resultHandle, DotName returnType) {
        if (DotNames.LONG.equals((Object)returnType)) {
            resultHandle = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(Long.class, (String)"valueOf", Long.class, (Class[])new Class[]{Long.TYPE}), new ResultHandle[]{resultHandle});
        }
        methodCreator.returnValue(resultHandle);
    }

    protected void handleIntegerReturnValue(BytecodeCreator methodCreator, ResultHandle resultHandle, DotName returnType) {
        if (DotNames.INTEGER.equals((Object)returnType)) {
            resultHandle = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(Integer.class, (String)"valueOf", Integer.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{resultHandle});
        }
        methodCreator.returnValue(resultHandle);
    }

    protected void handleBooleanReturnValue(BytecodeCreator methodCreator, ResultHandle resultHandle, DotName returnType) {
        if (DotNames.BOOLEAN.equals((Object)returnType)) {
            resultHandle = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(Boolean.class, (String)"valueOf", Boolean.class, (Class[])new Class[]{Boolean.TYPE}), new ResultHandle[]{resultHandle});
        }
        methodCreator.returnValue(resultHandle);
    }

    protected void generateFindQueryResultHandling(MethodCreator methodCreator, ResultHandle panacheQuery, Integer pageableParameterIndex, ClassInfo repositoryClassInfo, ClassInfo entityClassInfo, DotName returnType, Integer limit, String methodName, DotName customResultType) {
        ResultHandle page = null;
        if (limit != null) {
            page = methodCreator.newInstance(MethodDescriptor.ofConstructor(Page.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{methodCreator.load(limit.intValue())});
        } else if (pageableParameterIndex != null) {
            page = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(TypesConverter.class, (String)"toPanachePage", Page.class, (Class[])new Class[]{Pageable.class}), new ResultHandle[]{methodCreator.getMethodParam(pageableParameterIndex.intValue())});
        }
        if (page != null) {
            panacheQuery = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"page", PanacheQuery.class, (Class[])new Class[]{Page.class}), panacheQuery, new ResultHandle[]{page});
        }
        if (returnType.equals((Object)entityClassInfo.name())) {
            String panacheQueryMethodToUse = limit != null ? "firstResult" : "singleResult";
            TryBlock tryBlock = methodCreator.tryBlock();
            ResultHandle singleResult = tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)panacheQueryMethodToUse, Object.class, (Class[])new Class[0]), panacheQuery, new ResultHandle[0]);
            ResultHandle casted = tryBlock.checkCast(singleResult, entityClassInfo.name().toString());
            tryBlock.returnValue(casted);
            CatchBlockCreator catchBlock = tryBlock.addCatch(NoResultException.class);
            catchBlock.returnValue(catchBlock.loadNull());
        } else if (DotNames.OPTIONAL.equals((Object)returnType)) {
            String panacheQueryMethodToUse = limit != null ? "firstResult" : "singleResult";
            TryBlock tryBlock = methodCreator.tryBlock();
            ResultHandle singleResult = tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)panacheQueryMethodToUse, Object.class, (Class[])new Class[0]), panacheQuery, new ResultHandle[0]);
            ResultHandle casted = tryBlock.checkCast(singleResult, entityClassInfo.name().toString());
            ResultHandle optional = tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod(Optional.class, (String)"of", Optional.class, (Class[])new Class[]{Object.class}), new ResultHandle[]{casted});
            tryBlock.returnValue(optional);
            CatchBlockCreator catchBlock = tryBlock.addCatch(NoResultException.class);
            ResultHandle emptyOptional = catchBlock.invokeStaticMethod(MethodDescriptor.ofMethod(Optional.class, (String)"empty", Optional.class, (Class[])new Class[0]), new ResultHandle[0]);
            catchBlock.returnValue(emptyOptional);
        } else if (DotNames.LIST.equals((Object)returnType) || DotNames.COLLECTION.equals((Object)returnType) || DotNames.ITERATOR.equals((Object)returnType)) {
            ResultHandle list;
            if (customResultType == null) {
                list = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"list", List.class, (Class[])new Class[0]), panacheQuery, new ResultHandle[0]);
            } else {
                ResultHandle stream = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"stream", Stream.class, (Class[])new Class[0]), panacheQuery, new ResultHandle[0]);
                FunctionCreator function = methodCreator.createFunction(Function.class);
                BytecodeCreator funcBytecode = function.getBytecode();
                ResultHandle obj = funcBytecode.invokeStaticMethod(MethodDescriptor.ofMethod((String)customResultType.toString(), (String)("convert_" + methodName), (String)customResultType.toString(), (String[])new String[]{Object[].class.getName()}), new ResultHandle[]{funcBytecode.getMethodParam(0)});
                funcBytecode.returnValue(obj);
                stream = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Stream.class, (String)"map", Stream.class, (Class[])new Class[]{Function.class}), stream, new ResultHandle[]{function.getInstance()});
                ResultHandle collector = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(Collectors.class, (String)"toList", Collector.class, (Class[])new Class[0]), new ResultHandle[0]);
                list = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Stream.class, (String)"collect", Object.class, (Class[])new Class[]{Collector.class}), stream, new ResultHandle[]{collector});
            }
            if (DotNames.ITERATOR.equals((Object)returnType)) {
                ResultHandle iterator = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterable.class, (String)"iterator", Iterator.class, (Class[])new Class[0]), list, new ResultHandle[0]);
                methodCreator.returnValue(iterator);
            }
            methodCreator.returnValue(list);
        } else if (DotNames.STREAM.equals((Object)returnType)) {
            ResultHandle stream = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"stream", Stream.class, (Class[])new Class[0]), panacheQuery, new ResultHandle[0]);
            methodCreator.returnValue(stream);
        } else if (DotNames.SPRING_DATA_PAGE.equals((Object)returnType)) {
            ResultHandle pageResult;
            ResultHandle list = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"list", List.class, (Class[])new Class[0]), panacheQuery, new ResultHandle[0]);
            if (pageableParameterIndex != null) {
                ResultHandle count = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"count", Long.TYPE, (Class[])new Class[0]), panacheQuery, new ResultHandle[0]);
                pageResult = methodCreator.newInstance(MethodDescriptor.ofConstructor(PageImpl.class, (Class[])new Class[]{List.class, Pageable.class, Long.TYPE}), new ResultHandle[]{list, methodCreator.getMethodParam(pageableParameterIndex.intValue()), count});
            } else {
                pageResult = methodCreator.newInstance(MethodDescriptor.ofConstructor(PageImpl.class, (Class[])new Class[]{List.class}), new ResultHandle[]{list});
            }
            methodCreator.returnValue(pageResult);
        } else if (DotNames.SPRING_DATA_SLICE.equals((Object)returnType)) {
            ResultHandle sliceResult;
            ResultHandle list = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"list", List.class, (Class[])new Class[0]), panacheQuery, new ResultHandle[0]);
            if (pageableParameterIndex != null) {
                ResultHandle hasNextPage = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"hasNextPage", Boolean.TYPE, (Class[])new Class[0]), panacheQuery, new ResultHandle[0]);
                sliceResult = methodCreator.newInstance(MethodDescriptor.ofConstructor(SliceImpl.class, (Class[])new Class[]{List.class, Pageable.class, Boolean.TYPE}), new ResultHandle[]{list, methodCreator.getMethodParam(pageableParameterIndex.intValue()), hasNextPage});
            } else {
                sliceResult = methodCreator.newInstance(MethodDescriptor.ofConstructor(SliceImpl.class, (Class[])new Class[]{List.class}), new ResultHandle[]{list});
            }
            methodCreator.returnValue(sliceResult);
        } else {
            throw new IllegalArgumentException("Return type of method " + methodName + " of Repository " + repositoryClassInfo + " does not match find query type");
        }
    }
}

