/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.data.deployment;

import io.quarkus.panache.common.Sort;
import io.quarkus.spring.data.deployment.DotNames;
import io.quarkus.spring.data.deployment.UnableToParseMethodException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public class MethodNameParser {
    private static final String ALL_IGNORE_CASE = "AllIgnoreCase";
    private static final String IGNORE_CASE = "IgnoreCase";
    private static final String ORDER_BY = "OrderBy";
    private static final List<String> HANDLED_PROPERTY_OPERATIONS = Arrays.asList("Is", "Equals", "IsNot", "Not", "IsNull", "Null", "IsNotNull", "NotNull", "IsBetween", "Between", "IsLessThan", "LessThan", "IsLessThanEqual", "LessThanEqual", "IsGreaterThan", "GreaterThan", "IsGreaterThanEqual", "GreaterThanEqual", "IsLike", "Like", "IsNotLike", "NotLike", "IsStartingWith", "StartingWith", "StartsWith", "IsEndingWith", "EndingWith", "EndsWith", "IsContaining", "Containing", "Contains", "Before", "IsBefore", "After", "IsAfter", "True", "False", "IsIn", "In", "IsNotIn", "NotIn", "IsEmpty", "Empty", "IsNotEmpty", "NotEmpty");
    private static final Set<String> STRING_LIKE_OPERATIONS = new HashSet<String>(Arrays.asList("IsLike", "Like", "IsNotLike", "NotLike", "IsStartingWith", "StartingWith", "StartsWith", "IsEndingWith", "EndingWith", "EndsWith", "IsContaining", "Containing", "Contains"));
    private static final Set<String> BOOLEAN_OPERATIONS = new HashSet<String>(Arrays.asList("True", "False"));
    private final ClassInfo entityClass;
    private final IndexView indexView;
    private final List<ClassInfo> mappedSuperClassInfos;

    public MethodNameParser(ClassInfo entityClass, IndexView indexView) {
        this.entityClass = entityClass;
        this.indexView = indexView;
        this.mappedSuperClassInfos = this.getMappedSuperClassInfos(indexView, entityClass);
    }

    public Result parse(MethodInfo methodInfo) {
        String methodName = methodInfo.name();
        QueryType queryType = this.getType(methodName);
        if (queryType == null) {
            throw new UnableToParseMethodException("Repository method " + methodName + " cannot be parsed");
        }
        int byIndex = methodName.indexOf("By");
        if (byIndex == -1 || byIndex + 2 >= methodName.length()) {
            throw new UnableToParseMethodException("Repository method " + methodName + " cannot be parsed");
        }
        Integer topCount = null;
        int firstIndex = methodName.indexOf("First");
        int topIndex = methodName.indexOf("Top");
        if (firstIndex != -1 || topIndex != -1) {
            try {
                String topCountStr = methodName.substring(Math.max(firstIndex, topIndex), byIndex).replace("Top", "").replace("First", "");
                topCount = topCountStr.isEmpty() ? Integer.valueOf(1) : Integer.valueOf(topCountStr);
            }
            catch (Exception e) {
                throw new UnableToParseMethodException("Unable to parse query with limiting results clause. Offending method is " + methodName);
            }
        }
        if (topCount != null && queryType != QueryType.SELECT) {
            throw new UnableToParseMethodException("When 'Top' or 'First' is specified, the query must be a find query. Offending method is " + methodName);
        }
        if (methodName.substring(0, byIndex).contains("Distinct")) {
            throw new UnableToParseMethodException("Distinct is not yet supported. Offending method is " + methodName);
        }
        String afterByPart = methodName.substring(byIndex + 2);
        boolean allIgnoreCase = false;
        if (afterByPart.contains(ALL_IGNORE_CASE)) {
            allIgnoreCase = true;
            afterByPart = afterByPart.replace(ALL_IGNORE_CASE, "");
        }
        Sort sort = null;
        if (afterByPart.contains(ORDER_BY)) {
            int orderByIndex = afterByPart.indexOf(ORDER_BY);
            if (orderByIndex + ORDER_BY.length() == afterByPart.length()) {
                throw new UnableToParseMethodException("A field must by supplied after 'OrderBy' . Offending method is " + methodName);
            }
            String afterOrderByPart = afterByPart.substring(orderByIndex + ORDER_BY.length());
            afterByPart = afterByPart.substring(0, orderByIndex);
            boolean ascending = true;
            if (afterOrderByPart.endsWith("Asc")) {
                ascending = true;
                afterOrderByPart = afterOrderByPart.replace("Asc", "");
            } else if (afterOrderByPart.endsWith("Desc")) {
                ascending = false;
                afterOrderByPart = afterOrderByPart.replace("Desc", "");
            }
            String orderField = this.lowerFirstLetter(afterOrderByPart);
            if (!this.entityContainsField(orderField)) {
                throw new UnableToParseMethodException("Field " + orderField + " which was configured as the order field does not exist in the entity. Offending method is " + methodName);
            }
            sort = ascending ? Sort.ascending((String[])new String[]{orderField}) : Sort.descending((String[])new String[]{orderField});
        }
        List<String> parts = Collections.singletonList(afterByPart);
        boolean containsAnd = afterByPart.contains("And");
        boolean containsOr = afterByPart.contains("Or");
        if (containsAnd && containsOr) {
            throw new UnableToParseMethodException("'And' and 'Or' clauses cannot be mixed in a method name - Try specifying the Query with the @Query annotation. Offending method is " + methodName);
        }
        if (containsAnd) {
            parts = Arrays.asList(afterByPart.split("And"));
        } else if (containsOr) {
            parts = Arrays.asList(afterByPart.split("Or"));
        }
        StringBuilder where = new StringBuilder();
        int paramsCount = 0;
        for (String part : parts) {
            String operation;
            String fieldName;
            FieldInfo fieldInfo;
            if (part.isEmpty()) continue;
            boolean ignoreCase = false;
            if (part.endsWith(IGNORE_CASE)) {
                ignoreCase = true;
                part = part.replace(IGNORE_CASE, "");
            }
            if ((fieldInfo = this.getField(fieldName = (operation = this.getFieldOperation(part)) == null ? this.lowerFirstLetter(part) : this.lowerFirstLetter(part.replaceAll(operation, "")))) == null) {
                int associatedEntityFieldStartIndex;
                String parsingExceptionMethod = "Entity " + this.entityClass + " does not contain a field named: " + part + ". Offending method is " + methodName;
                int fieldEndIndex = -1;
                for (int i = 1; i < fieldName.length() - 1; ++i) {
                    char c = fieldName.charAt(i);
                    if ((c < 'A' || c > 'Z') && c != '_') continue;
                    fieldEndIndex = i;
                    break;
                }
                if (fieldEndIndex == -1) {
                    throw new UnableToParseMethodException(parsingExceptionMethod);
                }
                int n = associatedEntityFieldStartIndex = fieldName.charAt(fieldEndIndex) == '_' ? fieldEndIndex + 1 : fieldEndIndex;
                if (associatedEntityFieldStartIndex >= fieldName.length() - 1) {
                    throw new UnableToParseMethodException(parsingExceptionMethod);
                }
                String simpleFieldName = fieldName.substring(0, fieldEndIndex);
                String associatedEntityFieldName = this.lowerFirstLetter(fieldName.substring(associatedEntityFieldStartIndex));
                fieldInfo = this.getField(simpleFieldName);
                if (fieldInfo == null || !(fieldInfo.type() instanceof ClassType)) {
                    throw new UnableToParseMethodException(parsingExceptionMethod);
                }
                ClassInfo associatedEntityClassInfo = this.indexView.getClassByName(fieldInfo.type().name());
                if (associatedEntityClassInfo == null) {
                    throw new IllegalStateException("Entity class " + fieldInfo.type().name() + " was not part of the Quarkus index");
                }
                FieldInfo associatedEntityClassField = this.getAssociatedEntityClassField(associatedEntityFieldName, associatedEntityClassInfo);
                if (associatedEntityClassField == null) {
                    throw new UnableToParseMethodException(parsingExceptionMethod);
                }
                this.validateFieldWithOperation(operation, associatedEntityClassField, methodName);
                fieldName = simpleFieldName + "." + associatedEntityFieldName;
            } else {
                this.validateFieldWithOperation(operation, fieldInfo, methodName);
            }
            if ((ignoreCase || allIgnoreCase) && !DotNames.STRING.equals((Object)fieldInfo.type().name())) {
                throw new UnableToParseMethodException("IgnoreCase cannot be specified for field" + fieldInfo.name() + " of method " + methodName + " because it is not a String type");
            }
            if (where.length() > 0) {
                where.append(containsAnd ? " AND " : " OR ");
            }
            String upperPrefix = ignoreCase || allIgnoreCase ? "UPPER(" : "";
            String upperSuffix = ignoreCase || allIgnoreCase ? ")" : "";
            where.append(upperPrefix).append(fieldName).append(upperSuffix);
            if (operation == null || "Equals".equals(operation) || "Is".equals(operation)) {
                where.append(" = ").append(upperPrefix).append("?").append(++paramsCount).append(upperSuffix);
                continue;
            }
            switch (operation) {
                case "IsNot": 
                case "Not": {
                    where.append(" <> ?").append(++paramsCount);
                    break;
                }
                case "IsNull": 
                case "Null": {
                    where.append(" IS null ");
                    break;
                }
                case "IsNotNull": 
                case "NotNull": {
                    where.append(" IS NOT null ");
                    break;
                }
                case "Between": 
                case "IsBetween": {
                    where.append(" BETWEEN ");
                    where.append("?").append(++paramsCount).append(" AND ");
                    where.append("?").append(++paramsCount);
                    break;
                }
                case "LessThan": 
                case "IsLessThan": 
                case "Before": 
                case "IsBefore": {
                    where.append(" < ?").append(++paramsCount);
                    break;
                }
                case "LessThanEqual": 
                case "IsLessThanEqual": {
                    where.append(" <= ?").append(++paramsCount);
                    break;
                }
                case "GreaterThan": 
                case "IsGreaterThan": 
                case "After": 
                case "IsAfter": {
                    where.append(" > ?").append(++paramsCount);
                    break;
                }
                case "GreaterThanEqual": 
                case "IsGreaterThanEqual": {
                    where.append(" >= ?").append(++paramsCount);
                    break;
                }
                case "Like": 
                case "IsLike": {
                    where.append(" LIKE ?").append(++paramsCount);
                    break;
                }
                case "NotLike": 
                case "IsNotLike": {
                    where.append(" NOT LIKE ?").append(++paramsCount);
                    break;
                }
                case "IsStartingWith": 
                case "StartingWith": 
                case "StartsWith": {
                    where.append(" LIKE CONCAT(").append(upperPrefix).append("?").append(++paramsCount).append(upperSuffix).append(", '%')");
                    break;
                }
                case "IsEndingWith": 
                case "EndingWith": 
                case "EndsWith": {
                    where.append(" LIKE CONCAT('%', ").append(upperPrefix).append("?").append(++paramsCount).append(upperSuffix).append(")");
                    break;
                }
                case "IsContaining": 
                case "Containing": 
                case "Contains": {
                    where.append(" LIKE CONCAT('%', ").append(upperPrefix).append("?").append(++paramsCount).append(upperSuffix).append(", '%')");
                    break;
                }
                case "True": 
                case "False": {
                    where.append(" = ").append(operation.toLowerCase());
                    break;
                }
                case "IsIn": 
                case "In": {
                    where.append(" IN ?").append(++paramsCount);
                    break;
                }
                case "IsNotIn": 
                case "NotIn": {
                    where.append(" NOT IN ?").append(++paramsCount);
                    break;
                }
                case "IsEmpty": 
                case "Empty": {
                    where.append(" IS EMPTY");
                    break;
                }
                case "IsNotEmpty": 
                case "NotEmpty": {
                    where.append(" IS NOT EMPTY");
                }
            }
        }
        String whereQuery = where.toString().isEmpty() ? "" : " WHERE " + where.toString();
        return new Result(this.entityClass, "FROM " + this.getEntityName() + whereQuery, queryType, paramsCount, sort, topCount);
    }

    private FieldInfo getAssociatedEntityClassField(String associatedEntityFieldName, ClassInfo associatedEntityClassInfo) {
        FieldInfo fieldInfo = associatedEntityClassInfo.field(associatedEntityFieldName);
        if (fieldInfo != null) {
            return fieldInfo;
        }
        if (DotNames.OBJECT.equals((Object)associatedEntityClassInfo.superName())) {
            return null;
        }
        ClassInfo superClassInfo = this.indexView.getClassByName(associatedEntityClassInfo.superName());
        if (superClassInfo.classAnnotation(DotNames.JPA_MAPPED_SUPERCLASS) == null) {
            return null;
        }
        return this.getAssociatedEntityClassField(associatedEntityFieldName, superClassInfo);
    }

    private void validateFieldWithOperation(String operation, FieldInfo fieldInfo, String methodName) {
        DotName fieldTypeDotName = fieldInfo.type().name();
        if (STRING_LIKE_OPERATIONS.contains(operation) && !DotNames.STRING.equals((Object)fieldTypeDotName)) {
            throw new UnableToParseMethodException(operation + " cannot be specified for field" + fieldInfo.name() + " of method " + methodName + " because it is not a String type");
        }
        if (BOOLEAN_OPERATIONS.contains(operation) && !DotNames.BOOLEAN.equals((Object)fieldTypeDotName) && !DotNames.PRIMITIVE_BOOLEAN.equals((Object)fieldTypeDotName)) {
            throw new UnableToParseMethodException(operation + " cannot be specified for field" + fieldInfo.name() + " of method " + methodName + " because it is not a boolean type");
        }
    }

    private QueryType getType(String methodName) {
        if (methodName.startsWith("find") || methodName.startsWith("query") || methodName.startsWith("read") || methodName.startsWith("get")) {
            return QueryType.SELECT;
        }
        if (methodName.startsWith("count")) {
            return QueryType.COUNT;
        }
        if (methodName.startsWith("delete") || methodName.startsWith("remove")) {
            return QueryType.DELETE;
        }
        if (methodName.startsWith("exists")) {
            return QueryType.EXISTS;
        }
        return null;
    }

    private String getFieldOperation(String part) {
        ArrayList<String> matches = new ArrayList<String>();
        for (String handledPropertyOperation : HANDLED_PROPERTY_OPERATIONS) {
            if (!part.endsWith(handledPropertyOperation)) continue;
            matches.add(handledPropertyOperation);
        }
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() == 1) {
            return (String)matches.get(0);
        }
        matches.sort(Comparator.comparing(String::length).reversed());
        return (String)matches.get(0);
    }

    private String lowerFirstLetter(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        if (input.length() == 1) {
            return input.toLowerCase();
        }
        return Character.toLowerCase(input.charAt(0)) + input.substring(1);
    }

    private String getEntityName() {
        return this.entityClass.simpleName();
    }

    private boolean entityContainsField(String fieldName) {
        if (this.entityClass.field(fieldName) != null) {
            return true;
        }
        for (ClassInfo superClass : this.mappedSuperClassInfos) {
            FieldInfo fieldInfo = superClass.field(fieldName);
            if (fieldInfo == null) continue;
            return true;
        }
        return false;
    }

    private FieldInfo getField(String fieldName) {
        FieldInfo fieldInfo;
        block1: {
            ClassInfo superClass;
            fieldInfo = this.entityClass.field(fieldName);
            if (fieldInfo != null) break block1;
            Iterator<ClassInfo> iterator = this.mappedSuperClassInfos.iterator();
            while (iterator.hasNext() && (fieldInfo = (superClass = iterator.next()).field(fieldName)) == null) {
            }
        }
        return fieldInfo;
    }

    private List<ClassInfo> getMappedSuperClassInfos(IndexView indexView, ClassInfo entityClass) {
        ArrayList<ClassInfo> mappedSuperClassInfos = new ArrayList<ClassInfo>(3);
        Type superClassType = entityClass.superClassType();
        while (superClassType != null && !superClassType.name().equals((Object)DotNames.OBJECT)) {
            ClassInfo superClass = indexView.getClassByName(entityClass.superName());
            if (superClass.classAnnotation(DotNames.JPA_MAPPED_SUPERCLASS) != null) {
                mappedSuperClassInfos.add(superClass);
            }
            if (superClassType.kind() == Type.Kind.CLASS) {
                superClassType = indexView.getClassByName(superClassType.name()).superClassType();
                continue;
            }
            if (superClassType.kind() != Type.Kind.PARAMETERIZED_TYPE) continue;
            ParameterizedType parameterizedType = superClassType.asParameterizedType();
            superClassType = parameterizedType.owner();
        }
        if (mappedSuperClassInfos.size() > 0) {
            return mappedSuperClassInfos;
        }
        return Collections.emptyList();
    }

    public static class Result {
        private final ClassInfo entityClass;
        private final String query;
        private final QueryType queryType;
        private final int paramCount;
        private final Sort sort;
        private final Integer topCount;

        public Result(ClassInfo entityClass, String query, QueryType queryType, int paramCount, Sort sort, Integer topCount) {
            this.entityClass = entityClass;
            this.query = query;
            this.queryType = queryType;
            this.paramCount = paramCount;
            this.sort = sort;
            this.topCount = topCount;
        }

        public ClassInfo getEntityClass() {
            return this.entityClass;
        }

        public String getQuery() {
            return this.query;
        }

        public QueryType getQueryType() {
            return this.queryType;
        }

        public int getParamCount() {
            return this.paramCount;
        }

        public Sort getSort() {
            return this.sort;
        }

        public Integer getTopCount() {
            return this.topCount;
        }
    }

    public static enum QueryType {
        SELECT,
        COUNT,
        EXISTS,
        DELETE;

    }
}

