/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.data.deployment.generate;

import io.quarkus.deployment.bean.JavaBeanUtil;
import io.quarkus.deployment.util.HashUtil;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.hibernate.orm.panache.PanacheQuery;
import io.quarkus.hibernate.orm.panache.runtime.AdditionalJpaOperations;
import io.quarkus.hibernate.orm.panache.runtime.JpaOperations;
import io.quarkus.panache.common.Parameters;
import io.quarkus.panache.common.Sort;
import io.quarkus.spring.data.deployment.DotNames;
import io.quarkus.spring.data.deployment.MethodNameParser;
import io.quarkus.spring.data.deployment.generate.AbstractMethodsAdder;
import io.quarkus.spring.data.runtime.TypesConverter;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.transaction.Transactional;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class CustomQueryMethodsAdder
extends AbstractMethodsAdder {
    private static final String QUERY_VALUE_FIELD = "value";
    private static final String QUERY_COUNT_FIELD = "countQuery";
    private static final Pattern SELECT_CLAUSE = Pattern.compile("select\\s+(.+)\\s+from", 2);
    private static final Pattern FIELD_ALIAS = Pattern.compile(".*\\s+[as|AS]+\\s+([\\w\\.]+)");
    private static final Pattern FIELD_NAME = Pattern.compile("(\\w+).*");
    private final IndexView index;
    private final ClassOutput nonBeansClassOutput;
    private final Consumer<String> customClassCreatedCallback;

    public CustomQueryMethodsAdder(IndexView index, ClassOutput classOutput, Consumer<String> customClassCreatedCallback) {
        this.index = index;
        this.nonBeansClassOutput = classOutput;
        this.customClassCreatedCallback = customClassCreatedCallback;
    }

    public void add(ClassCreator classCreator, FieldDescriptor entityClassFieldDescriptor, ClassInfo repositoryClassInfo, ClassInfo entityClassInfo) {
        HashMap<DotName, Map> customResultTypes = new HashMap<DotName, Map>(3);
        HashMap<DotName, DotName> customResultTypeNames = new HashMap<DotName, DotName>(3);
        for (MethodInfo methodInfo : repositoryClassInfo.methods()) {
            boolean isModifying;
            AnnotationInstance queryInstance = methodInfo.annotation(DotNames.SPRING_DATA_QUERY);
            if (queryInstance == null) continue;
            String methodName = methodInfo.name();
            String repositoryName = repositoryClassInfo.name().toString();
            this.verifyQueryAnnotation(queryInstance, methodName, repositoryName);
            String queryString = queryInstance.value(QUERY_VALUE_FIELD).asString().trim();
            if (queryString.contains("#{")) {
                throw new IllegalArgumentException("spEL expressions are not currently supported. Offending method is " + methodName + " of Repository " + repositoryName);
            }
            if (!(queryString.startsWith("select") || queryString.startsWith("SELECT") || queryString.startsWith("from") || queryString.startsWith("FROM") || queryString.startsWith("delete") || queryString.startsWith("DELETE") || queryString.startsWith("update") || queryString.startsWith("UPDATE"))) {
                throw new IllegalArgumentException("Unsupported query type in @Query. Offending method is " + methodName + " of Repository " + repositoryName);
            }
            boolean useNamedParams = methodInfo.annotation(DotNames.SPRING_DATA_PARAM) != null;
            List methodParameterTypes = methodInfo.parameters();
            String[] methodParameterTypesStr = new String[methodParameterTypes.size()];
            ArrayList<Integer> queryParameterIndexes = new ArrayList<Integer>(methodParameterTypes.size());
            Integer pageableParameterIndex = null;
            Integer sortParameterIndex = null;
            for (int i = 0; i < methodParameterTypes.size(); ++i) {
                DotName parameterType = ((Type)methodParameterTypes.get(i)).name();
                methodParameterTypesStr[i] = parameterType.toString();
                if (DotNames.SPRING_DATA_PAGEABLE.equals((Object)parameterType) || DotNames.SPRING_DATA_PAGE_REQUEST.equals((Object)parameterType)) {
                    if (pageableParameterIndex != null) {
                        throw new IllegalArgumentException("Method " + methodInfo.name() + " of Repository " + repositoryClassInfo + "has invalid parameters - only a single parameter of type" + DotNames.SPRING_DATA_PAGEABLE + " can be specified");
                    }
                    pageableParameterIndex = i;
                    continue;
                }
                if (DotNames.SPRING_DATA_SORT.equals((Object)parameterType)) {
                    if (sortParameterIndex != null) {
                        throw new IllegalArgumentException("Method " + methodInfo.name() + " of Repository " + repositoryClassInfo + "has invalid parameters - only a single parameter of type" + DotNames.SPRING_DATA_SORT + " can be specified");
                    }
                    sortParameterIndex = i;
                    continue;
                }
                if (useNamedParams) continue;
                queryParameterIndexes.add(i);
            }
            HashMap<String, Integer> namedParameterToIndex = new HashMap<String, Integer>();
            List annotations = methodInfo.annotations();
            for (AnnotationInstance annotation : annotations) {
                if (annotation.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER || !DotNames.SPRING_DATA_PARAM.equals((Object)annotation.name())) continue;
                namedParameterToIndex.put(annotation.value().asString(), Integer.valueOf(annotation.target().asMethodParameter().position()));
            }
            boolean bl = isModifying = methodInfo.annotation(DotNames.SPRING_DATA_MODIFYING) != null;
            if (isModifying && (sortParameterIndex != null || pageableParameterIndex != null)) {
                throw new IllegalArgumentException(methodInfo.name() + " of Repository " + repositoryClassInfo + " is meant to be a insert/update/delete query and therefore doesn't support Pageable and Sort method parameters");
            }
            DotName methodReturnTypeDotName = methodInfo.returnType().name();
            MethodCreator methodCreator = classCreator.getMethodCreator(methodInfo.name(), methodReturnTypeDotName.toString(), methodParameterTypesStr);
            Throwable throwable = null;
            try {
                ResultHandle panacheQuery;
                if (isModifying) {
                    methodCreator.addAnnotation(Transactional.class);
                    if (queryString.toLowerCase().startsWith("delete")) {
                        ResultHandle deleteCount;
                        if (!(DotNames.PRIMITIVE_LONG.equals((Object)methodReturnTypeDotName) || DotNames.LONG.equals((Object)methodReturnTypeDotName) || DotNames.VOID.equals((Object)methodReturnTypeDotName))) {
                            throw new IllegalArgumentException(methodInfo.name() + " of Repository " + repositoryClassInfo + " is meant to be a delete query and can therefore only have a void or long return type");
                        }
                        String deleteQueryString = queryString.substring("delete".length());
                        if (useNamedParams) {
                            ResultHandle parameters = this.generateParametersObject(namedParameterToIndex, methodCreator);
                            deleteCount = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(JpaOperations.class, (String)"delete", Long.TYPE, (Class[])new Class[]{Class.class, String.class, Parameters.class}), new ResultHandle[]{methodCreator.readInstanceField(entityClassFieldDescriptor, methodCreator.getThis()), methodCreator.load(deleteQueryString), parameters});
                        } else {
                            ResultHandle paramsArray = this.generateParamsArray(queryParameterIndexes, methodCreator);
                            deleteCount = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(JpaOperations.class, (String)"delete", Long.TYPE, (Class[])new Class[]{Class.class, String.class, Object[].class}), new ResultHandle[]{methodCreator.readInstanceField(entityClassFieldDescriptor, methodCreator.getThis()), methodCreator.load(deleteQueryString), paramsArray});
                        }
                        if (DotNames.VOID.equals((Object)methodReturnTypeDotName)) {
                            methodCreator.returnValue(null);
                        }
                        this.handleLongReturnValue((BytecodeCreator)methodCreator, deleteCount, methodReturnTypeDotName);
                        continue;
                    }
                    if (queryString.toLowerCase().startsWith("update")) {
                        ResultHandle updateCount;
                        if (!(DotNames.PRIMITIVE_INTEGER.equals((Object)methodReturnTypeDotName) || DotNames.INTEGER.equals((Object)methodReturnTypeDotName) || DotNames.VOID.equals((Object)methodReturnTypeDotName))) {
                            throw new IllegalArgumentException(methodInfo.name() + " of Repository " + repositoryClassInfo + " is meant to be an update query and can therefore only have a void or integer return type");
                        }
                        if (useNamedParams) {
                            ResultHandle parameters = this.generateParametersObject(namedParameterToIndex, methodCreator);
                            ResultHandle parametersMap = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Parameters.class, (String)"map", Map.class, (Class[])new Class[0]), parameters, new ResultHandle[0]);
                            updateCount = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(JpaOperations.class, (String)"executeUpdate", Integer.TYPE, (Class[])new Class[]{String.class, Map.class}), new ResultHandle[]{methodCreator.load(queryString), parametersMap});
                        } else {
                            ResultHandle paramsArray = this.generateParamsArray(queryParameterIndexes, methodCreator);
                            updateCount = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(JpaOperations.class, (String)"executeUpdate", Integer.TYPE, (Class[])new Class[]{String.class, Object[].class}), new ResultHandle[]{methodCreator.load(queryString), paramsArray});
                        }
                        if (DotNames.VOID.equals((Object)methodReturnTypeDotName)) {
                            methodCreator.returnValue(null);
                        }
                        this.handleIntegerReturnValue((BytecodeCreator)methodCreator, updateCount, methodReturnTypeDotName);
                        continue;
                    }
                    throw new IllegalArgumentException(methodInfo.name() + " of Repository " + repositoryClassInfo + " has been annotated with @Modifying but the @Query does not appear to be a delete or update query");
                }
                String countQueryString = "SELECT COUNT(*) " + queryString;
                if (queryInstance.value(QUERY_COUNT_FIELD) != null) {
                    countQueryString = queryInstance.value(QUERY_COUNT_FIELD).asString().trim();
                } else {
                    MethodNameParser methodNameParser = new MethodNameParser(repositoryClassInfo, this.index);
                    try {
                        MethodNameParser.Result parseResult = methodNameParser.parse(methodInfo);
                        if (MethodNameParser.QueryType.SELECT == parseResult.getQueryType()) {
                            countQueryString = "SELECT COUNT (*) " + parseResult.getQuery();
                        }
                    }
                    catch (Exception parseResult) {
                        // empty catch block
                    }
                }
                Type resultType = this.verifyQueryResultType(methodInfo.returnType());
                DotName customResultTypeName = resultType.name();
                if (customResultTypeName.equals((Object)entityClassInfo.name()) || customResultTypeName.equals((Object)DotNames.OBJECT) || this.isIntLongOrBoolean(customResultTypeName)) {
                    customResultTypeName = null;
                } else {
                    List<String> fieldNames = this.getFieldNames(queryString);
                    ClassInfo resultClassInfo = this.index.getClassByName(customResultTypeName);
                    if (Modifier.isInterface(resultClassInfo.flags())) {
                        customResultTypeName = customResultTypeNames.computeIfAbsent(customResultTypeName, k -> this.createImplDotName(resultType.name()));
                        customResultTypes.computeIfAbsent(customResultTypeName, k -> new HashMap()).put(methodName, fieldNames);
                    } else {
                        throw new IllegalArgumentException("Query annotations may only use interfaces to map results to non-entity types. Offending query string is \"" + queryString + "\" on method " + methodName + " of Repository " + repositoryName);
                    }
                }
                if (useNamedParams) {
                    ResultHandle parameters = this.generateParametersObject(namedParameterToIndex, methodCreator);
                    panacheQuery = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(AdditionalJpaOperations.class, (String)"find", PanacheQuery.class, (Class[])new Class[]{Class.class, String.class, String.class, Sort.class, Parameters.class}), new ResultHandle[]{methodCreator.readInstanceField(entityClassFieldDescriptor, methodCreator.getThis()), methodCreator.load(queryString), methodCreator.load(countQueryString), this.generateSort(sortParameterIndex, methodCreator), parameters});
                } else {
                    ResultHandle paramsArray = this.generateParamsArray(queryParameterIndexes, methodCreator);
                    panacheQuery = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(AdditionalJpaOperations.class, (String)"find", PanacheQuery.class, (Class[])new Class[]{Class.class, String.class, String.class, Sort.class, Object[].class}), new ResultHandle[]{methodCreator.readInstanceField(entityClassFieldDescriptor, methodCreator.getThis()), methodCreator.load(queryString), methodCreator.load(countQueryString), this.generateSort(sortParameterIndex, methodCreator), paramsArray});
                }
                this.generateFindQueryResultHandling(methodCreator, panacheQuery, pageableParameterIndex, repositoryClassInfo, entityClassInfo, methodReturnTypeDotName, null, methodInfo.name(), customResultTypeName);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (methodCreator == null) continue;
                if (throwable != null) {
                    try {
                        methodCreator.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                methodCreator.close();
            }
        }
        for (Map.Entry entry : customResultTypeNames.entrySet()) {
            DotName interfaceName = (DotName)entry.getKey();
            DotName implName = (DotName)entry.getValue();
            this.generateCustomResultTypes(interfaceName, implName, (Map)customResultTypes.get(implName));
            this.customClassCreatedCallback.accept(implName.toString());
        }
    }

    private void verifyQueryAnnotation(AnnotationInstance queryInstance, String methodName, String repositoryName) {
        List values = queryInstance.values();
        for (AnnotationValue value : values) {
            if (QUERY_VALUE_FIELD.equals(value.name()) || QUERY_COUNT_FIELD.equals(value.name())) continue;
            throw new IllegalArgumentException("Attribute " + value.name() + " of @Query is currently not supported. Offending method is " + methodName + " of Repository " + repositoryName);
        }
        if (queryInstance.value(QUERY_VALUE_FIELD) == null) {
            throw new IllegalArgumentException("'value' attribute must be specified on @Query annotation of method. Offending method is " + methodName + " of Repository " + repositoryName);
        }
    }

    private ResultHandle generateParamsArray(List<Integer> queryParameterIndexes, MethodCreator methodCreator) {
        ResultHandle paramsArray = methodCreator.newArray(Object.class, queryParameterIndexes.size());
        for (int i = 0; i < queryParameterIndexes.size(); ++i) {
            methodCreator.writeArrayValue(paramsArray, methodCreator.load(i), methodCreator.getMethodParam(queryParameterIndexes.get(i).intValue()));
        }
        return paramsArray;
    }

    private ResultHandle generateParametersObject(Map<String, Integer> namedParameterToIndex, MethodCreator methodCreator) {
        ResultHandle parameters = methodCreator.newInstance(MethodDescriptor.ofConstructor(Parameters.class, (Class[])new Class[0]), new ResultHandle[0]);
        for (Map.Entry<String, Integer> entry : namedParameterToIndex.entrySet()) {
            methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Parameters.class, (String)"and", Parameters.class, (Class[])new Class[]{String.class, Object.class}), parameters, new ResultHandle[]{methodCreator.load(entry.getKey()), methodCreator.getMethodParam(entry.getValue().intValue())});
        }
        return parameters;
    }

    private ResultHandle generateSort(Integer sortParameterIndex, MethodCreator methodCreator) {
        ResultHandle sort = methodCreator.loadNull();
        if (sortParameterIndex != null) {
            sort = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(TypesConverter.class, (String)"toPanacheSort", Sort.class, (Class[])new Class[]{org.springframework.data.domain.Sort.class}), new ResultHandle[]{methodCreator.getMethodParam(sortParameterIndex.intValue())});
        }
        return sort;
    }

    private Type verifyQueryResultType(Type t) {
        ClassInfo typeClassInfo;
        if (this.isIntLongOrBoolean(t.name())) {
            return t;
        }
        if (t.kind() == Type.Kind.ARRAY) {
            return this.verifyQueryResultType(t.asArrayType().component());
        }
        if (t.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            List list = t.asParameterizedType().arguments();
            if (list.size() == 1) {
                return this.verifyQueryResultType((Type)list.get(0));
            }
            for (Type x : list) {
                this.verifyQueryResultType(x);
            }
            return t;
        }
        if (!DotNames.OBJECT.equals((Object)t.name()) && (typeClassInfo = this.index.getClassByName(t.name())) == null) {
            throw new IllegalStateException(t.name() + " was not part of the Quarkus index");
        }
        return t;
    }

    private List<String> getFieldNames(String queryString) {
        Matcher matcher = SELECT_CLAUSE.matcher(queryString);
        if (matcher.find()) {
            String selectClause = matcher.group(1).trim();
            String[] fields = selectClause.split("\\s*,\\s+");
            ArrayList<String> fieldNames = new ArrayList<String>(fields.length);
            for (String name : fields) {
                Matcher m = FIELD_ALIAS.matcher(name);
                if (m.matches()) {
                    name = m.group(1);
                } else {
                    Matcher n = FIELD_NAME.matcher(name);
                    if (n.matches()) {
                        name = n.group(1);
                    }
                }
                fieldNames.add(name.toLowerCase());
            }
            return fieldNames;
        }
        return Collections.emptyList();
    }

    private DotName createImplDotName(DotName ifaceName) {
        String fullName = ifaceName.toString();
        int index = fullName.lastIndexOf(46);
        String packageName = "";
        if (index > 0 && index < fullName.length() - 1) {
            packageName = fullName.substring(0, index) + ".";
        }
        return DotName.createSimple((String)(packageName + (ifaceName.isInner() ? ifaceName.local() : ifaceName.withoutPackagePrefix()) + "_" + HashUtil.sha1((String)ifaceName.toString())));
    }

    private void generateCustomResultTypes(DotName interfaceName, DotName implName, Map<String, List<String>> queryMethods) {
        ClassInfo interfaceInfo = this.index.getClassByName(interfaceName);
        try (ClassCreator implClassCreator = ClassCreator.builder().classOutput(this.nonBeansClassOutput).interfaces(new String[]{interfaceName.toString()}).className(implName.toString()).build();){
            HashMap<String, FieldDescriptor> fields = new HashMap<String, FieldDescriptor>(3);
            for (MethodInfo methodInfo : interfaceInfo.methods()) {
                String getterName = methodInfo.name();
                String propertyName = JavaBeanUtil.getPropertyNameFromGetter((String)getterName);
                Type returnType = methodInfo.returnType();
                if (returnType.kind() == Type.Kind.VOID) {
                    throw new IllegalArgumentException("Method " + methodInfo.name() + " of interface " + interfaceName + " is not a getter method since it returns void");
                }
                DotName fieldTypeName = this.getPrimitiveTypeName(returnType.name());
                FieldDescriptor field = implClassCreator.getFieldCreator(propertyName, fieldTypeName.toString()).getFieldDescriptor();
                try (MethodCreator getter = implClassCreator.getMethodCreator(getterName, returnType.toString(), new String[0]);){
                    getter.setModifiers(1);
                    getter.returnValue(getter.readInstanceField(field, getter.getThis()));
                }
                fields.put(propertyName.toLowerCase(), field);
            }
            for (Map.Entry entry : queryMethods.entrySet()) {
                MethodCreator convert = implClassCreator.getMethodCreator("convert_" + (String)entry.getKey(), implName.toString(), new String[]{Object[].class.getName()});
                Throwable throwable = null;
                try {
                    convert.setModifiers(8);
                    ResultHandle newObject = convert.newInstance(MethodDescriptor.ofConstructor((String)implName.toString(), (String[])new String[0]), new ResultHandle[0]);
                    List queryNames = (List)entry.getValue();
                    ResultHandle array = convert.getMethodParam(0);
                    for (int i = 0; i < queryNames.size(); ++i) {
                        FieldDescriptor f = (FieldDescriptor)fields.get(queryNames.get(i));
                        if (f == null) {
                            throw new IllegalArgumentException("@Query annotation for " + (String)entry.getKey() + " does not use fields from " + interfaceName);
                        }
                        convert.writeInstanceField(f, newObject, this.castReturnValue(convert, convert.readArrayValue(array, i), f.getType()));
                    }
                    convert.returnValue(newObject);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (convert == null) continue;
                    if (throwable != null) {
                        try {
                            convert.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    convert.close();
                }
            }
        }
    }

    private ResultHandle castReturnValue(MethodCreator methodCreator, ResultHandle resultHandle, String type) {
        switch (type) {
            case "I": {
                resultHandle = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(Integer.class, (String)"valueOf", Integer.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{resultHandle});
                break;
            }
            case "J": {
                resultHandle = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(Long.class, (String)"valueOf", Long.class, (Class[])new Class[]{Long.TYPE}), new ResultHandle[]{resultHandle});
            }
        }
        return resultHandle;
    }

    private DotName getPrimitiveTypeName(DotName returnTypeName) {
        if (DotNames.LONG.equals((Object)returnTypeName)) {
            return DotNames.PRIMITIVE_LONG;
        }
        if (DotNames.INTEGER.equals((Object)returnTypeName)) {
            return DotNames.PRIMITIVE_INTEGER;
        }
        if (DotNames.BOOLEAN.equals((Object)returnTypeName)) {
            return DotNames.PRIMITIVE_BOOLEAN;
        }
        return returnTypeName;
    }
}

