/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.data.deployment.generate;

import io.quarkus.deployment.bean.JavaBeanUtil;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.hibernate.orm.panache.PanacheQuery;
import io.quarkus.hibernate.orm.panache.runtime.JpaOperations;
import io.quarkus.panache.common.Sort;
import io.quarkus.spring.data.deployment.DotNames;
import io.quarkus.spring.data.deployment.generate.GenerationUtil;
import io.quarkus.spring.data.runtime.FunctionalityNotImplemented;
import io.quarkus.spring.data.runtime.RepositorySupport;
import io.quarkus.spring.data.runtime.TypesConverter;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.transaction.Transactional;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class StockMethodsAdder {
    private static Set<MethodInfo> ALL_SPRING_DATA_REPOSITORY_METHODS = null;
    private final IndexView index;

    public StockMethodsAdder(IndexView index) {
        this.index = index;
    }

    public void add(ClassCreator classCreator, FieldDescriptor entityClassFieldDescriptor, String generatedClassName, ClassInfo repositoryToImplement, DotName entityDotName, String idTypeStr) {
        Set<MethodInfo> methodsOfExtendedSpringDataRepositories = this.methodsOfExtendedSpringDataRepositories(repositoryToImplement);
        Set<MethodInfo> stockMethodsAddedToInterface = this.stockMethodsAddedToInterface(repositoryToImplement);
        HashSet<MethodInfo> allMethodsToBeImplemented = new HashSet<MethodInfo>(methodsOfExtendedSpringDataRepositories);
        allMethodsToBeImplemented.addAll(stockMethodsAddedToInterface);
        HashMap<MethodDescriptor, Boolean> allMethodsToBeImplementedToResult = new HashMap<MethodDescriptor, Boolean>();
        for (MethodInfo methodInfo : allMethodsToBeImplemented) {
            allMethodsToBeImplementedToResult.put(GenerationUtil.toMethodDescriptor(generatedClassName, methodInfo), false);
        }
        String entityTypeStr = entityDotName.toString();
        this.generateSave(classCreator, entityClassFieldDescriptor, generatedClassName, entityDotName, entityTypeStr, allMethodsToBeImplementedToResult);
        this.generateSaveAndFlush(classCreator, entityClassFieldDescriptor, generatedClassName, entityDotName, entityTypeStr, allMethodsToBeImplementedToResult);
        this.generateSaveAll(classCreator, entityClassFieldDescriptor, generatedClassName, entityDotName, entityTypeStr, allMethodsToBeImplementedToResult);
        this.generateFlush(classCreator, generatedClassName, allMethodsToBeImplementedToResult);
        this.generateFindById(classCreator, entityClassFieldDescriptor, generatedClassName, entityTypeStr, idTypeStr, allMethodsToBeImplementedToResult);
        this.generateExistsById(classCreator, entityClassFieldDescriptor, generatedClassName, entityTypeStr, idTypeStr, allMethodsToBeImplementedToResult);
        this.generateGetOne(classCreator, entityClassFieldDescriptor, generatedClassName, entityTypeStr, idTypeStr, allMethodsToBeImplementedToResult);
        this.generateFindAll(classCreator, entityClassFieldDescriptor, generatedClassName, entityTypeStr, allMethodsToBeImplementedToResult);
        this.generateFindAllWithSort(classCreator, entityClassFieldDescriptor, generatedClassName, entityTypeStr, allMethodsToBeImplementedToResult);
        this.generateFindAllWithPageable(classCreator, entityClassFieldDescriptor, generatedClassName, entityTypeStr, allMethodsToBeImplementedToResult);
        this.generateFindAllById(classCreator, entityClassFieldDescriptor, generatedClassName, entityDotName, entityTypeStr, idTypeStr, allMethodsToBeImplementedToResult);
        this.generateCount(classCreator, entityClassFieldDescriptor, generatedClassName, allMethodsToBeImplementedToResult);
        this.generateDeleteById(classCreator, entityClassFieldDescriptor, generatedClassName, entityTypeStr, idTypeStr, allMethodsToBeImplementedToResult);
        this.generateDelete(classCreator, generatedClassName, entityTypeStr, allMethodsToBeImplementedToResult);
        this.generateDeleteAllWithIterable(classCreator, generatedClassName, entityTypeStr, allMethodsToBeImplementedToResult);
        this.generateDeleteAll(classCreator, entityClassFieldDescriptor, generatedClassName, allMethodsToBeImplementedToResult);
        this.handleUnimplementedMethods(classCreator, allMethodsToBeImplementedToResult);
    }

    private void generateSave(ClassCreator classCreator, FieldDescriptor entityClassFieldDescriptor, String generatedClassName, DotName entityDotName, String entityTypeStr, Map<MethodDescriptor, Boolean> allMethodsToBeImplementedToResult) {
        MethodDescriptor saveDescriptor = MethodDescriptor.ofMethod((String)generatedClassName, (String)"save", (String)entityTypeStr, (String[])new String[]{entityTypeStr});
        MethodDescriptor bridgeSaveDescriptor = MethodDescriptor.ofMethod((Object)generatedClassName, (String)"save", Object.class, (Object[])new Object[]{Object.class});
        if (allMethodsToBeImplementedToResult.containsKey(saveDescriptor) || allMethodsToBeImplementedToResult.containsKey(bridgeSaveDescriptor)) {
            if (!classCreator.getExistingMethods().contains(saveDescriptor)) {
                try (MethodCreator save = classCreator.getMethodCreator(saveDescriptor);){
                    BytecodeCreator idValueUnset;
                    BytecodeCreator idValueSet;
                    save.addAnnotation(Transactional.class);
                    ResultHandle entity = save.getMethodParam(0);
                    AnnotationTarget idAnnotationTarget = this.getIdAnnotationTarget(entityDotName, this.index);
                    ResultHandle idValue = this.generateReadIdValue(save, entityDotName, entity, idAnnotationTarget);
                    Type idType = this.getIdType(idAnnotationTarget);
                    if (idType instanceof PrimitiveType) {
                        BranchResult idValueNonZeroBranch = save.ifNonZero(idValue);
                        idValueSet = idValueNonZeroBranch.trueBranch();
                        idValueUnset = idValueNonZeroBranch.falseBranch();
                    } else {
                        BranchResult idValueNullBranch = save.ifNull(idValue);
                        idValueSet = idValueNullBranch.falseBranch();
                        idValueUnset = idValueNullBranch.trueBranch();
                    }
                    idValueUnset.invokeStaticMethod(MethodDescriptor.ofMethod(JpaOperations.class, (String)"persist", Void.TYPE, (Class[])new Class[]{Object.class}), new ResultHandle[]{entity});
                    idValueUnset.returnValue(entity);
                    ResultHandle entityManager = idValueSet.invokeStaticMethod(MethodDescriptor.ofMethod(JpaOperations.class, (String)"getEntityManager", EntityManager.class, (Class[])new Class[0]), new ResultHandle[0]);
                    entity = idValueSet.invokeInterfaceMethod(MethodDescriptor.ofMethod(EntityManager.class, (String)"merge", Object.class, (Class[])new Class[]{Object.class}), entityManager, new ResultHandle[]{entity});
                    idValueSet.returnValue(entity);
                }
                var10_10 = null;
                try (MethodCreator bridgeSave = classCreator.getMethodCreator(bridgeSaveDescriptor);){
                    MethodDescriptor save = MethodDescriptor.ofMethod((String)generatedClassName, (String)"save", (String)entityTypeStr, (String[])new String[]{entityTypeStr});
                    ResultHandle methodParam = bridgeSave.getMethodParam(0);
                    ResultHandle castedMethodParam = bridgeSave.checkCast(methodParam, entityTypeStr);
                    ResultHandle result = bridgeSave.invokeVirtualMethod(save, bridgeSave.getThis(), new ResultHandle[]{castedMethodParam});
                    bridgeSave.returnValue(result);
                }
                catch (Throwable throwable) {
                    var10_10 = throwable;
                    throw throwable;
                }
            }
            allMethodsToBeImplementedToResult.put(saveDescriptor, true);
            allMethodsToBeImplementedToResult.put(bridgeSaveDescriptor, true);
        }
    }

    private ResultHandle generateReadIdValue(MethodCreator methodCreator, DotName entityDotName, ResultHandle entity, AnnotationTarget annotationTarget) {
        if (annotationTarget instanceof FieldInfo) {
            FieldInfo fieldInfo = annotationTarget.asField();
            if (Modifier.isPublic(fieldInfo.flags())) {
                return methodCreator.readInstanceField(FieldDescriptor.of((FieldInfo)fieldInfo), entity);
            }
            String getterMethodName = JavaBeanUtil.getGetterName((String)fieldInfo.name(), (DotName)fieldInfo.type().name());
            return methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod((String)entityDotName.toString(), (String)getterMethodName, (String)fieldInfo.type().name().toString(), (String[])new String[0]), entity, new ResultHandle[0]);
        }
        MethodInfo methodInfo = annotationTarget.asMethod();
        return methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod((String)entityDotName.toString(), (String)methodInfo.name(), (String)methodInfo.returnType().name().toString(), (String[])new String[0]), entity, new ResultHandle[0]);
    }

    private Type getIdType(AnnotationTarget idAnnotationTarget) {
        if (idAnnotationTarget instanceof FieldInfo) {
            return idAnnotationTarget.asField().type();
        }
        return idAnnotationTarget.asMethod().returnType();
    }

    private void generateSaveAndFlush(ClassCreator classCreator, FieldDescriptor entityClassFieldDescriptor, String generatedClassName, DotName entityDotName, String entityTypeStr, Map<MethodDescriptor, Boolean> allMethodsToBeImplementedToResult) {
        MethodDescriptor saveAndFlushDescriptor = MethodDescriptor.ofMethod((String)generatedClassName, (String)"saveAndFlush", (String)entityTypeStr, (String[])new String[]{entityTypeStr});
        MethodDescriptor bridgeSaveAndFlushDescriptor = MethodDescriptor.ofMethod((Object)generatedClassName, (String)"saveAndFlush", Object.class, (Object[])new Object[]{Object.class});
        if (allMethodsToBeImplementedToResult.containsKey(saveAndFlushDescriptor) || allMethodsToBeImplementedToResult.containsKey(bridgeSaveAndFlushDescriptor)) {
            if (!classCreator.getExistingMethods().contains(saveAndFlushDescriptor)) {
                MethodDescriptor save = MethodDescriptor.ofMethod((String)generatedClassName, (String)"save", (String)entityTypeStr, (String[])new String[]{entityTypeStr});
                allMethodsToBeImplementedToResult.put(save, false);
                this.generateSave(classCreator, entityClassFieldDescriptor, generatedClassName, entityDotName, entityTypeStr, allMethodsToBeImplementedToResult);
                try (MethodCreator saveAndFlush = classCreator.getMethodCreator(saveAndFlushDescriptor);){
                    saveAndFlush.addAnnotation(Transactional.class);
                    ResultHandle entity = saveAndFlush.getMethodParam(0);
                    entity = saveAndFlush.invokeVirtualMethod(save, saveAndFlush.getThis(), new ResultHandle[]{entity});
                    saveAndFlush.invokeStaticMethod(MethodDescriptor.ofMethod(JpaOperations.class, (String)"flush", Void.TYPE, (Class[])new Class[0]), new ResultHandle[0]);
                    saveAndFlush.returnValue(entity);
                }
                var11_11 = null;
                try (MethodCreator bridgeSave = classCreator.getMethodCreator(bridgeSaveAndFlushDescriptor);){
                    MethodDescriptor saveAndFlush = MethodDescriptor.ofMethod((String)generatedClassName, (String)"saveAndFlush", (String)entityTypeStr, (String[])new String[]{entityTypeStr});
                    ResultHandle methodParam = bridgeSave.getMethodParam(0);
                    ResultHandle castedMethodParam = bridgeSave.checkCast(methodParam, entityTypeStr);
                    ResultHandle result = bridgeSave.invokeVirtualMethod(saveAndFlush, bridgeSave.getThis(), new ResultHandle[]{castedMethodParam});
                    bridgeSave.returnValue(result);
                }
                catch (Throwable throwable) {
                    var11_11 = throwable;
                    throw throwable;
                }
            }
            allMethodsToBeImplementedToResult.put(saveAndFlushDescriptor, true);
            allMethodsToBeImplementedToResult.put(bridgeSaveAndFlushDescriptor, true);
        }
    }

    private void generateSaveAll(ClassCreator classCreator, FieldDescriptor entityClassFieldDescriptor, String generatedClassName, DotName entityDotName, String entityTypeStr, Map<MethodDescriptor, Boolean> allMethodsToBeImplementedToResult) {
        MethodDescriptor saveAllDescriptor = MethodDescriptor.ofMethod((Object)generatedClassName, (String)"saveAll", List.class, (Object[])new Object[]{Iterable.class});
        MethodDescriptor bridgeSaveAllDescriptor = MethodDescriptor.ofMethod((Object)generatedClassName, (String)"saveAll", Iterable.class, (Object[])new Object[]{Iterable.class});
        if (allMethodsToBeImplementedToResult.containsKey(saveAllDescriptor) || allMethodsToBeImplementedToResult.containsKey(bridgeSaveAllDescriptor)) {
            if (!classCreator.getExistingMethods().contains(saveAllDescriptor)) {
                MethodDescriptor save = MethodDescriptor.ofMethod((String)generatedClassName, (String)"save", (String)entityTypeStr, (String[])new String[]{entityTypeStr});
                try (MethodCreator saveAll = classCreator.getMethodCreator(saveAllDescriptor);){
                    saveAll.setSignature(String.format("<S:L%s;>(Ljava/lang/Iterable<TS;>;)Ljava/util/List<TS;>;", entityTypeStr.replace('.', '/')));
                    saveAll.addAnnotation(Transactional.class);
                    ResultHandle iterable = saveAll.getMethodParam(0);
                    ResultHandle resultList = saveAll.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
                    ResultHandle iterator = saveAll.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterable.class, (String)"iterator", Iterator.class, (Class[])new Class[0]), iterable, new ResultHandle[0]);
                    BytecodeCreator loop = saveAll.createScope();
                    ResultHandle hasNextValue = loop.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"hasNext", Boolean.TYPE, (Class[])new Class[0]), iterator, new ResultHandle[0]);
                    BranchResult hasNextBranch = loop.ifNonZero(hasNextValue);
                    BytecodeCreator hasNext = hasNextBranch.trueBranch();
                    BytecodeCreator doesNotHaveNext = hasNextBranch.falseBranch();
                    ResultHandle next = hasNext.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"next", Object.class, (Class[])new Class[0]), iterator, new ResultHandle[0]);
                    ResultHandle saveResult = hasNext.invokeVirtualMethod(save, hasNext.getThis(), new ResultHandle[]{next});
                    hasNext.invokeInterfaceMethod(MethodDescriptor.ofMethod(List.class, (String)"add", Boolean.TYPE, (Class[])new Class[]{Object.class}), resultList, new ResultHandle[]{saveResult});
                    hasNext.continueScope(loop);
                    doesNotHaveNext.breakScope(loop);
                    saveAll.returnValue(resultList);
                }
                var11_11 = null;
                try (MethodCreator bridgeSaveAll = classCreator.getMethodCreator(bridgeSaveAllDescriptor);){
                    MethodDescriptor saveAll = MethodDescriptor.ofMethod((Object)generatedClassName, (String)"saveAll", (Object)List.class.getName(), (Object[])new Object[]{Iterable.class});
                    ResultHandle result = bridgeSaveAll.invokeVirtualMethod(saveAll, bridgeSaveAll.getThis(), new ResultHandle[]{bridgeSaveAll.getMethodParam(0)});
                    bridgeSaveAll.returnValue(result);
                }
                catch (Throwable throwable) {
                    var11_11 = throwable;
                    throw throwable;
                }
            }
            allMethodsToBeImplementedToResult.put(saveAllDescriptor, true);
            allMethodsToBeImplementedToResult.put(bridgeSaveAllDescriptor, true);
        }
    }

    private void generateFlush(ClassCreator classCreator, String generatedClassName, Map<MethodDescriptor, Boolean> allMethodsToBeImplementedToResult) {
        MethodDescriptor flushDescriptor = MethodDescriptor.ofMethod((String)generatedClassName, (String)"flush", (String)Void.TYPE.getName(), (String[])new String[0]);
        if (allMethodsToBeImplementedToResult.containsKey(flushDescriptor)) {
            if (!classCreator.getExistingMethods().contains(flushDescriptor)) {
                try (MethodCreator flush = classCreator.getMethodCreator(flushDescriptor);){
                    flush.addAnnotation(Transactional.class);
                    flush.invokeStaticMethod(MethodDescriptor.ofMethod(JpaOperations.class, (String)"flush", Void.TYPE, (Class[])new Class[0]), new ResultHandle[0]);
                    flush.returnValue(null);
                }
            }
            allMethodsToBeImplementedToResult.put(flushDescriptor, true);
        }
    }

    private void generateFindById(ClassCreator classCreator, FieldDescriptor entityClassFieldDescriptor, String generatedClassName, String entityTypeStr, String idTypeStr, Map<MethodDescriptor, Boolean> allMethodsToBeImplementedToResult) {
        MethodDescriptor findByIdDescriptor = MethodDescriptor.ofMethod((String)generatedClassName, (String)"findById", (String)Optional.class.getName(), (String[])new String[]{idTypeStr});
        MethodDescriptor bridgeFindByIdDescriptor = MethodDescriptor.ofMethod((Object)generatedClassName, (String)"findById", (Object)Optional.class.getName(), (Object[])new Object[]{Object.class});
        if (allMethodsToBeImplementedToResult.containsKey(findByIdDescriptor) || allMethodsToBeImplementedToResult.containsKey(bridgeFindByIdDescriptor)) {
            if (!classCreator.getExistingMethods().contains(findByIdDescriptor)) {
                try (MethodCreator findById = classCreator.getMethodCreator(findByIdDescriptor);){
                    findById.setSignature(String.format("(L%s;)Ljava/util/Optional<L%s;>;", idTypeStr.replace('.', '/'), entityTypeStr.replace('.', '/')));
                    ResultHandle id = findById.getMethodParam(0);
                    ResultHandle entity = findById.invokeStaticMethod(MethodDescriptor.ofMethod(JpaOperations.class, (String)"findById", Object.class, (Class[])new Class[]{Class.class, Object.class}), new ResultHandle[]{findById.readInstanceField(entityClassFieldDescriptor, findById.getThis()), id});
                    ResultHandle optional = findById.invokeStaticMethod(MethodDescriptor.ofMethod(Optional.class, (String)"ofNullable", Optional.class, (Class[])new Class[]{Object.class}), new ResultHandle[]{entity});
                    findById.returnValue(optional);
                }
                var10_10 = null;
                try (MethodCreator bridgeFindById = classCreator.getMethodCreator(bridgeFindByIdDescriptor);){
                    MethodDescriptor findById = MethodDescriptor.ofMethod((String)generatedClassName, (String)"findById", (String)Optional.class.getName(), (String[])new String[]{idTypeStr});
                    ResultHandle methodParam = bridgeFindById.getMethodParam(0);
                    ResultHandle castedMethodParam = bridgeFindById.checkCast(methodParam, idTypeStr);
                    ResultHandle result = bridgeFindById.invokeVirtualMethod(findById, bridgeFindById.getThis(), new ResultHandle[]{castedMethodParam});
                    bridgeFindById.returnValue(result);
                }
                catch (Throwable throwable) {
                    var10_10 = throwable;
                    throw throwable;
                }
            }
            allMethodsToBeImplementedToResult.put(findByIdDescriptor, true);
            allMethodsToBeImplementedToResult.put(bridgeFindByIdDescriptor, true);
        }
    }

    private void generateExistsById(ClassCreator classCreator, FieldDescriptor entityClassFieldDescriptor, String generatedClassName, String entityTypeStr, String idTypeStr, Map<MethodDescriptor, Boolean> allMethodsToBeImplementedToResult) {
        MethodDescriptor existsByIdDescriptor = MethodDescriptor.ofMethod((Object)generatedClassName, (String)"existsById", Boolean.TYPE, (Object[])new Object[]{idTypeStr});
        MethodDescriptor bridgeExistsByIdDescriptor = MethodDescriptor.ofMethod((Object)generatedClassName, (String)"existsById", Boolean.TYPE, (Object[])new Object[]{Object.class});
        if (allMethodsToBeImplementedToResult.containsKey(existsByIdDescriptor) || allMethodsToBeImplementedToResult.containsKey(bridgeExistsByIdDescriptor)) {
            if (!classCreator.getExistingMethods().contains(existsByIdDescriptor)) {
                MethodDescriptor findById = MethodDescriptor.ofMethod((String)generatedClassName, (String)"findById", (String)Optional.class.getName(), (String[])new String[]{idTypeStr});
                allMethodsToBeImplementedToResult.put(findById, false);
                this.generateFindById(classCreator, entityClassFieldDescriptor, generatedClassName, entityTypeStr, idTypeStr, allMethodsToBeImplementedToResult);
                try (MethodCreator existsById = classCreator.getMethodCreator(existsByIdDescriptor);){
                    ResultHandle methodParam = existsById.getMethodParam(0);
                    ResultHandle optional = existsById.invokeVirtualMethod(findById, existsById.getThis(), new ResultHandle[]{methodParam});
                    ResultHandle isPresent = existsById.invokeVirtualMethod(MethodDescriptor.ofMethod(Optional.class, (String)"isPresent", Boolean.TYPE, (Class[])new Class[0]), optional, new ResultHandle[0]);
                    existsById.returnValue(isPresent);
                }
                var11_11 = null;
                try (MethodCreator bridgeExistsById = classCreator.getMethodCreator(bridgeExistsByIdDescriptor);){
                    MethodDescriptor existsById = MethodDescriptor.ofMethod((String)generatedClassName, (String)"existsById", (String)Boolean.TYPE.getName(), (String[])new String[]{idTypeStr});
                    ResultHandle methodParam = bridgeExistsById.getMethodParam(0);
                    ResultHandle castedMethodParam = bridgeExistsById.checkCast(methodParam, idTypeStr);
                    ResultHandle result = bridgeExistsById.invokeVirtualMethod(existsById, bridgeExistsById.getThis(), new ResultHandle[]{castedMethodParam});
                    bridgeExistsById.returnValue(result);
                }
                catch (Throwable throwable) {
                    var11_11 = throwable;
                    throw throwable;
                }
            }
            allMethodsToBeImplementedToResult.put(existsByIdDescriptor, true);
            allMethodsToBeImplementedToResult.put(bridgeExistsByIdDescriptor, true);
        }
    }

    private void generateGetOne(ClassCreator classCreator, FieldDescriptor entityClassFieldDescriptor, String generatedClassName, String entityTypeStr, String idTypeStr, Map<MethodDescriptor, Boolean> allMethodsToBeImplementedToResult) {
        MethodDescriptor getOneDescriptor = MethodDescriptor.ofMethod((String)generatedClassName, (String)"getOne", (String)entityTypeStr, (String[])new String[]{idTypeStr});
        MethodDescriptor bridgeGetOneDescriptor = MethodDescriptor.ofMethod((Object)generatedClassName, (String)"getOne", Object.class, (Object[])new Object[]{Object.class});
        if (allMethodsToBeImplementedToResult.containsKey(getOneDescriptor) || allMethodsToBeImplementedToResult.containsKey(bridgeGetOneDescriptor)) {
            if (!classCreator.getExistingMethods().contains(getOneDescriptor)) {
                try (MethodCreator findById = classCreator.getMethodCreator(getOneDescriptor);){
                    ResultHandle id = findById.getMethodParam(0);
                    ResultHandle entity = findById.invokeStaticMethod(MethodDescriptor.ofMethod(RepositorySupport.class, (String)"getOne", Object.class, (Class[])new Class[]{Class.class, Object.class}), new ResultHandle[]{findById.readInstanceField(entityClassFieldDescriptor, findById.getThis()), id});
                    findById.returnValue(entity);
                }
                var10_10 = null;
                try (MethodCreator bridgeGetOne = classCreator.getMethodCreator(bridgeGetOneDescriptor);){
                    MethodDescriptor getOne = MethodDescriptor.ofMethod((String)generatedClassName, (String)"getOne", (String)entityTypeStr, (String[])new String[]{idTypeStr});
                    ResultHandle methodParam = bridgeGetOne.getMethodParam(0);
                    ResultHandle castedMethodParam = bridgeGetOne.checkCast(methodParam, idTypeStr);
                    ResultHandle result = bridgeGetOne.invokeVirtualMethod(getOne, bridgeGetOne.getThis(), new ResultHandle[]{castedMethodParam});
                    bridgeGetOne.returnValue(result);
                }
                catch (Throwable throwable) {
                    var10_10 = throwable;
                    throw throwable;
                }
            }
            allMethodsToBeImplementedToResult.put(getOneDescriptor, true);
            allMethodsToBeImplementedToResult.put(bridgeGetOneDescriptor, true);
        }
    }

    private void generateFindAll(ClassCreator classCreator, FieldDescriptor entityClassFieldDescriptor, String generatedClassName, String entityTypeStr, Map<MethodDescriptor, Boolean> allMethodsToBeImplementedToResult) {
        MethodDescriptor findAllDescriptor = MethodDescriptor.ofMethod((Object)generatedClassName, (String)"findAll", List.class, (Object[])new Object[0]);
        MethodDescriptor bridgeFindAllDescriptor = MethodDescriptor.ofMethod((Object)generatedClassName, (String)"findAll", Iterable.class, (Object[])new Object[0]);
        if (allMethodsToBeImplementedToResult.containsKey(findAllDescriptor) || allMethodsToBeImplementedToResult.containsKey(bridgeFindAllDescriptor)) {
            if (!classCreator.getExistingMethods().contains(findAllDescriptor)) {
                try (MethodCreator findAll = classCreator.getMethodCreator(findAllDescriptor);){
                    findAll.setSignature(String.format("()Ljava/util/List<L%s;>;", entityTypeStr.replace('.', '/')));
                    ResultHandle panacheQuery = findAll.invokeStaticMethod(MethodDescriptor.ofMethod(JpaOperations.class, (String)"findAll", PanacheQuery.class, (Class[])new Class[]{Class.class}), new ResultHandle[]{findAll.readInstanceField(entityClassFieldDescriptor, findAll.getThis())});
                    ResultHandle list = findAll.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"list", List.class, (Class[])new Class[0]), panacheQuery, new ResultHandle[0]);
                    findAll.returnValue(list);
                }
                var9_9 = null;
                try (MethodCreator bridgeFindAll = classCreator.getMethodCreator(bridgeFindAllDescriptor);){
                    MethodDescriptor findAll = MethodDescriptor.ofMethod((String)generatedClassName, (String)"findAll", (String)List.class.getName(), (String[])new String[0]);
                    ResultHandle result = bridgeFindAll.invokeVirtualMethod(findAll, bridgeFindAll.getThis(), new ResultHandle[0]);
                    bridgeFindAll.returnValue(result);
                }
                catch (Throwable throwable) {
                    var9_9 = throwable;
                    throw throwable;
                }
            }
            allMethodsToBeImplementedToResult.put(findAllDescriptor, true);
            allMethodsToBeImplementedToResult.put(bridgeFindAllDescriptor, true);
        }
    }

    private void generateFindAllWithSort(ClassCreator classCreator, FieldDescriptor entityClassFieldDescriptor, String generatedClassName, String entityTypeStr, Map<MethodDescriptor, Boolean> allMethodsToBeImplementedToResult) {
        MethodDescriptor findAllDescriptor = MethodDescriptor.ofMethod((Object)generatedClassName, (String)"findAll", List.class, (Object[])new Object[]{org.springframework.data.domain.Sort.class});
        MethodDescriptor bridgeFindAllDescriptor = MethodDescriptor.ofMethod((Object)generatedClassName, (String)"findAll", Iterable.class, (Object[])new Object[]{org.springframework.data.domain.Sort.class});
        if (allMethodsToBeImplementedToResult.containsKey(findAllDescriptor) || allMethodsToBeImplementedToResult.containsKey(bridgeFindAllDescriptor)) {
            if (!classCreator.getExistingMethods().contains(findAllDescriptor)) {
                try (MethodCreator findAll = classCreator.getMethodCreator(findAllDescriptor);){
                    findAll.setSignature(String.format("(Lorg/springframework/data/domain/Sort;)Ljava/util/List<L%s;>;", entityTypeStr.replace('.', '/')));
                    ResultHandle sort = findAll.invokeStaticMethod(MethodDescriptor.ofMethod(TypesConverter.class, (String)"toPanacheSort", Sort.class, (Class[])new Class[]{org.springframework.data.domain.Sort.class}), new ResultHandle[]{findAll.getMethodParam(0)});
                    ResultHandle panacheQuery = findAll.invokeStaticMethod(MethodDescriptor.ofMethod(JpaOperations.class, (String)"findAll", PanacheQuery.class, (Class[])new Class[]{Class.class, Sort.class}), new ResultHandle[]{findAll.readInstanceField(entityClassFieldDescriptor, findAll.getThis()), sort});
                    ResultHandle list = findAll.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"list", List.class, (Class[])new Class[0]), panacheQuery, new ResultHandle[0]);
                    findAll.returnValue(list);
                }
                var9_9 = null;
                try (MethodCreator bridgeFindAll = classCreator.getMethodCreator(bridgeFindAllDescriptor);){
                    MethodDescriptor findAll = MethodDescriptor.ofMethod((Object)generatedClassName, (String)"findAll", (Object)List.class.getName(), (Object[])new Object[]{org.springframework.data.domain.Sort.class});
                    ResultHandle result = bridgeFindAll.invokeVirtualMethod(findAll, bridgeFindAll.getThis(), new ResultHandle[]{bridgeFindAll.getMethodParam(0)});
                    bridgeFindAll.returnValue(result);
                }
                catch (Throwable throwable) {
                    var9_9 = throwable;
                    throw throwable;
                }
            }
            allMethodsToBeImplementedToResult.put(findAllDescriptor, true);
            allMethodsToBeImplementedToResult.put(bridgeFindAllDescriptor, true);
        }
    }

    private void generateFindAllWithPageable(ClassCreator classCreator, FieldDescriptor entityClassFieldDescriptor, String generatedClassName, String entityTypeStr, Map<MethodDescriptor, Boolean> allMethodsToBeImplementedToResult) {
        MethodDescriptor findAllDescriptor = MethodDescriptor.ofMethod((Object)generatedClassName, (String)"findAll", Page.class, (Object[])new Object[]{Pageable.class});
        if (allMethodsToBeImplementedToResult.containsKey(findAllDescriptor)) {
            if (!classCreator.getExistingMethods().contains(findAllDescriptor)) {
                try (MethodCreator findAll = classCreator.getMethodCreator(findAllDescriptor);){
                    findAll.setSignature(String.format("(Lorg/springframework/data/domain/Pageable;)Lorg/springframework/data/domain/Page<L%s;>;", entityTypeStr.replace('.', '/')));
                    ResultHandle pageable = findAll.getMethodParam(0);
                    ResultHandle pageableSort = findAll.invokeInterfaceMethod(MethodDescriptor.ofMethod(Pageable.class, (String)"getSort", org.springframework.data.domain.Sort.class, (Class[])new Class[0]), pageable, new ResultHandle[0]);
                    ResultHandle panachePage = findAll.invokeStaticMethod(MethodDescriptor.ofMethod(TypesConverter.class, (String)"toPanachePage", io.quarkus.panache.common.Page.class, (Class[])new Class[]{Pageable.class}), new ResultHandle[]{pageable});
                    ResultHandle panacheSort = findAll.invokeStaticMethod(MethodDescriptor.ofMethod(TypesConverter.class, (String)"toPanacheSort", Sort.class, (Class[])new Class[]{org.springframework.data.domain.Sort.class}), new ResultHandle[]{pageableSort});
                    BranchResult sortNullBranch = findAll.ifNull(panacheSort);
                    BytecodeCreator sortNullTrue = sortNullBranch.trueBranch();
                    BytecodeCreator sortNullFalse = sortNullBranch.falseBranch();
                    AssignableResultHandle panacheQueryVar = findAll.createVariable(PanacheQuery.class);
                    ResultHandle panacheQueryWithoutSort = sortNullTrue.invokeStaticMethod(MethodDescriptor.ofMethod(JpaOperations.class, (String)"findAll", PanacheQuery.class, (Class[])new Class[]{Class.class}), new ResultHandle[]{sortNullTrue.readInstanceField(entityClassFieldDescriptor, sortNullTrue.getThis())});
                    sortNullTrue.assign(panacheQueryVar, panacheQueryWithoutSort);
                    sortNullTrue.breakScope();
                    ResultHandle panacheQueryWithSort = sortNullFalse.invokeStaticMethod(MethodDescriptor.ofMethod(JpaOperations.class, (String)"findAll", PanacheQuery.class, (Class[])new Class[]{Class.class, Sort.class}), new ResultHandle[]{sortNullFalse.readInstanceField(entityClassFieldDescriptor, sortNullFalse.getThis()), panacheSort});
                    sortNullFalse.assign(panacheQueryVar, panacheQueryWithSort);
                    sortNullFalse.breakScope();
                    ResultHandle panacheQuery = findAll.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"page", PanacheQuery.class, (Class[])new Class[]{io.quarkus.panache.common.Page.class}), (ResultHandle)panacheQueryVar, new ResultHandle[]{panachePage});
                    ResultHandle list = findAll.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"list", List.class, (Class[])new Class[0]), panacheQuery, new ResultHandle[0]);
                    ResultHandle count = findAll.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"count", Long.TYPE, (Class[])new Class[0]), panacheQuery, new ResultHandle[0]);
                    ResultHandle pageResult = findAll.newInstance(MethodDescriptor.ofConstructor(PageImpl.class, (Class[])new Class[]{List.class, Pageable.class, Long.TYPE}), new ResultHandle[]{list, findAll.getMethodParam(0), count});
                    findAll.returnValue(pageResult);
                }
            }
            allMethodsToBeImplementedToResult.put(findAllDescriptor, true);
        }
    }

    private void generateFindAllById(ClassCreator classCreator, FieldDescriptor entityClassFieldDescriptor, String generatedClassName, DotName entityDotName, String entityTypeStr, String idTypeStr, Map<MethodDescriptor, Boolean> allMethodsToBeImplementedToResult) {
        MethodDescriptor findAllByIdDescriptor = MethodDescriptor.ofMethod((Object)generatedClassName, (String)"findAllById", List.class, (Object[])new Object[]{Iterable.class});
        MethodDescriptor bridgeFindAllByIdDescriptor = MethodDescriptor.ofMethod((Object)generatedClassName, (String)"findAllById", Iterable.class, (Object[])new Object[]{Iterable.class});
        if (allMethodsToBeImplementedToResult.containsKey(findAllByIdDescriptor) || allMethodsToBeImplementedToResult.containsKey(bridgeFindAllByIdDescriptor)) {
            if (!classCreator.getExistingMethods().contains(findAllByIdDescriptor)) {
                try (MethodCreator findAllById = classCreator.getMethodCreator(findAllByIdDescriptor);){
                    findAllById.setSignature(String.format("(Ljava/lang/Iterable<L%s;>;)Ljava/util/List<L%s;>;", idTypeStr.replace('.', '/'), entityTypeStr.replace('.', '/')));
                    ResultHandle entityClass = findAllById.readInstanceField(entityClassFieldDescriptor, findAllById.getThis());
                    AnnotationTarget idAnnotationTarget = this.getIdAnnotationTarget(entityDotName, this.index);
                    FieldInfo idField = this.getIdField(idAnnotationTarget);
                    ResultHandle list = idField != null && (DotNames.LONG.equals((Object)idField.type().name()) || DotNames.INTEGER.equals((Object)idField.type().name()) || DotNames.STRING.equals((Object)idField.type().name())) ? findAllById.invokeStaticMethod(MethodDescriptor.ofMethod(RepositorySupport.class, (String)"findByIds", List.class, (Class[])new Class[]{Class.class, String.class, Iterable.class}), new ResultHandle[]{entityClass, findAllById.load(idField.name()), findAllById.getMethodParam(0)}) : findAllById.invokeStaticMethod(MethodDescriptor.ofMethod(RepositorySupport.class, (String)"findByIds", List.class, (Class[])new Class[]{Class.class, Iterable.class}), new ResultHandle[]{entityClass, findAllById.getMethodParam(0)});
                    findAllById.returnValue(list);
                }
                var11_11 = null;
                try (MethodCreator bridgeFindAllById = classCreator.getMethodCreator(bridgeFindAllByIdDescriptor);){
                    MethodDescriptor findAllById = MethodDescriptor.ofMethod((Object)generatedClassName, (String)"findAllById", (Object)List.class.getName(), (Object[])new Object[]{Iterable.class});
                    ResultHandle result = bridgeFindAllById.invokeVirtualMethod(findAllById, bridgeFindAllById.getThis(), new ResultHandle[]{bridgeFindAllById.getMethodParam(0)});
                    bridgeFindAllById.returnValue(result);
                }
                catch (Throwable throwable) {
                    var11_11 = throwable;
                    throw throwable;
                }
            }
            allMethodsToBeImplementedToResult.put(findAllByIdDescriptor, true);
            allMethodsToBeImplementedToResult.put(bridgeFindAllByIdDescriptor, true);
        }
    }

    private FieldInfo getIdField(AnnotationTarget idAnnotationTarget) {
        if (idAnnotationTarget instanceof FieldInfo) {
            return idAnnotationTarget.asField();
        }
        MethodInfo methodInfo = idAnnotationTarget.asMethod();
        String propertyName = JavaBeanUtil.getPropertyNameFromGetter((String)methodInfo.name());
        ClassInfo entityClass = methodInfo.declaringClass();
        FieldInfo field = entityClass.field(propertyName);
        if (field == null) {
            throw new IllegalArgumentException("Entity " + entityClass + " does not appear to have a field backing method" + methodInfo.name() + " which is annotated with @Id");
        }
        return field;
    }

    private void generateCount(ClassCreator classCreator, FieldDescriptor entityClassFieldDescriptor, String generatedClassName, Map<MethodDescriptor, Boolean> allMethodsToBeImplementedToResult) {
        MethodDescriptor countDescriptor = MethodDescriptor.ofMethod((Object)generatedClassName, (String)"count", Long.TYPE, (Object[])new Object[0]);
        if (allMethodsToBeImplementedToResult.containsKey(countDescriptor)) {
            if (!classCreator.getExistingMethods().contains(countDescriptor)) {
                try (MethodCreator count = classCreator.getMethodCreator(countDescriptor);){
                    ResultHandle result = count.invokeStaticMethod(MethodDescriptor.ofMethod(JpaOperations.class, (String)"count", Long.TYPE, (Class[])new Class[]{Class.class}), new ResultHandle[]{count.readInstanceField(entityClassFieldDescriptor, count.getThis())});
                    count.returnValue(result);
                }
            }
            allMethodsToBeImplementedToResult.put(countDescriptor, true);
        }
    }

    private void generateDeleteById(ClassCreator classCreator, FieldDescriptor entityClassFieldDescriptor, String generatedClassName, String entityTypeStr, String idTypeStr, Map<MethodDescriptor, Boolean> allMethodsToBeImplementedToResult) {
        MethodDescriptor deleteByIdDescriptor = MethodDescriptor.ofMethod((String)generatedClassName, (String)"deleteById", (String)Void.TYPE.getName(), (String[])new String[]{idTypeStr});
        MethodDescriptor bridgeDeleteByIdDescriptor = MethodDescriptor.ofMethod((Object)generatedClassName, (String)"deleteById", Void.TYPE, (Object[])new Object[]{Object.class});
        if (allMethodsToBeImplementedToResult.containsKey(deleteByIdDescriptor) || allMethodsToBeImplementedToResult.containsKey(bridgeDeleteByIdDescriptor)) {
            if (!classCreator.getExistingMethods().contains(deleteByIdDescriptor)) {
                try (MethodCreator deleteById = classCreator.getMethodCreator(deleteByIdDescriptor);){
                    deleteById.addAnnotation(Transactional.class);
                    ResultHandle id = deleteById.getMethodParam(0);
                    ResultHandle entityClass = deleteById.readInstanceField(entityClassFieldDescriptor, deleteById.getThis());
                    ResultHandle deleted = deleteById.invokeStaticMethod(MethodDescriptor.ofMethod(JpaOperations.class, (String)"deleteById", Boolean.TYPE, (Class[])new Class[]{Class.class, Object.class}), new ResultHandle[]{entityClass, id});
                    BranchResult deletedBranch = deleteById.ifNonZero(deleted);
                    BytecodeCreator deletedFalse = deletedBranch.falseBranch();
                    ResultHandle idToString = deletedFalse.invokeVirtualMethod(MethodDescriptor.ofMethod(Object.class, (String)"toString", String.class, (Class[])new Class[0]), id, new ResultHandle[0]);
                    ResultHandle formatArgsArray = deletedFalse.newArray(Object.class, 1);
                    deletedFalse.writeArrayValue(formatArgsArray, deletedFalse.load(0), idToString);
                    ResultHandle messageFormat = deletedFalse.load("No entity " + entityTypeStr + " with id %s exists");
                    ResultHandle message = deletedFalse.invokeStaticMethod(MethodDescriptor.ofMethod(String.class, (String)"format", String.class, (Class[])new Class[]{String.class, Object[].class}), new ResultHandle[]{messageFormat, formatArgsArray});
                    ResultHandle exception = deletedFalse.newInstance(MethodDescriptor.ofConstructor(IllegalArgumentException.class, (Class[])new Class[]{String.class}), new ResultHandle[]{message});
                    deletedFalse.throwException(exception);
                    deletedFalse.breakScope();
                    deleteById.returnValue(null);
                }
                var10_10 = null;
                try (MethodCreator bridgeDeleteById = classCreator.getMethodCreator(bridgeDeleteByIdDescriptor);){
                    MethodDescriptor deleteById = MethodDescriptor.ofMethod((Object)generatedClassName, (String)"deleteById", Void.TYPE, (Object[])new Object[]{idTypeStr});
                    ResultHandle methodParam = bridgeDeleteById.getMethodParam(0);
                    ResultHandle castedMethodParam = bridgeDeleteById.checkCast(methodParam, idTypeStr);
                    ResultHandle result = bridgeDeleteById.invokeVirtualMethod(deleteById, bridgeDeleteById.getThis(), new ResultHandle[]{castedMethodParam});
                    bridgeDeleteById.returnValue(result);
                }
                catch (Throwable throwable) {
                    var10_10 = throwable;
                    throw throwable;
                }
            }
            allMethodsToBeImplementedToResult.put(deleteByIdDescriptor, true);
            allMethodsToBeImplementedToResult.put(bridgeDeleteByIdDescriptor, true);
        }
    }

    private void generateDelete(ClassCreator classCreator, String generatedClassName, String entityTypeStr, Map<MethodDescriptor, Boolean> allMethodsToBeImplementedToResult) {
        MethodDescriptor deleteDescriptor = MethodDescriptor.ofMethod((String)generatedClassName, (String)"delete", (String)Void.TYPE.toString(), (String[])new String[]{entityTypeStr});
        MethodDescriptor bridgeDeleteDescriptor = MethodDescriptor.ofMethod((Object)generatedClassName, (String)"delete", Void.TYPE, (Object[])new Object[]{Object.class});
        if ((allMethodsToBeImplementedToResult.containsKey(deleteDescriptor) || allMethodsToBeImplementedToResult.containsKey(bridgeDeleteDescriptor)) && !classCreator.getExistingMethods().contains(deleteDescriptor)) {
            try (MethodCreator delete = classCreator.getMethodCreator(deleteDescriptor);){
                delete.addAnnotation(Transactional.class);
                ResultHandle entity = delete.getMethodParam(0);
                delete.invokeStaticMethod(MethodDescriptor.ofMethod(JpaOperations.class, (String)"delete", Void.TYPE, (Class[])new Class[]{Object.class}), new ResultHandle[]{entity});
                delete.returnValue(null);
            }
            var8_8 = null;
            try (MethodCreator bridgeDelete = classCreator.getMethodCreator(bridgeDeleteDescriptor);){
                MethodDescriptor delete = MethodDescriptor.ofMethod((String)generatedClassName, (String)"delete", (String)Void.TYPE.toString(), (String[])new String[]{entityTypeStr});
                ResultHandle methodParam = bridgeDelete.getMethodParam(0);
                ResultHandle castedMethodParam = bridgeDelete.checkCast(methodParam, entityTypeStr);
                ResultHandle result = bridgeDelete.invokeVirtualMethod(delete, bridgeDelete.getThis(), new ResultHandle[]{castedMethodParam});
                bridgeDelete.returnValue(result);
            }
            catch (Throwable throwable) {
                var8_8 = throwable;
                throw throwable;
            }
        }
        allMethodsToBeImplementedToResult.put(deleteDescriptor, true);
        allMethodsToBeImplementedToResult.put(bridgeDeleteDescriptor, true);
    }

    private void generateDeleteAllWithIterable(ClassCreator classCreator, String generatedClassName, String entityTypeStr, Map<MethodDescriptor, Boolean> allMethodsToBeImplementedToResult) {
        MethodDescriptor deleteAllWithIterableDescriptor = MethodDescriptor.ofMethod((Object)generatedClassName, (String)"deleteAll", Void.TYPE, (Object[])new Object[]{Iterable.class});
        if (allMethodsToBeImplementedToResult.containsKey(deleteAllWithIterableDescriptor)) {
            if (!classCreator.getExistingMethods().contains(deleteAllWithIterableDescriptor)) {
                try (MethodCreator deleteAll = classCreator.getMethodCreator(deleteAllWithIterableDescriptor);){
                    deleteAll.setSignature(String.format("(Ljava/lang/Iterable<+L%s;>;)V", entityTypeStr.replace('.', '/')));
                    deleteAll.addAnnotation(Transactional.class);
                    ResultHandle entities = deleteAll.getMethodParam(0);
                    deleteAll.invokeStaticMethod(MethodDescriptor.ofMethod(RepositorySupport.class, (String)"deleteAll", Void.TYPE, (Class[])new Class[]{Iterable.class}), new ResultHandle[]{entities});
                    deleteAll.returnValue(null);
                }
            }
            allMethodsToBeImplementedToResult.put(deleteAllWithIterableDescriptor, true);
        }
    }

    private void generateDeleteAll(ClassCreator classCreator, FieldDescriptor entityClassFieldDescriptor, String generatedClassName, Map<MethodDescriptor, Boolean> allMethodsToBeImplementedToResult) {
        MethodDescriptor deleteAllDescriptor = MethodDescriptor.ofMethod((Object)generatedClassName, (String)"deleteAll", Void.TYPE, (Object[])new Object[0]);
        if (allMethodsToBeImplementedToResult.containsKey(deleteAllDescriptor)) {
            if (!classCreator.getExistingMethods().contains(deleteAllDescriptor)) {
                try (MethodCreator deleteAll = classCreator.getMethodCreator(deleteAllDescriptor);){
                    deleteAll.addAnnotation(Transactional.class);
                    deleteAll.invokeStaticMethod(MethodDescriptor.ofMethod(JpaOperations.class, (String)"deleteAll", Long.TYPE, (Object[])new Object[]{Class.class.getName()}), new ResultHandle[]{deleteAll.readInstanceField(entityClassFieldDescriptor, deleteAll.getThis())});
                    deleteAll.returnValue(null);
                }
            }
            allMethodsToBeImplementedToResult.put(deleteAllDescriptor, true);
        }
    }

    private void handleUnimplementedMethods(ClassCreator classCreator, Map<MethodDescriptor, Boolean> allMethodsToBeImplementedToResult) {
        for (Map.Entry<MethodDescriptor, Boolean> entry : allMethodsToBeImplementedToResult.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            MethodCreator methodCreator = classCreator.getMethodCreator(entry.getKey());
            Throwable throwable = null;
            try {
                ResultHandle res = methodCreator.newInstance(MethodDescriptor.ofConstructor(FunctionalityNotImplemented.class, (Class[])new Class[]{String.class, String.class}), new ResultHandle[]{methodCreator.load(classCreator.getClassName().replace('/', '.')), methodCreator.load(entry.getKey().getName())});
                methodCreator.throwException(res);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (methodCreator == null) continue;
                if (throwable != null) {
                    try {
                        methodCreator.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                methodCreator.close();
            }
        }
    }

    private Set<MethodInfo> methodsOfExtendedSpringDataRepositories(ClassInfo repositoryToImplement) {
        return GenerationUtil.interfaceMethods(GenerationUtil.extendedSpringDataRepos(repositoryToImplement), this.index);
    }

    private Set<MethodInfo> stockMethodsAddedToInterface(ClassInfo repositoryToImplement) {
        HashSet<MethodInfo> result = new HashSet<MethodInfo>();
        Set<MethodInfo> allSpringDataRepositoryMethods = this.allSpringDataRepositoryMethods();
        for (MethodInfo method : repositoryToImplement.methods()) {
            for (MethodInfo springDataRepositoryMethod : allSpringDataRepositoryMethods) {
                if (!this.canMethodsBeConsideredSame(method, springDataRepositoryMethod)) continue;
                result.add(method);
            }
        }
        return result;
    }

    private Set<MethodInfo> allSpringDataRepositoryMethods() {
        if (ALL_SPRING_DATA_REPOSITORY_METHODS != null) {
            return ALL_SPRING_DATA_REPOSITORY_METHODS;
        }
        ALL_SPRING_DATA_REPOSITORY_METHODS = GenerationUtil.interfaceMethods(new HashSet<DotName>(DotNames.SUPPORTED_REPOSITORIES), this.index);
        return ALL_SPRING_DATA_REPOSITORY_METHODS;
    }

    private boolean canMethodsBeConsideredSame(MethodInfo candidate, MethodInfo target) {
        if (!candidate.name().equals(target.name())) {
            return false;
        }
        if (candidate.parameters().size() != target.parameters().size()) {
            return false;
        }
        if (!this.canTypesBeConsideredSame(candidate.returnType(), target.returnType())) {
            return false;
        }
        for (int i = 0; i < candidate.parameters().size(); ++i) {
            if (this.canTypesBeConsideredSame((Type)candidate.parameters().get(i), (Type)target.parameters().get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean canTypesBeConsideredSame(Type candidate, Type target) {
        if (candidate.equals((Object)target)) {
            return true;
        }
        if (candidate instanceof ParameterizedType && target instanceof ParameterizedType) {
            return candidate.asParameterizedType().name().equals((Object)target.asParameterizedType().name());
        }
        return candidate instanceof ClassType && target instanceof TypeVariable;
    }

    private AnnotationTarget getIdAnnotationTarget(DotName entityDotName, IndexView index) {
        return this.getIdAnnotationTargetRec(entityDotName, index, entityDotName);
    }

    private AnnotationTarget getIdAnnotationTargetRec(DotName currentDotName, IndexView index, DotName originalEntityDotName) {
        ClassInfo classInfo = index.getClassByName(currentDotName);
        if (classInfo == null) {
            throw new IllegalStateException("Entity " + originalEntityDotName + " was not part of the Quarkus index");
        }
        if (!classInfo.annotations().containsKey(DotNames.JPA_ID)) {
            if (DotNames.OBJECT.equals((Object)classInfo.superName())) {
                throw new IllegalArgumentException("Currently only Entities with the @Id annotation are supported. Offending class is " + originalEntityDotName);
            }
            return this.getIdAnnotationTargetRec(classInfo.superName(), index, originalEntityDotName);
        }
        List annotationInstances = (List)classInfo.annotations().get(DotNames.JPA_ID);
        if (annotationInstances.size() > 1) {
            throw new IllegalArgumentException("Currently the @Id annotation can only be placed on a single field or method. Offending class is " + originalEntityDotName);
        }
        return ((AnnotationInstance)annotationInstances.get(0)).target();
    }
}

