/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.data.deployment.generate;

import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.util.HashUtil;
import io.quarkus.spring.data.deployment.DotNames;
import io.quarkus.spring.data.deployment.generate.CustomQueryMethodsAdder;
import io.quarkus.spring.data.deployment.generate.DerivedMethodsAdder;
import io.quarkus.spring.data.deployment.generate.FragmentMethodsAdder;
import io.quarkus.spring.data.deployment.generate.FragmentMethodsUtil;
import io.quarkus.spring.data.deployment.generate.GenerationUtil;
import io.quarkus.spring.data.deployment.generate.StockMethodsAdder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

public class SpringDataRepositoryCreator {
    private final ClassOutput classOutput;
    private final IndexView index;
    private final FragmentMethodsAdder fragmentMethodsAdder;
    private final StockMethodsAdder stockMethodsAdder;
    private final DerivedMethodsAdder derivedMethodsAdder;
    private final CustomQueryMethodsAdder customQueryMethodsAdder;

    public SpringDataRepositoryCreator(ClassOutput classOutput, ClassOutput otherClassOutput, IndexView index, Consumer<String> fragmentImplClassResolvedCallback, Consumer<String> customClassCreatedCallback) {
        this.classOutput = classOutput;
        this.index = index;
        this.fragmentMethodsAdder = new FragmentMethodsAdder(fragmentImplClassResolvedCallback, index);
        this.stockMethodsAdder = new StockMethodsAdder(index);
        this.derivedMethodsAdder = new DerivedMethodsAdder(index);
        this.customQueryMethodsAdder = new CustomQueryMethodsAdder(index, otherClassOutput, customClassCreatedCallback);
    }

    public void implementCrudRepository(ClassInfo repositoryToImplement) {
        Map.Entry<DotName, DotName> extraTypesResult = this.extractIdAndEntityTypes(repositoryToImplement);
        String idTypeStr = extraTypesResult.getKey().toString();
        DotName entityDotName = extraTypesResult.getValue();
        String entityTypeStr = entityDotName.toString();
        ClassInfo entityClassInfo = this.index.getClassByName(entityDotName);
        if (entityClassInfo == null) {
            throw new IllegalStateException("Entity " + entityDotName + " was not part of the Quarkus index");
        }
        List interfaceNames = repositoryToImplement.interfaceNames();
        ArrayList<DotName> fragmentNamesToImplement = new ArrayList<DotName>(interfaceNames.size());
        for (DotName interfaceName : interfaceNames) {
            if (DotNames.SUPPORTED_REPOSITORIES.contains(interfaceName)) continue;
            fragmentNamesToImplement.add(interfaceName);
        }
        HashMap<String, FieldDescriptor> fragmentImplNameToFieldDescriptor = new HashMap<String, FieldDescriptor>();
        String repositoryToImplementStr = repositoryToImplement.name().toString();
        String generatedClassName = repositoryToImplementStr + "_" + HashUtil.sha1((String)repositoryToImplementStr) + "Impl";
        try (ClassCreator classCreator = ClassCreator.builder().classOutput(this.classOutput).className(generatedClassName).interfaces(new String[]{repositoryToImplementStr}).build();){
            classCreator.addAnnotation(ApplicationScoped.class);
            FieldCreator entityClassFieldCreator = (FieldCreator)classCreator.getFieldCreator("entityClass", Class.class.getName()).setModifiers(18);
            this.createCustomImplFields(classCreator, fragmentNamesToImplement, this.index, fragmentImplNameToFieldDescriptor);
            try (MethodCreator ctor = classCreator.getMethodCreator("<init>", "V", new String[0]);){
                ctor.invokeSpecialMethod(MethodDescriptor.ofMethod(Object.class, (String)"<init>", Void.TYPE, (Class[])new Class[0]), ctor.getThis(), new ResultHandle[0]);
                ctor.writeInstanceField(entityClassFieldCreator.getFieldDescriptor(), ctor.getThis(), ctor.loadClass(entityTypeStr));
                ctor.returnValue(null);
            }
            this.fragmentMethodsAdder.add(classCreator, generatedClassName, fragmentNamesToImplement, fragmentImplNameToFieldDescriptor);
            this.stockMethodsAdder.add(classCreator, entityClassFieldCreator.getFieldDescriptor(), generatedClassName, repositoryToImplement, entityDotName, idTypeStr);
            this.derivedMethodsAdder.add(classCreator, entityClassFieldCreator.getFieldDescriptor(), generatedClassName, repositoryToImplement, entityClassInfo);
            this.customQueryMethodsAdder.add(classCreator, entityClassFieldCreator.getFieldDescriptor(), repositoryToImplement, entityClassInfo);
        }
    }

    private Map.Entry<DotName, DotName> extractIdAndEntityTypes(ClassInfo repositoryToImplement) {
        AnnotationInstance repositoryDefinitionInstance = repositoryToImplement.classAnnotation(DotNames.SPRING_DATA_REPOSITORY_DEFINITION);
        if (repositoryDefinitionInstance != null) {
            return new AbstractMap.SimpleEntry<DotName, DotName>(repositoryDefinitionInstance.value("idClass").asClass().name(), repositoryDefinitionInstance.value("domainClass").asClass().name());
        }
        DotName entityDotName = null;
        DotName idDotName = null;
        for (DotName extendedSpringDataRepo : GenerationUtil.extendedSpringDataRepos(repositoryToImplement)) {
            List types = JandexUtil.resolveTypeParameters((DotName)repositoryToImplement.name(), (DotName)extendedSpringDataRepo, (IndexView)this.index);
            if (!(types.get(0) instanceof ClassType)) {
                throw new IllegalArgumentException("Entity generic argument of " + repositoryToImplement + " is not a regular class type");
            }
            DotName newEntityDotName = ((Type)types.get(0)).name();
            if (entityDotName != null && !newEntityDotName.equals((Object)entityDotName)) {
                throw new IllegalArgumentException("Repository " + repositoryToImplement + " specifies multiple Entity types");
            }
            entityDotName = newEntityDotName;
            DotName newIdDotName = ((Type)types.get(1)).name();
            if (idDotName != null && !newIdDotName.equals((Object)idDotName)) {
                throw new IllegalArgumentException("Repository " + repositoryToImplement + " specifies multiple ID types");
            }
            idDotName = newIdDotName;
        }
        if (idDotName == null || entityDotName == null) {
            throw new IllegalArgumentException("Repository " + repositoryToImplement + " does not specify ID and/or Entity type");
        }
        return new AbstractMap.SimpleEntry<Object, Object>(idDotName, entityDotName);
    }

    private void createCustomImplFields(ClassCreator repositoryImpl, List<DotName> customInterfaceNamesToImplement, IndexView index, Map<String, FieldDescriptor> customImplNameToFieldDescriptor) {
        HashSet<String> customImplClassNames = new HashSet<String>(customInterfaceNamesToImplement.size());
        for (DotName customInterfaceToImplement : customInterfaceNamesToImplement) {
            customImplClassNames.add(FragmentMethodsUtil.getImplementationDotName(customInterfaceToImplement, index).toString());
        }
        int i = 0;
        for (String customImplClassName : customImplClassNames) {
            FieldCreator customClassField = (FieldCreator)repositoryImpl.getFieldCreator("customImplClass" + (i + 1), customImplClassName).setModifiers(4);
            customClassField.addAnnotation(Inject.class);
            customImplNameToFieldDescriptor.put(customImplClassName, customClassField.getFieldDescriptor());
            ++i;
        }
    }
}

