/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.data.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.hibernate.orm.deployment.IgnorableNonIndexedClasses;
import io.quarkus.spring.data.deployment.DotNames;
import io.quarkus.spring.data.deployment.generate.SpringDataRepositoryCreator;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;
import org.springframework.data.domain.Auditable;
import org.springframework.data.domain.Persistable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.query.QueryByExampleExecutor;

public class SpringDataJPAProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)SpringDataJPAProcessor.class.getName());
    private static final Pattern pattern = Pattern.compile("spring\\..*");
    public static final String SPRING_JPA_SHOW_SQL = "spring.jpa.show-sql";
    public static final String SPRING_JPA_PROPERTIES_HIBERNATE_DIALECT = "spring.jpa.properties.hibernate.dialect";
    public static final String SPRING_JPA_PROPERTIES_HIBERNATE_DIALECT_STORAGE_ENGINE = "spring.jpa.properties.hibernate.dialect.storage_engine";
    public static final String SPRING_JPA_GENERATE_DDL = "spring.jpa.generate-ddl";
    public static final String SPRING_JPA_HIBERNATE_NAMING_PHYSICAL_STRATEGY = "spring.jpa.hibernate.naming.physical-strategy";
    public static final String SPRING_JPA_HIBERNATE_NAMING_IMPLICIT_STRATEGY = "spring.jpa.hibernate.naming.implicit-strategy";
    private static final String SPRING_DATASOURCE_DATA = "spring.datasource.data";
    public static final String QUARKUS_HIBERNATE_ORM_DIALECT = "quarkus.hibernate-orm.dialect";
    public static final String QUARKUS_HIBERNATE_ORM_LOG_SQL = "quarkus.hibernate-orm.log.sql";
    public static final String QUARKUS_HIBERNATE_ORM_DIALECT_STORAGE_ENGINE = "quarkus.hibernate-orm.dialect.storage-engine";
    public static final String QUARKUS_HIBERNATE_ORM_DATABASE_GENERATION = "quarkus.hibernate-orm.database.generation";
    public static final String QUARKUS_HIBERNATE_ORM_PHYSICAL_NAMING_STRATEGY = "quarkus.hibernate-orm.physical-naming-strategy";
    public static final String QUARKUS_HIBERNATE_ORM_IMPLICIT_NAMING_STRATEGY = "quarkus.hibernate-orm.implicit-naming-strategy";
    private static final String QUARKUS_HIBERNATE_ORM_SQL_LOAD_SCRIPT = "quarkus.hibernate-orm.sql-load-script";

    @BuildStep
    FeatureBuildItem registerFeature() {
        return new FeatureBuildItem(Feature.SPRING_DATA_JPA);
    }

    @BuildStep
    void contributeClassesToIndex(BuildProducer<AdditionalIndexedClassesBuildItem> additionalIndexedClasses) {
        additionalIndexedClasses.produce((BuildItem)new AdditionalIndexedClassesBuildItem(new String[]{Repository.class.getName(), CrudRepository.class.getName(), PagingAndSortingRepository.class.getName(), JpaRepository.class.getName(), QueryByExampleExecutor.class.getName()}));
    }

    @BuildStep
    IgnorableNonIndexedClasses ignorable() {
        HashSet<String> ignorable = new HashSet<String>();
        ignorable.add(Auditable.class.getName());
        ignorable.add(Persistable.class.getName());
        return new IgnorableNonIndexedClasses(ignorable);
    }

    @BuildStep
    void build(CombinedIndexBuildItem index, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        this.detectAndLogSpecificSpringPropertiesIfExist();
        IndexView indexView = index.getIndex();
        List<ClassInfo> interfacesExtendingRepository = this.getAllInterfacesExtending(DotNames.SUPPORTED_REPOSITORIES, indexView);
        this.addRepositoryDefinitionInstances(indexView, interfacesExtendingRepository);
        this.removeNoRepositoryBeanClasses(interfacesExtendingRepository);
        this.implementCrudRepositories(generatedBeans, generatedClasses, additionalBeans, reflectiveClasses, interfacesExtendingRepository, indexView);
    }

    private void addRepositoryDefinitionInstances(IndexView indexView, List<ClassInfo> interfacesExtendingRepository) {
        Collection repositoryDefinitions = indexView.getAnnotations(DotNames.SPRING_DATA_REPOSITORY_DEFINITION);
        for (AnnotationInstance repositoryDefinition : repositoryDefinitions) {
            AnnotationTarget target = repositoryDefinition.target();
            if (target.kind() != AnnotationTarget.Kind.CLASS) continue;
            ClassInfo classInfo = target.asClass();
            Set<DotName> supportedRepositories = DotNames.SUPPORTED_REPOSITORIES;
            for (DotName supportedRepository : supportedRepositories) {
                if (!classInfo.interfaceNames().contains(supportedRepository)) continue;
                throw new IllegalArgumentException("Class " + classInfo.name() + " which is annotated with @RepositoryDefinition cannot also extend " + supportedRepository);
            }
            interfacesExtendingRepository.add(classInfo);
        }
    }

    private void detectAndLogSpecificSpringPropertiesIfExist() {
        Config config = ConfigProvider.getConfig();
        Iterable iterablePropertyNames = config.getPropertyNames();
        ArrayList propertyNames = new ArrayList();
        iterablePropertyNames.forEach(propertyNames::add);
        List springProperties = propertyNames.stream().filter(s -> pattern.matcher((CharSequence)s).matches()).collect(Collectors.toList());
        String notSupportedProperties = "";
        if (!springProperties.isEmpty()) {
            Iterator iterator = springProperties.iterator();
            block18: while (iterator.hasNext()) {
                String sp;
                switch (sp = (String)iterator.next()) {
                    case "spring.jpa.show-sql": {
                        notSupportedProperties = notSupportedProperties + "\t- " + SPRING_JPA_SHOW_SQL + " should be replaced by " + QUARKUS_HIBERNATE_ORM_LOG_SQL + "\n";
                        continue block18;
                    }
                    case "spring.jpa.properties.hibernate.dialect": {
                        notSupportedProperties = notSupportedProperties + "\t- " + SPRING_JPA_PROPERTIES_HIBERNATE_DIALECT + " should be replaced by " + QUARKUS_HIBERNATE_ORM_DIALECT + "\n";
                        continue block18;
                    }
                    case "spring.jpa.properties.hibernate.dialect.storage_engine": {
                        notSupportedProperties = notSupportedProperties + "\t- " + SPRING_JPA_PROPERTIES_HIBERNATE_DIALECT_STORAGE_ENGINE + " should be replaced by " + QUARKUS_HIBERNATE_ORM_DIALECT_STORAGE_ENGINE + "\n";
                        continue block18;
                    }
                    case "spring.jpa.generate-ddl": {
                        notSupportedProperties = notSupportedProperties + "\t- " + SPRING_JPA_GENERATE_DDL + " should be replaced by " + QUARKUS_HIBERNATE_ORM_DATABASE_GENERATION + "\n";
                        continue block18;
                    }
                    case "spring.jpa.hibernate.naming.physical-strategy": {
                        notSupportedProperties = notSupportedProperties + "\t- " + SPRING_JPA_HIBERNATE_NAMING_PHYSICAL_STRATEGY + " should be replaced by " + QUARKUS_HIBERNATE_ORM_PHYSICAL_NAMING_STRATEGY + "\n";
                        continue block18;
                    }
                    case "spring.jpa.hibernate.naming.implicit-strategy": {
                        notSupportedProperties = notSupportedProperties + "\t- " + SPRING_JPA_HIBERNATE_NAMING_IMPLICIT_STRATEGY + " should be replaced by " + QUARKUS_HIBERNATE_ORM_IMPLICIT_NAMING_STRATEGY + "\n";
                        continue block18;
                    }
                    case "spring.datasource.data": {
                        notSupportedProperties = notSupportedProperties + "\t- " + QUARKUS_HIBERNATE_ORM_SQL_LOAD_SCRIPT + " could be used to load data instead of " + SPRING_DATASOURCE_DATA + " but it does not support either comma separated list of resources or resources with ant-style patterns as " + SPRING_DATASOURCE_DATA + " does, it accepts the name of the file containing the SQL statements to execute when when Hibernate ORM starts.\n";
                        continue block18;
                    }
                }
                notSupportedProperties = notSupportedProperties + "\t- " + sp + "\n";
            }
            LOGGER.warnf("Quarkus does not support the following Spring Boot configuration properties: %n%s", (Object)notSupportedProperties);
        }
    }

    private void removeNoRepositoryBeanClasses(List<ClassInfo> interfacesExtendingRepository) {
        Iterator<ClassInfo> iterator = interfacesExtendingRepository.iterator();
        while (iterator.hasNext()) {
            ClassInfo next = iterator.next();
            if (next.classAnnotation(DotNames.SPRING_DATA_NO_REPOSITORY_BEAN) == null) continue;
            iterator.remove();
        }
    }

    private List<ClassInfo> getAllInterfacesExtending(Collection<DotName> targets, IndexView index) {
        ArrayList<ClassInfo> result = new ArrayList<ClassInfo>();
        Collection knownClasses = index.getKnownClasses();
        for (ClassInfo clazz : knownClasses) {
            if (!Modifier.isInterface(clazz.flags())) continue;
            List interfaceNames = clazz.interfaceNames();
            boolean found = false;
            for (DotName interfaceName : interfaceNames) {
                if (!targets.contains(interfaceName)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            result.add(clazz);
        }
        return result;
    }

    private void implementCrudRepositories(BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, List<ClassInfo> crudRepositoriesToImplement, IndexView index) {
        GeneratedBeanGizmoAdaptor beansClassOutput = new GeneratedBeanGizmoAdaptor(generatedBeans);
        GeneratedClassGizmoAdaptor otherClassOutput = new GeneratedClassGizmoAdaptor(generatedClasses, true);
        SpringDataRepositoryCreator repositoryCreator = new SpringDataRepositoryCreator((ClassOutput)beansClassOutput, (ClassOutput)otherClassOutput, index, n -> additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf((String)n)), className -> reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{className})));
        for (ClassInfo crudRepositoryToImplement : crudRepositoriesToImplement) {
            repositoryCreator.implementCrudRepository(crudRepositoryToImplement);
        }
    }
}

