/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.data.deployment.generate;

import java.util.Collection;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

final class FragmentMethodsUtil {
    private FragmentMethodsUtil() {
    }

    static DotName getImplementationDotName(DotName customInterfaceToImplement, IndexView index) {
        Collection knownImplementors = index.getAllKnownImplementors(customInterfaceToImplement);
        if (knownImplementors.size() > 1) {
            DotName previouslyFound = null;
            for (ClassInfo knownImplementor : knownImplementors) {
                if (!knownImplementor.name().toString().endsWith("Impl")) continue;
                if (previouslyFound != null) {
                    throw new IllegalArgumentException("Interface " + customInterfaceToImplement + " must contain a single implementation whose name ends with 'Impl'. Multiple implementations were found: " + previouslyFound + "," + knownImplementor);
                }
                previouslyFound = knownImplementor.name();
            }
            return previouslyFound;
        }
        if (knownImplementors.size() == 1) {
            return ((ClassInfo)knownImplementors.iterator().next()).name();
        }
        throw new IllegalArgumentException("No implementation of interface " + customInterfaceToImplement + " was found");
    }
}

