/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.data.deployment.generate;

import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.hibernate.orm.panache.PanacheQuery;
import io.quarkus.hibernate.orm.panache.runtime.JpaOperations;
import io.quarkus.panache.common.Sort;
import io.quarkus.spring.data.deployment.DotNames;
import io.quarkus.spring.data.deployment.MethodNameParser;
import io.quarkus.spring.data.deployment.generate.AbstractMethodsAdder;
import io.quarkus.spring.data.deployment.generate.GenerationUtil;
import io.quarkus.spring.data.runtime.TypesConverter;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.Transactional;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.springframework.data.domain.Pageable;

public class DerivedMethodsAdder
extends AbstractMethodsAdder {
    private final IndexView index;

    public DerivedMethodsAdder(IndexView index) {
        this.index = index;
    }

    public void add(ClassCreator classCreator, FieldDescriptor entityClassFieldDescriptor, String generatedClassName, ClassInfo repositoryClassInfo, ClassInfo entityClassInfo) {
        MethodNameParser methodNameParser = new MethodNameParser(entityClassInfo, this.index);
        for (MethodInfo method : repositoryClassInfo.methods()) {
            if (method.annotation(DotNames.SPRING_DATA_QUERY) != null || classCreator.getExistingMethods().contains(GenerationUtil.toMethodDescriptor(generatedClassName, method))) continue;
            Type returnType = method.returnType();
            List parameters = method.parameters();
            String[] parameterTypesStr = new String[parameters.size()];
            ArrayList<Integer> queryParameterIndexes = new ArrayList<Integer>(parameters.size());
            Integer pageableParameterIndex = null;
            Integer sortParameterIndex = null;
            for (int i = 0; i < parameters.size(); ++i) {
                DotName parameterType = ((Type)parameters.get(i)).name();
                parameterTypesStr[i] = parameterType.toString();
                if (DotNames.SPRING_DATA_PAGEABLE.equals((Object)parameterType) || DotNames.SPRING_DATA_PAGE_REQUEST.equals((Object)parameterType)) {
                    if (pageableParameterIndex != null) {
                        throw new IllegalArgumentException("Method " + method.name() + " of Repository " + repositoryClassInfo + "has invalid parameters - only a single parameter of type" + DotNames.SPRING_DATA_PAGEABLE + " can be specified");
                    }
                    pageableParameterIndex = i;
                    continue;
                }
                if (DotNames.SPRING_DATA_SORT.equals((Object)parameterType)) {
                    if (sortParameterIndex != null) {
                        throw new IllegalArgumentException("Method " + method.name() + " of Repository " + repositoryClassInfo + "has invalid parameters - only a single parameter of type" + DotNames.SPRING_DATA_SORT + " can be specified");
                    }
                    sortParameterIndex = i;
                    continue;
                }
                queryParameterIndexes.add(i);
            }
            MethodNameParser.Result parseResult = methodNameParser.parse(method);
            if (parseResult.getParamCount() != queryParameterIndexes.size()) {
                throw new IllegalArgumentException("The number of parameters of method " + method.name() + " of Repository " + repositoryClassInfo + " does not match the number of parameter needed (inferred from the method name)");
            }
            MethodCreator methodCreator = classCreator.getMethodCreator(method.name(), returnType.name().toString(), parameterTypesStr);
            Throwable throwable = null;
            try {
                ResultHandle paramsArray = methodCreator.newArray(Object.class, parseResult.getParamCount());
                for (int i = 0; i < queryParameterIndexes.size(); ++i) {
                    methodCreator.writeArrayValue(paramsArray, methodCreator.load(i), methodCreator.getMethodParam(((Integer)queryParameterIndexes.get(i)).intValue()));
                }
                if (parseResult.getQueryType() == MethodNameParser.QueryType.SELECT) {
                    if (parseResult.getSort() != null && sortParameterIndex != null) {
                        throw new IllegalArgumentException(method.name() + " of Repository " + repositoryClassInfo + " contains both a " + DotNames.SPRING_DATA_SORT + " parameter and a sort operation");
                    }
                    String finalQuery = parseResult.getQuery();
                    ResultHandle sort = methodCreator.loadNull();
                    if (sortParameterIndex != null) {
                        sort = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(TypesConverter.class, (String)"toPanacheSort", Sort.class, (Class[])new Class[]{org.springframework.data.domain.Sort.class}), new ResultHandle[]{methodCreator.getMethodParam(sortParameterIndex.intValue())});
                    } else if (parseResult.getSort() != null) {
                        finalQuery = finalQuery + JpaOperations.toOrderBy((Sort)parseResult.getSort());
                    } else if (pageableParameterIndex != null) {
                        ResultHandle pageable = methodCreator.getMethodParam(pageableParameterIndex.intValue());
                        ResultHandle pageableSort = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Pageable.class, (String)"getSort", org.springframework.data.domain.Sort.class, (Class[])new Class[0]), pageable, new ResultHandle[0]);
                        sort = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(TypesConverter.class, (String)"toPanacheSort", Sort.class, (Class[])new Class[]{org.springframework.data.domain.Sort.class}), new ResultHandle[]{pageableSort});
                    }
                    ResultHandle panacheQuery = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(JpaOperations.class, (String)"find", PanacheQuery.class, (Class[])new Class[]{Class.class, String.class, Sort.class, Object[].class}), new ResultHandle[]{methodCreator.readInstanceField(entityClassFieldDescriptor, methodCreator.getThis()), methodCreator.load(finalQuery), sort, paramsArray});
                    this.generateFindQueryResultHandling(methodCreator, panacheQuery, pageableParameterIndex, repositoryClassInfo, entityClassInfo, returnType.name(), parseResult.getTopCount(), method.name(), null);
                    continue;
                }
                if (parseResult.getQueryType() == MethodNameParser.QueryType.COUNT) {
                    if (!DotNames.PRIMITIVE_LONG.equals((Object)returnType.name()) && !DotNames.LONG.equals((Object)returnType.name())) {
                        throw new IllegalArgumentException(method.name() + " of Repository " + repositoryClassInfo + " is meant to be a count query and can therefore only have a long return type");
                    }
                    if (sortParameterIndex != null || pageableParameterIndex != null) {
                        throw new IllegalArgumentException(method.name() + " of Repository " + repositoryClassInfo + " is meant to be a count query and therefore doesn't support Pageable and Sort method parameters");
                    }
                    ResultHandle count = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(JpaOperations.class, (String)"count", Long.TYPE, (Class[])new Class[]{Class.class, String.class, Object[].class}), new ResultHandle[]{methodCreator.readInstanceField(entityClassFieldDescriptor, methodCreator.getThis()), methodCreator.load(parseResult.getQuery()), paramsArray});
                    this.handleLongReturnValue((BytecodeCreator)methodCreator, count, returnType.name());
                    continue;
                }
                if (parseResult.getQueryType() == MethodNameParser.QueryType.EXISTS) {
                    if (!DotNames.PRIMITIVE_BOOLEAN.equals((Object)returnType.name()) && !DotNames.BOOLEAN.equals((Object)returnType.name())) {
                        throw new IllegalArgumentException(method.name() + " of Repository " + repositoryClassInfo + " is meant to be an exists query and can therefore only have a boolean return type");
                    }
                    if (sortParameterIndex != null || pageableParameterIndex != null) {
                        throw new IllegalArgumentException(method.name() + " of Repository " + repositoryClassInfo + " is meant to be a count query and therefore doesn't support Pageable and Sort method parameters");
                    }
                    ResultHandle exists = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(JpaOperations.class, (String)"exists", Boolean.TYPE, (Class[])new Class[]{Class.class, String.class, Object[].class}), new ResultHandle[]{methodCreator.readInstanceField(entityClassFieldDescriptor, methodCreator.getThis()), methodCreator.load(parseResult.getQuery()), paramsArray});
                    this.handleBooleanReturnValue((BytecodeCreator)methodCreator, exists, returnType.name());
                    continue;
                }
                if (parseResult.getQueryType() != MethodNameParser.QueryType.DELETE) continue;
                if (!(DotNames.PRIMITIVE_LONG.equals((Object)returnType.name()) || DotNames.LONG.equals((Object)returnType.name()) || DotNames.VOID.equals((Object)returnType.name()))) {
                    throw new IllegalArgumentException(method.name() + " of Repository " + repositoryClassInfo + " is meant to be a delete query and can therefore only have a void or long return type");
                }
                if (sortParameterIndex != null || pageableParameterIndex != null) {
                    throw new IllegalArgumentException(method.name() + " of Repository " + repositoryClassInfo + " is meant to be a delete query and therefore doesn't support Pageable and Sort method parameters");
                }
                methodCreator.addAnnotation(Transactional.class);
                ResultHandle delete = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(JpaOperations.class, (String)"delete", Long.TYPE, (Class[])new Class[]{Class.class, String.class, Object[].class}), new ResultHandle[]{methodCreator.readInstanceField(entityClassFieldDescriptor, methodCreator.getThis()), methodCreator.load(parseResult.getQuery()), paramsArray});
                if (DotNames.VOID.equals((Object)returnType.name())) {
                    methodCreator.returnValue(null);
                }
                this.handleLongReturnValue((BytecodeCreator)methodCreator, delete, returnType.name());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (methodCreator == null) continue;
                if (throwable != null) {
                    try {
                        methodCreator.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                methodCreator.close();
            }
        }
    }
}

