/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.data.deployment.generate;

import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.spring.data.deployment.generate.FragmentMethodsUtil;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class FragmentMethodsAdder {
    private final Consumer<String> fragmentImplClassResolvedCallback;
    private final IndexView index;

    public FragmentMethodsAdder(Consumer<String> fragmentImplClassResolvedCallback, IndexView index) {
        this.fragmentImplClassResolvedCallback = fragmentImplClassResolvedCallback;
        this.index = index;
    }

    public void add(ClassCreator classCreator, String generatedClassName, List<DotName> customInterfaceNamesToImplement, Map<String, FieldDescriptor> customImplNameToHandle) {
        for (DotName customInterfaceToImplement : customInterfaceNamesToImplement) {
            String customImplementationClassName = FragmentMethodsUtil.getImplementationDotName(customInterfaceToImplement, this.index).toString();
            this.fragmentImplClassResolvedCallback.accept(customImplementationClassName);
            ClassInfo customInterfaceToImplementClassInfo = this.index.getClassByName(customInterfaceToImplement);
            if (customInterfaceToImplementClassInfo == null) {
                throw new IllegalArgumentException("Unable to implement" + customInterfaceToImplement + " because it is not known - please make sure it's part of the Quarkus index");
            }
            for (MethodInfo methodToImplement : customInterfaceToImplementClassInfo.methods()) {
                Object[] methodParameterTypes = new Object[methodToImplement.parameters().size()];
                for (int i = 0; i < methodToImplement.parameters().size(); ++i) {
                    methodParameterTypes[i] = ((Type)methodToImplement.parameters().get(i)).name().toString();
                }
                String methodReturnType = methodToImplement.returnType().name().toString();
                MethodDescriptor methodDescriptor = MethodDescriptor.ofMethod((Object)generatedClassName, (String)methodToImplement.name(), (Object)methodReturnType, (Object[])methodParameterTypes);
                if (classCreator.getExistingMethods().contains(methodDescriptor)) continue;
                MethodCreator methodCreator = classCreator.getMethodCreator(methodDescriptor);
                try {
                    ResultHandle bean = methodCreator.readInstanceField(customImplNameToHandle.get(customImplementationClassName), methodCreator.getThis());
                    ResultHandle[] methodParameterHandles = new ResultHandle[methodToImplement.parameters().size()];
                    for (int i = 0; i < methodToImplement.parameters().size(); ++i) {
                        methodParameterHandles[i] = methodCreator.getMethodParam(i);
                    }
                    ResultHandle result = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)customImplementationClassName, (String)methodToImplement.name(), (Object)methodReturnType, (Object[])methodParameterTypes), bean, methodParameterHandles);
                    if (Void.TYPE.getName().equals(methodReturnType)) {
                        methodCreator.returnValue(null);
                        continue;
                    }
                    methodCreator.returnValue(result);
                }
                finally {
                    if (methodCreator == null) continue;
                    methodCreator.close();
                }
            }
        }
    }
}

