/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.data.deployment.generate;

import io.quarkus.deployment.bean.JavaBeanUtil;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.hibernate.orm.panache.common.runtime.AbstractJpaOperations;
import io.quarkus.hibernate.orm.panache.runtime.AdditionalJpaOperations;
import io.quarkus.panache.common.Sort;
import io.quarkus.panache.common.deployment.TypeBundle;
import io.quarkus.panache.hibernate.common.runtime.PanacheJpaUtil;
import io.quarkus.spring.data.deployment.DotNames;
import io.quarkus.spring.data.deployment.MethodNameParser;
import io.quarkus.spring.data.deployment.generate.AbstractMethodsAdder;
import io.quarkus.spring.data.deployment.generate.GenerationUtil;
import io.quarkus.spring.data.runtime.TypesConverter;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.transaction.Transactional;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.springframework.data.domain.Pageable;

public class DerivedMethodsAdder
extends AbstractMethodsAdder {
    private final IndexView index;
    private final String operationsName;
    private final FieldDescriptor operationsField;
    private final ClassOutput nonBeansClassOutput;
    private final Consumer<String> projectionClassCreatedCallback;

    public DerivedMethodsAdder(IndexView index, TypeBundle typeBundle, ClassOutput nonBeansClassOutput, Consumer<String> projectionClassCreatedCallback) {
        this.index = index;
        this.operationsName = typeBundle.operations().dotName().toString();
        this.operationsField = FieldDescriptor.of((String)this.operationsName, (String)"INSTANCE", (String)this.operationsName);
        this.nonBeansClassOutput = nonBeansClassOutput;
        this.projectionClassCreatedCallback = projectionClassCreatedCallback;
    }

    public void add(ClassCreator classCreator, FieldDescriptor entityClassFieldDescriptor, String generatedClassName, ClassInfo repositoryClassInfo, ClassInfo entityClassInfo) {
        MethodNameParser methodNameParser = new MethodNameParser(entityClassInfo, this.index);
        ArrayList repoMethods = new ArrayList(repositoryClassInfo.methods());
        HashMap<DotName, List> customResultTypes = new HashMap<DotName, List>(3);
        HashMap<DotName, DotName> customResultTypeImplNames = new HashMap<DotName, DotName>(3);
        for (DotName dotName : repositoryClassInfo.interfaceNames()) {
            if (!GenerationUtil.isIntermediateRepository(dotName, this.index)) continue;
            List methods = this.index.getClassByName(dotName).methods();
            repoMethods.addAll(methods);
        }
        for (MethodInfo methodInfo : repoMethods) {
            if (methodInfo.annotation(DotNames.SPRING_DATA_QUERY) != null || classCreator.getExistingMethods().contains(GenerationUtil.toMethodDescriptor(generatedClassName, methodInfo)) || !Modifier.isAbstract(methodInfo.flags())) continue;
            Type returnType = methodInfo.returnType();
            List parameters = methodInfo.parameters();
            String[] parameterTypesStr = new String[parameters.size()];
            ArrayList<Integer> queryParameterIndexes = new ArrayList<Integer>(parameters.size());
            Integer pageableParameterIndex = null;
            Integer sortParameterIndex = null;
            for (int i = 0; i < parameters.size(); ++i) {
                DotName parameterType = ((Type)parameters.get(i)).name();
                parameterTypesStr[i] = parameterType.toString();
                if (DotNames.SPRING_DATA_PAGEABLE.equals((Object)parameterType) || DotNames.SPRING_DATA_PAGE_REQUEST.equals((Object)parameterType)) {
                    if (pageableParameterIndex != null) {
                        throw new IllegalArgumentException("Method " + methodInfo.name() + " of Repository " + repositoryClassInfo + "has invalid parameters - only a single parameter of type" + DotNames.SPRING_DATA_PAGEABLE + " can be specified");
                    }
                    pageableParameterIndex = i;
                    continue;
                }
                if (DotNames.SPRING_DATA_SORT.equals((Object)parameterType)) {
                    if (sortParameterIndex != null) {
                        throw new IllegalArgumentException("Method " + methodInfo.name() + " of Repository " + repositoryClassInfo + "has invalid parameters - only a single parameter of type" + DotNames.SPRING_DATA_SORT + " can be specified");
                    }
                    sortParameterIndex = i;
                    continue;
                }
                queryParameterIndexes.add(i);
            }
            MethodNameParser.Result parseResult = methodNameParser.parse(methodInfo);
            if (parseResult.getParamCount() != queryParameterIndexes.size()) {
                throw new IllegalArgumentException("The number of parameters of method " + methodInfo.name() + " of Repository " + repositoryClassInfo + " does not match the number of parameter needed (inferred from the method name)");
            }
            MethodCreator methodCreator = classCreator.getMethodCreator(methodInfo.name(), returnType.name().toString(), parameterTypesStr);
            try {
                ResultHandle paramsArray = methodCreator.newArray(Object.class, parseResult.getParamCount());
                for (int i = 0; i < queryParameterIndexes.size(); ++i) {
                    methodCreator.writeArrayValue(paramsArray, methodCreator.load(i), methodCreator.getMethodParam(((Integer)queryParameterIndexes.get(i)).intValue()));
                }
                if (parseResult.getQueryType() == MethodNameParser.QueryType.SELECT) {
                    if (parseResult.getSort() != null && sortParameterIndex != null) {
                        throw new IllegalArgumentException(methodInfo.name() + " of Repository " + repositoryClassInfo + " contains both a " + DotNames.SPRING_DATA_SORT + " parameter and a sort operation");
                    }
                    Object finalQuery = parseResult.getQuery();
                    ResultHandle sort = methodCreator.loadNull();
                    if (sortParameterIndex != null) {
                        sort = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(TypesConverter.class, (String)"toPanacheSort", Sort.class, (Class[])new Class[]{org.springframework.data.domain.Sort.class}), new ResultHandle[]{methodCreator.getMethodParam(sortParameterIndex.intValue())});
                    } else if (parseResult.getSort() != null) {
                        finalQuery = (String)finalQuery + PanacheJpaUtil.toOrderBy((Sort)parseResult.getSort());
                    } else if (pageableParameterIndex != null) {
                        ResultHandle pageable = methodCreator.getMethodParam(pageableParameterIndex.intValue());
                        ResultHandle pageableSort = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Pageable.class, (String)"getSort", org.springframework.data.domain.Sort.class, (Class[])new Class[0]), pageable, new ResultHandle[0]);
                        sort = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(TypesConverter.class, (String)"toPanacheSort", Sort.class, (Class[])new Class[]{org.springframework.data.domain.Sort.class}), new ResultHandle[]{pageableSort});
                    }
                    ResultHandle panacheQuery = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractJpaOperations.class, (String)"find", Object.class, (Class[])new Class[]{Class.class, String.class, Sort.class, Object[].class}), methodCreator.readStaticField(this.operationsField), new ResultHandle[]{methodCreator.readInstanceField(entityClassFieldDescriptor, methodCreator.getThis()), methodCreator.load((String)finalQuery), sort, paramsArray});
                    Type resultType = this.verifyQueryResultType(methodInfo.returnType(), this.index);
                    DotName customResultTypeName = resultType.name();
                    if (customResultTypeName.equals((Object)entityClassInfo.name()) || this.isHibernateSupportedReturnType(customResultTypeName)) {
                        customResultTypeName = null;
                    } else {
                        ClassInfo resultClassInfo = this.index.getClassByName(customResultTypeName);
                        if (Modifier.isInterface(resultClassInfo.flags())) {
                            customResultTypeName = customResultTypeImplNames.computeIfAbsent(customResultTypeName, k -> this.createSimpleInterfaceImpl(resultType.name()));
                            customResultTypes.computeIfAbsent(customResultTypeName, k -> new ArrayList()).add(methodInfo.name());
                        } else {
                            throw new IllegalArgumentException(methodInfo.name() + " of Repository " + repositoryClassInfo + " can only use interfaces to map results to non-entity types.");
                        }
                    }
                    this.generateFindQueryResultHandling(methodCreator, panacheQuery, pageableParameterIndex, repositoryClassInfo, entityClassInfo, returnType.name(), parseResult.getTopCount(), methodInfo.name(), customResultTypeName, entityClassInfo.name().toString());
                    continue;
                }
                if (parseResult.getQueryType() == MethodNameParser.QueryType.COUNT) {
                    if (!DotNames.PRIMITIVE_LONG.equals((Object)returnType.name()) && !DotNames.LONG.equals((Object)returnType.name())) {
                        throw new IllegalArgumentException(methodInfo.name() + " of Repository " + repositoryClassInfo + " is meant to be a count query and can therefore only have a long return type");
                    }
                    if (sortParameterIndex != null || pageableParameterIndex != null) {
                        throw new IllegalArgumentException(methodInfo.name() + " of Repository " + repositoryClassInfo + " is meant to be a count query and therefore doesn't support Pageable and Sort method parameters");
                    }
                    ResultHandle count = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractJpaOperations.class, (String)"count", Long.TYPE, (Class[])new Class[]{Class.class, String.class, Object[].class}), methodCreator.readStaticField(this.operationsField), new ResultHandle[]{methodCreator.readInstanceField(entityClassFieldDescriptor, methodCreator.getThis()), methodCreator.load(parseResult.getQuery()), paramsArray});
                    this.handleLongReturnValue((BytecodeCreator)methodCreator, count, returnType.name());
                    continue;
                }
                if (parseResult.getQueryType() == MethodNameParser.QueryType.EXISTS) {
                    if (!DotNames.PRIMITIVE_BOOLEAN.equals((Object)returnType.name()) && !DotNames.BOOLEAN.equals((Object)returnType.name())) {
                        throw new IllegalArgumentException(methodInfo.name() + " of Repository " + repositoryClassInfo + " is meant to be an exists query and can therefore only have a boolean return type");
                    }
                    if (sortParameterIndex != null || pageableParameterIndex != null) {
                        throw new IllegalArgumentException(methodInfo.name() + " of Repository " + repositoryClassInfo + " is meant to be a count query and therefore doesn't support Pageable and Sort method parameters");
                    }
                    ResultHandle exists = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractJpaOperations.class, (String)"exists", Boolean.TYPE, (Class[])new Class[]{Class.class, String.class, Object[].class}), methodCreator.readStaticField(this.operationsField), new ResultHandle[]{methodCreator.readInstanceField(entityClassFieldDescriptor, methodCreator.getThis()), methodCreator.load(parseResult.getQuery()), paramsArray});
                    this.handleBooleanReturnValue((BytecodeCreator)methodCreator, exists, returnType.name());
                    continue;
                }
                if (parseResult.getQueryType() != MethodNameParser.QueryType.DELETE) continue;
                if (!(DotNames.PRIMITIVE_LONG.equals((Object)returnType.name()) || DotNames.LONG.equals((Object)returnType.name()) || DotNames.VOID.equals((Object)returnType.name()))) {
                    throw new IllegalArgumentException(methodInfo.name() + " of Repository " + repositoryClassInfo + " is meant to be a delete query and can therefore only have a void or long return type");
                }
                if (sortParameterIndex != null || pageableParameterIndex != null) {
                    throw new IllegalArgumentException(methodInfo.name() + " of Repository " + repositoryClassInfo + " is meant to be a delete query and therefore doesn't support Pageable and Sort method parameters");
                }
                methodCreator.addAnnotation(Transactional.class);
                AnnotationInstance modifyingAnnotation = methodInfo.annotation(DotNames.SPRING_DATA_MODIFYING);
                this.handleFlushAutomatically(modifyingAnnotation, methodCreator, entityClassFieldDescriptor);
                ResultHandle delete = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(AdditionalJpaOperations.class, (String)"deleteWithCascade", Long.TYPE, (Class[])new Class[]{AbstractJpaOperations.class, Class.class, String.class, Object[].class}), new ResultHandle[]{methodCreator.readStaticField(this.operationsField), methodCreator.readInstanceField(entityClassFieldDescriptor, methodCreator.getThis()), methodCreator.load(parseResult.getQuery()), paramsArray});
                this.handleClearAutomatically(modifyingAnnotation, methodCreator, entityClassFieldDescriptor);
                if (DotNames.VOID.equals((Object)returnType.name())) {
                    methodCreator.returnValue(null);
                }
                this.handleLongReturnValue((BytecodeCreator)methodCreator, delete, returnType.name());
            }
            finally {
                if (methodCreator == null) continue;
                methodCreator.close();
            }
        }
        for (Map.Entry entry : customResultTypeImplNames.entrySet()) {
            DotName interfaceName = (DotName)entry.getKey();
            DotName implName = (DotName)entry.getValue();
            this.generateCustomResultTypes(interfaceName, implName, entityClassInfo, (List)customResultTypes.get(implName));
            this.projectionClassCreatedCallback.accept(implName.toString());
        }
    }

    private void generateCustomResultTypes(DotName interfaceName, DotName implName, ClassInfo entityClassInfo, List<String> queryMethods) {
        ClassInfo interfaceInfo = this.index.getClassByName(interfaceName);
        try (ClassCreator implClassCreator = ClassCreator.builder().classOutput(this.nonBeansClassOutput).interfaces(new String[]{interfaceName.toString()}).className(implName.toString()).build();){
            HashMap<String, FieldDescriptor> fields = new HashMap<String, FieldDescriptor>(3);
            for (MethodInfo method : interfaceInfo.methods()) {
                String getterName = method.name();
                String propertyName = JavaBeanUtil.getPropertyNameFromGetter((String)getterName);
                Type returnType = method.returnType();
                if (returnType.kind() == Type.Kind.VOID) {
                    throw new IllegalArgumentException("Method " + method.name() + " of interface " + interfaceName + " is not a getter method since it returns void");
                }
                DotName fieldTypeName = this.getPrimitiveTypeName(returnType.name());
                FieldDescriptor field = implClassCreator.getFieldCreator(propertyName, fieldTypeName.toString()).getFieldDescriptor();
                try (MethodCreator getter = implClassCreator.getMethodCreator(getterName, returnType.toString(), new String[0]);){
                    getter.setModifiers(1);
                    getter.returnValue(getter.readInstanceField(field, getter.getThis()));
                }
                fields.put(getterName, field);
            }
            for (String queryMethod : queryMethods) {
                MethodCreator convert = implClassCreator.getMethodCreator("convert_" + queryMethod, implName.toString(), new String[]{entityClassInfo.name().toString()});
                try {
                    convert.setModifiers(8);
                    ResultHandle newObject = convert.newInstance(MethodDescriptor.ofConstructor((String)implName.toString(), (String[])new String[0]), new ResultHandle[0]);
                    ResultHandle entity = convert.getMethodParam(0);
                    List availableMethods = entityClassInfo.methods();
                    for (Map.Entry field : fields.entrySet()) {
                        if (!this.getterExists(availableMethods, (String)field.getKey())) {
                            throw new IllegalArgumentException((String)field.getKey() + " method does not exists in " + entityClassInfo.name().toString() + " class.");
                        }
                        FieldDescriptor f = (FieldDescriptor)field.getValue();
                        convert.writeInstanceField(f, newObject, convert.invokeVirtualMethod(MethodDescriptor.ofMethod((String)entityClassInfo.name().toString(), (String)((String)field.getKey()), (String)f.getType(), (String[])new String[0]), entity, new ResultHandle[0]));
                    }
                    convert.returnValue(newObject);
                }
                finally {
                    if (convert == null) continue;
                    convert.close();
                }
            }
        }
    }

    private boolean getterExists(List<MethodInfo> methods, String getterName) {
        for (MethodInfo method : methods) {
            if (!method.name().equals(getterName)) continue;
            return true;
        }
        return false;
    }
}

