/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.data.deployment;

import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.panache.common.Sort;
import io.quarkus.spring.data.deployment.DotNames;
import io.quarkus.spring.data.deployment.UnableToParseMethodException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;

public class MethodNameParser {
    private static final String ALL_IGNORE_CASE = "AllIgnoreCase";
    private static final String IGNORE_CASE = "IgnoreCase";
    private static final String ORDER_BY = "OrderBy";
    private static final List<String> HANDLED_PROPERTY_OPERATIONS = Arrays.asList("Is", "Equals", "IsNot", "Not", "IsNull", "Null", "IsNotNull", "NotNull", "IsBetween", "Between", "IsLessThan", "LessThan", "IsLessThanEqual", "LessThanEqual", "IsGreaterThan", "GreaterThan", "IsGreaterThanEqual", "GreaterThanEqual", "IsLike", "Like", "IsNotLike", "NotLike", "IsStartingWith", "StartingWith", "StartsWith", "IsEndingWith", "EndingWith", "EndsWith", "IsContaining", "Containing", "Contains", "Before", "IsBefore", "After", "IsAfter", "True", "False", "IsIn", "In", "IsNotIn", "NotIn", "IsEmpty", "Empty", "IsNotEmpty", "NotEmpty");
    private static final Set<String> STRING_LIKE_OPERATIONS = new HashSet<String>(Arrays.asList("IsLike", "Like", "IsNotLike", "NotLike", "IsStartingWith", "StartingWith", "StartsWith", "IsEndingWith", "EndingWith", "EndsWith", "IsContaining", "Containing", "Contains"));
    private static final Set<String> BOOLEAN_OPERATIONS = new HashSet<String>(Arrays.asList("True", "False"));
    private final ClassInfo entityClass;
    private final IndexView indexView;
    private final List<ClassInfo> mappedSuperClassInfos;

    public MethodNameParser(ClassInfo entityClass, IndexView indexView) {
        this.entityClass = entityClass;
        this.indexView = indexView;
        this.mappedSuperClassInfos = this.getSuperClassInfos(indexView, entityClass);
    }

    public Result parse(MethodInfo methodInfo) {
        String methodName = methodInfo.name();
        ClassInfo repositoryClassInfo = methodInfo.declaringClass();
        String repositoryMethodDescription = "'" + methodName + "' of repository '" + repositoryClassInfo + "'";
        QueryType queryType = this.getType(methodName);
        if (queryType == null) {
            throw new UnableToParseMethodException("Method " + repositoryMethodDescription + " cannot be parsed. Did you forget to annotate the method with '@Query'?");
        }
        int byIndex = methodName.indexOf("By");
        if (byIndex == -1 || byIndex + 2 >= methodName.length()) {
            throw new UnableToParseMethodException("Method " + repositoryMethodDescription + " cannot be parsed as there is no proper 'By' clause in the name.");
        }
        Integer topCount = null;
        int minFirstOrTopIndex = Math.min(this.indexOfOrMaxValue(methodName, "First"), this.indexOfOrMaxValue(methodName, "Top"));
        if (minFirstOrTopIndex < byIndex) {
            if (queryType != QueryType.SELECT) {
                throw new UnableToParseMethodException("When 'Top' or 'First' is specified, the query must be a find query. Offending method is " + repositoryMethodDescription + ".");
            }
            try {
                String topCountStr = methodName.substring(minFirstOrTopIndex, byIndex).replace("Top", "").replace("First", "");
                topCount = topCountStr.isEmpty() ? Integer.valueOf(1) : Integer.valueOf(topCountStr);
            }
            catch (Exception e) {
                throw new UnableToParseMethodException("Unable to parse query with limiting results clause. Offending method is " + repositoryMethodDescription + ".");
            }
        }
        if (methodName.substring(0, byIndex).contains("Distinct")) {
            throw new UnableToParseMethodException("Distinct is not yet supported. Offending method is " + repositoryMethodDescription + ".");
        }
        String afterByPart = methodName.substring(byIndex + 2);
        boolean allIgnoreCase = false;
        if (afterByPart.contains(ALL_IGNORE_CASE)) {
            allIgnoreCase = true;
            afterByPart = afterByPart.replace(ALL_IGNORE_CASE, "");
        }
        Sort sort = null;
        if (this.containsLogicOperator(afterByPart, ORDER_BY)) {
            int orderByIndex = afterByPart.indexOf(ORDER_BY);
            if (orderByIndex + ORDER_BY.length() == afterByPart.length()) {
                throw new UnableToParseMethodException("A field must by supplied after 'OrderBy' . Offending method is " + repositoryMethodDescription + ".");
            }
            String afterOrderByPart = afterByPart.substring(orderByIndex + ORDER_BY.length());
            afterByPart = afterByPart.substring(0, orderByIndex);
            boolean ascending = true;
            if (afterOrderByPart.endsWith("Asc")) {
                ascending = true;
                afterOrderByPart = afterOrderByPart.replace("Asc", "");
            } else if (afterOrderByPart.endsWith("Desc")) {
                ascending = false;
                afterOrderByPart = afterOrderByPart.replace("Desc", "");
            }
            String orderField = this.lowerFirstLetter(afterOrderByPart);
            if (!this.entityContainsField(orderField)) {
                throw new UnableToParseMethodException("Field " + orderField + " which was configured as the order field does not exist in the entity. Offending method is " + repositoryMethodDescription + ".");
            }
            sort = ascending ? Sort.ascending((String[])new String[]{orderField}) : Sort.descending((String[])new String[]{orderField});
        }
        List<String> parts = Collections.singletonList(afterByPart);
        boolean containsAnd = this.containsLogicOperator(afterByPart, "And");
        boolean containsOr = this.containsLogicOperator(afterByPart, "Or");
        if (containsAnd && containsOr) {
            throw new UnableToParseMethodException("'And' and 'Or' clauses cannot be mixed in a method name - Try specifying the Query with the @Query annotation. Offending method is " + repositoryMethodDescription + ".");
        }
        if (containsAnd) {
            parts = Arrays.asList(afterByPart.split("And"));
        } else if (containsOr) {
            parts = Arrays.asList(afterByPart.split("Or"));
        }
        MutableReference<List<ClassInfo>> mappedSuperClassInfoRef = MutableReference.of(this.mappedSuperClassInfos);
        StringBuilder where = new StringBuilder();
        int paramsCount = 0;
        for (String part : parts) {
            String operation;
            String fieldName;
            FieldInfo fieldInfo;
            if (part.isEmpty()) continue;
            boolean ignoreCase = false;
            if (part.endsWith(IGNORE_CASE)) {
                ignoreCase = true;
                part = part.replace(IGNORE_CASE, "");
            }
            if ((fieldInfo = this.getFieldInfo(fieldName = (operation = this.getFieldOperation(part)) == null ? this.lowerFirstLetter(part) : this.lowerFirstLetter(part.replaceAll(operation, "")), this.entityClass, mappedSuperClassInfoRef)) == null) {
                StringBuilder fieldPathBuilder = new StringBuilder(fieldName.length() + 5);
                fieldInfo = this.resolveNestedField(repositoryMethodDescription, fieldName, fieldPathBuilder);
                fieldName = fieldPathBuilder.toString();
            }
            this.validateFieldWithOperation(operation, fieldInfo, fieldName, repositoryMethodDescription);
            if ((ignoreCase || allIgnoreCase) && !DotNames.STRING.equals((Object)fieldInfo.type().name())) {
                throw new UnableToParseMethodException("IgnoreCase cannot be specified for field" + fieldInfo.name() + " because it is not a String type. Offending method is " + repositoryMethodDescription + ".");
            }
            if (where.length() > 0) {
                where.append(containsAnd ? " AND " : " OR ");
            }
            String upperPrefix = ignoreCase || allIgnoreCase ? "UPPER(" : "";
            String upperSuffix = ignoreCase || allIgnoreCase ? ")" : "";
            where.append(upperPrefix).append(fieldName).append(upperSuffix);
            if (operation == null || "Equals".equals(operation) || "Is".equals(operation)) {
                where.append(" = ").append(upperPrefix).append("?").append(++paramsCount).append(upperSuffix);
                continue;
            }
            switch (operation) {
                case "IsNot": 
                case "Not": {
                    where.append(" <> ?").append(++paramsCount);
                    break;
                }
                case "IsNull": 
                case "Null": {
                    where.append(" IS null ");
                    break;
                }
                case "IsNotNull": 
                case "NotNull": {
                    where.append(" IS NOT null ");
                    break;
                }
                case "Between": 
                case "IsBetween": {
                    where.append(" BETWEEN ");
                    where.append("?").append(++paramsCount).append(" AND ");
                    where.append("?").append(++paramsCount);
                    break;
                }
                case "LessThan": 
                case "IsLessThan": 
                case "Before": 
                case "IsBefore": {
                    where.append(" < ?").append(++paramsCount);
                    break;
                }
                case "LessThanEqual": 
                case "IsLessThanEqual": {
                    where.append(" <= ?").append(++paramsCount);
                    break;
                }
                case "GreaterThan": 
                case "IsGreaterThan": 
                case "After": 
                case "IsAfter": {
                    where.append(" > ?").append(++paramsCount);
                    break;
                }
                case "GreaterThanEqual": 
                case "IsGreaterThanEqual": {
                    where.append(" >= ?").append(++paramsCount);
                    break;
                }
                case "Like": 
                case "IsLike": {
                    where.append(" LIKE ?").append(++paramsCount);
                    break;
                }
                case "NotLike": 
                case "IsNotLike": {
                    where.append(" NOT LIKE ?").append(++paramsCount);
                    break;
                }
                case "IsStartingWith": 
                case "StartingWith": 
                case "StartsWith": {
                    where.append(" LIKE CONCAT(").append(upperPrefix).append("?").append(++paramsCount).append(upperSuffix).append(", '%')");
                    break;
                }
                case "IsEndingWith": 
                case "EndingWith": 
                case "EndsWith": {
                    where.append(" LIKE CONCAT('%', ").append(upperPrefix).append("?").append(++paramsCount).append(upperSuffix).append(")");
                    break;
                }
                case "IsContaining": 
                case "Containing": 
                case "Contains": {
                    where.append(" LIKE CONCAT('%', ").append(upperPrefix).append("?").append(++paramsCount).append(upperSuffix).append(", '%')");
                    break;
                }
                case "True": 
                case "False": {
                    where.append(" = ").append(operation.toLowerCase());
                    break;
                }
                case "IsIn": 
                case "In": {
                    where.append(" IN ?").append(++paramsCount);
                    break;
                }
                case "IsNotIn": 
                case "NotIn": {
                    where.append(" NOT IN ?").append(++paramsCount);
                    break;
                }
                case "IsEmpty": 
                case "Empty": {
                    where.append(" IS EMPTY");
                    break;
                }
                case "IsNotEmpty": 
                case "NotEmpty": {
                    where.append(" IS NOT EMPTY");
                }
            }
        }
        String whereQuery = where.toString().isEmpty() ? "" : " WHERE " + where.toString();
        return new Result(this.entityClass, "FROM " + this.getEntityName() + whereQuery, queryType, paramsCount, sort, topCount);
    }

    private int indexOfOrMaxValue(String methodName, String term) {
        int index = methodName.indexOf(term);
        return index != -1 ? index : Integer.MAX_VALUE;
    }

    private FieldInfo resolveNestedField(String repositoryMethodDescription, String fieldPathExpression, StringBuilder fieldPathBuilder) {
        String fieldNotResolvableMessage = "Entity " + this.entityClass + " does not contain a field named: " + fieldPathExpression + ". ";
        String offendingMethodMessage = "Offending method is " + repositoryMethodDescription + ".";
        ClassInfo parentClassInfo = this.entityClass;
        FieldInfo fieldInfo = null;
        MutableReference<List<ClassInfo>> parentSuperClassInfos = new MutableReference<List<ClassInfo>>();
        int fieldStartIndex = 0;
        while (fieldStartIndex < fieldPathExpression.length()) {
            String simpleFieldName;
            int fieldEndIndex;
            if (fieldPathExpression.charAt(fieldStartIndex) == '_' && ++fieldStartIndex >= fieldPathExpression.length()) {
                throw new UnableToParseMethodException(fieldNotResolvableMessage + offendingMethodMessage);
            }
            int firstSeparator = fieldPathExpression.indexOf(95, fieldStartIndex);
            int n = fieldEndIndex = firstSeparator == -1 ? fieldPathExpression.length() : firstSeparator;
            while (fieldEndIndex >= fieldStartIndex && (fieldInfo = this.getFieldInfo(simpleFieldName = this.lowerFirstLetter(fieldPathExpression.substring(fieldStartIndex, fieldEndIndex)), parentClassInfo, parentSuperClassInfos)) == null) {
                fieldEndIndex = this.previousPotentialFieldEnd(fieldPathExpression, fieldStartIndex, fieldEndIndex);
            }
            if (fieldInfo == null) {
                Object detail = "";
                if (fieldStartIndex > 0) {
                    String notMatched = this.lowerFirstLetter(fieldPathExpression.substring(fieldStartIndex));
                    detail = "Can not resolve " + parentClassInfo + "." + notMatched + ". ";
                }
                throw new UnableToParseMethodException(fieldNotResolvableMessage + (String)detail + offendingMethodMessage);
            }
            if (fieldPathBuilder.length() > 0) {
                fieldPathBuilder.append('.');
            }
            fieldPathBuilder.append(fieldInfo.name());
            if (!this.isHibernateProvidedBasicType(fieldInfo.type().name())) {
                DotName parentClassName;
                boolean typed = false;
                if (fieldInfo.type().kind() == Type.Kind.TYPE_VARIABLE) {
                    typed = true;
                    parentClassName = this.getParentNameFromTypedFieldViaHierarchy(fieldInfo, this.mappedSuperClassInfos);
                } else {
                    parentClassName = fieldInfo.type().name();
                }
                parentClassInfo = this.indexView.getClassByName(parentClassName);
                parentSuperClassInfos.set(null);
                if (parentClassInfo == null) {
                    throw new IllegalStateException("Entity class " + fieldInfo.type().name() + " referenced by " + this.entityClass + "." + fieldPathBuilder + " was not part of the Quarkus index" + (typed ? " or typed field could not be resolved properly. " : ". ") + offendingMethodMessage);
                }
            }
            fieldStartIndex = fieldEndIndex;
        }
        return fieldInfo;
    }

    private int previousPotentialFieldEnd(String fieldName, int fieldStartIndex, int fieldEndIndexExclusive) {
        for (int i = fieldEndIndexExclusive - 1; i > fieldStartIndex; --i) {
            char c = fieldName.charAt(i);
            if (c < 'A' || c > 'Z') continue;
            return i;
        }
        return -1;
    }

    private boolean containsLogicOperator(String str, String operatorStr) {
        int index = str.indexOf(operatorStr);
        if (index == -1) {
            return false;
        }
        if (str.length() < index + operatorStr.length() + 1) {
            return false;
        }
        return Character.isUpperCase(str.charAt(index + operatorStr.length()));
    }

    private void validateFieldWithOperation(String operation, FieldInfo fieldInfo, String fieldPath, String repositoryMethodDescription) {
        DotName fieldTypeDotName = fieldInfo.type().name();
        if (STRING_LIKE_OPERATIONS.contains(operation) && !DotNames.STRING.equals((Object)fieldTypeDotName)) {
            throw new UnableToParseMethodException(operation + " cannot be specified for field" + fieldPath + " because it is not a String type. Offending method is " + repositoryMethodDescription + ".");
        }
        if (BOOLEAN_OPERATIONS.contains(operation) && !DotNames.BOOLEAN.equals((Object)fieldTypeDotName) && !DotNames.PRIMITIVE_BOOLEAN.equals((Object)fieldTypeDotName)) {
            throw new UnableToParseMethodException(operation + " cannot be specified for field" + fieldPath + " because it is not a boolean type. Offending method is " + repositoryMethodDescription + ".");
        }
    }

    private QueryType getType(String methodName) {
        if (methodName.startsWith("find") || methodName.startsWith("query") || methodName.startsWith("read") || methodName.startsWith("get")) {
            return QueryType.SELECT;
        }
        if (methodName.startsWith("count")) {
            return QueryType.COUNT;
        }
        if (methodName.startsWith("delete") || methodName.startsWith("remove")) {
            return QueryType.DELETE;
        }
        if (methodName.startsWith("exists")) {
            return QueryType.EXISTS;
        }
        return null;
    }

    private String getFieldOperation(String part) {
        ArrayList<String> matches = new ArrayList<String>();
        for (String handledPropertyOperation : HANDLED_PROPERTY_OPERATIONS) {
            if (!part.endsWith(handledPropertyOperation)) continue;
            matches.add(handledPropertyOperation);
        }
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() == 1) {
            return (String)matches.get(0);
        }
        matches.sort(Comparator.comparing(String::length).reversed());
        return (String)matches.get(0);
    }

    private String lowerFirstLetter(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        if (input.length() == 1) {
            return input.toLowerCase();
        }
        return Character.toLowerCase(input.charAt(0)) + input.substring(1);
    }

    private String getEntityName() {
        AnnotationInstance annotationInstance = this.entityClass.declaredAnnotation(DotNames.JPA_ENTITY);
        if (annotationInstance != null && annotationInstance.value("name") != null) {
            AnnotationValue annotationValue = annotationInstance.value("name");
            return annotationValue.asString().length() > 0 ? annotationValue.asString() : this.entityClass.simpleName();
        }
        return this.entityClass.simpleName();
    }

    private boolean entityContainsField(String fieldName) {
        if (this.entityClass.field(fieldName) != null) {
            return true;
        }
        for (ClassInfo superClass : this.mappedSuperClassInfos) {
            FieldInfo fieldInfo = superClass.field(fieldName);
            if (fieldInfo == null) continue;
            return true;
        }
        return false;
    }

    private FieldInfo getFieldInfo(String fieldName, ClassInfo entityClass, MutableReference<List<ClassInfo>> superClassInfos) {
        FieldInfo fieldInfo;
        block2: {
            ClassInfo superClass;
            fieldInfo = entityClass.field(fieldName);
            if (fieldInfo != null) break block2;
            if (superClassInfos.isEmpty()) {
                superClassInfos.set(this.getSuperClassInfos(this.indexView, entityClass));
            }
            Iterator<ClassInfo> iterator = superClassInfos.get().iterator();
            while (iterator.hasNext() && (fieldInfo = (superClass = iterator.next()).field(fieldName)) == null) {
            }
        }
        return fieldInfo;
    }

    private List<ClassInfo> getSuperClassInfos(IndexView indexView, ClassInfo entityClass) {
        ArrayList<ClassInfo> mappedSuperClassInfoElements = new ArrayList<ClassInfo>(3);
        Type superClassType = entityClass.superClassType();
        while (superClassType != null && !superClassType.name().equals((Object)DotNames.OBJECT)) {
            ClassInfo superClass = indexView.getClassByName(superClassType.name());
            if (superClass.declaredAnnotation(DotNames.JPA_MAPPED_SUPERCLASS) != null) {
                mappedSuperClassInfoElements.add(superClass);
            } else if (superClass.declaredAnnotation(DotNames.JPA_INHERITANCE) != null) {
                mappedSuperClassInfoElements.add(superClass);
            }
            superClassType = superClass.superClassType();
        }
        return mappedSuperClassInfoElements;
    }

    private boolean isHibernateProvidedBasicType(DotName dotName) {
        return DotNames.HIBERNATE_PROVIDED_BASIC_TYPES.contains(dotName);
    }

    private DotName getParentNameFromTypedFieldViaHierarchy(FieldInfo fieldInfo, List<ClassInfo> parentSuperClassInfos) {
        int superClassIndex = parentSuperClassInfos.indexOf(fieldInfo.declaringClass());
        if (superClassIndex == -1) {
            return fieldInfo.type().name();
        }
        TypeVariable typeVariable = fieldInfo.type().asTypeVariable();
        ArrayList<ClassInfo> classInfos = new ArrayList<ClassInfo>();
        classInfos.add(this.entityClass);
        classInfos.addAll(parentSuperClassInfos.subList(0, superClassIndex + 1));
        for (int i = classInfos.size() - 1; i > 0; --i) {
            ClassInfo currentClassInfo = (ClassInfo)classInfos.get(i);
            ClassInfo childClassInfo = (ClassInfo)classInfos.get(i - 1);
            int typeParameterIndex = currentClassInfo.typeParameters().indexOf(typeVariable);
            if (typeParameterIndex < 0) continue;
            List resolveTypeParameters = JandexUtil.resolveTypeParameters((DotName)childClassInfo.name(), (DotName)currentClassInfo.name(), (IndexView)this.indexView);
            if (resolveTypeParameters.size() <= typeParameterIndex) break;
            Type type = (Type)resolveTypeParameters.get(typeParameterIndex);
            if (type.kind() == Type.Kind.TYPE_VARIABLE) {
                typeVariable = type.asTypeVariable();
                continue;
            }
            if (type.kind() != Type.Kind.CLASS) continue;
            return type.name();
        }
        return typeVariable.name();
    }

    public static class Result {
        private final ClassInfo entityClass;
        private final String query;
        private final QueryType queryType;
        private final int paramCount;
        private final Sort sort;
        private final Integer topCount;

        public Result(ClassInfo entityClass, String query, QueryType queryType, int paramCount, Sort sort, Integer topCount) {
            this.entityClass = entityClass;
            this.query = query;
            this.queryType = queryType;
            this.paramCount = paramCount;
            this.sort = sort;
            this.topCount = topCount;
        }

        public ClassInfo getEntityClass() {
            return this.entityClass;
        }

        public String getQuery() {
            return this.query;
        }

        public QueryType getQueryType() {
            return this.queryType;
        }

        public int getParamCount() {
            return this.paramCount;
        }

        public Sort getSort() {
            return this.sort;
        }

        public Integer getTopCount() {
            return this.topCount;
        }
    }

    private static class MutableReference<T> {
        private T reference;

        public static <T> MutableReference<T> of(T reference) {
            return new MutableReference<T>(reference);
        }

        public MutableReference() {
        }

        private MutableReference(T reference) {
            this.reference = reference;
        }

        public T get() {
            return this.reference;
        }

        public void set(T value) {
            this.reference = value;
        }

        public boolean isEmpty() {
            return this.reference == null;
        }
    }

    public static enum QueryType {
        SELECT,
        COUNT,
        EXISTS,
        DELETE;

    }
}

