/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.data.runtime;

import io.quarkus.hibernate.orm.panache.PanacheQuery;
import io.quarkus.hibernate.orm.panache.common.runtime.AbstractJpaOperations;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.EntityManager;

public final class RepositorySupport {
    private RepositorySupport() {
    }

    public static List<?> findByIds(AbstractJpaOperations<PanacheQuery<?>> operations, Class<?> entityClass, Iterable<?> ids) {
        Objects.requireNonNull(ids);
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object id : ids) {
            Object byId = operations.findById(entityClass, id);
            if (byId == null) continue;
            result.add(byId);
        }
        return result;
    }

    public static List<?> findByIds(AbstractJpaOperations<PanacheQuery<?>> operations, Class<?> entityClass, String idField, Iterable<Long> ids) {
        Objects.requireNonNull(ids);
        return ((PanacheQuery)operations.find(entityClass, String.format("%s in ?1", idField), new Object[]{ids})).list();
    }

    public static void deleteAll(AbstractJpaOperations<PanacheQuery<?>> operations, Iterable<?> entities) {
        for (Object entity : entities) {
            operations.delete(entity);
        }
    }

    public static Object getOne(AbstractJpaOperations<PanacheQuery<?>> operations, Class<?> entityClass, Object id) {
        return AbstractJpaOperations.getEntityManager().getReference(entityClass, id);
    }

    public static void clear(Class<?> clazz) {
        EntityManager em = AbstractJpaOperations.getEntityManager(clazz);
        em.clear();
    }

    public static void flush(Class<?> clazz) {
        EntityManager em = AbstractJpaOperations.getEntityManager(clazz);
        em.flush();
    }
}

