/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.data.runtime;

import io.quarkus.panache.common.Page;
import io.quarkus.panache.common.Sort;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public final class TypesConverter {
    private TypesConverter() {
    }

    public static Sort toPanacheSort(org.springframework.data.domain.Sort sort) {
        List orders = sort.get().collect(Collectors.toList());
        if (orders.isEmpty()) {
            return null;
        }
        Sort.Order firstOrder = (Sort.Order)orders.get(0);
        Sort result = Sort.by((String)firstOrder.getProperty(), (Sort.Direction)TypesConverter.getDirection(firstOrder));
        if (orders.size() == 1) {
            return result;
        }
        for (int i = 1; i < orders.size(); ++i) {
            Sort.Order order = (Sort.Order)orders.get(i);
            result = result.and(order.getProperty(), TypesConverter.getDirection(order));
        }
        return result;
    }

    private static Sort.Direction getDirection(Sort.Order order) {
        return order.getDirection() == Sort.Direction.ASC ? Sort.Direction.Ascending : Sort.Direction.Descending;
    }

    public static Page toPanachePage(Pageable pageable) {
        if (pageable.isPaged()) {
            int pageNumber = pageable.getPageNumber();
            int pageSize = pageable.getPageSize();
            return new Page(pageNumber, pageSize);
        }
        return null;
    }
}

