/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.data.runtime;

import io.quarkus.hibernate.orm.panache.runtime.JpaOperations;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class RepositorySupport {
    private RepositorySupport() {
    }

    public static List<?> findByIds(Class<?> entityClass, Iterable<?> ids) {
        Objects.requireNonNull(ids);
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object id : ids) {
            Object byId = JpaOperations.findById(entityClass, id);
            if (byId == null) continue;
            result.add(byId);
        }
        return result;
    }

    public static List<?> findByIds(Class<?> entityClass, String idField, Iterable<Long> ids) {
        Objects.requireNonNull(ids);
        return JpaOperations.find(entityClass, (String)String.format("%s in ?1", idField), (Object[])new Object[]{ids}).list();
    }

    public static void deleteAll(Iterable<?> entities) {
        for (Object entity : entities) {
            JpaOperations.delete(entity);
        }
    }

    public static Object getOne(Class<?> entityClass, Object id) {
        return JpaOperations.getEntityManager().getReference(entityClass, id);
    }
}

