/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.data.rest.deployment;

import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.rest.data.panache.RestDataResource;
import io.quarkus.runtime.util.HashUtil;
import io.quarkus.spring.data.rest.deployment.ResourceMethodsImplementor;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.logging.Logger;

public class ResourceImplementor {
    private static final Logger LOGGER = Logger.getLogger(ResourceImplementor.class);
    private final ResourceMethodsImplementor methodsImplementor;

    protected ResourceImplementor(ResourceMethodsImplementor methodsImplementor) {
        this.methodsImplementor = methodsImplementor;
    }

    public String implement(ClassOutput classOutput, String resourceType, String entityType) {
        String className = resourceType + "ResourceImpl_" + HashUtil.sha1((String)resourceType);
        LOGGER.tracef("Starting generation of '%s'", (Object)className);
        ClassCreator classCreator = ClassCreator.builder().classOutput(classOutput).className(className).interfaces(new Class[]{RestDataResource.class}).build();
        classCreator.addAnnotation(ApplicationScoped.class);
        this.methodsImplementor.implementList(classCreator, resourceType);
        this.methodsImplementor.implementListPageCount(classCreator, resourceType);
        this.methodsImplementor.implementGet(classCreator, resourceType);
        this.methodsImplementor.implementAdd(classCreator, resourceType);
        this.methodsImplementor.implementUpdate(classCreator, resourceType, entityType);
        this.methodsImplementor.implementDelete(classCreator, resourceType);
        classCreator.close();
        LOGGER.tracef("Completed generation of '%s'", (Object)className);
        return className;
    }
}

