/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.data.rest.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.rest.data.panache.RestDataPanacheException;
import io.quarkus.rest.data.panache.deployment.ResourceMetadata;
import io.quarkus.rest.data.panache.deployment.RestDataResourceBuildItem;
import io.quarkus.rest.data.panache.deployment.properties.ResourceProperties;
import io.quarkus.rest.data.panache.deployment.properties.ResourcePropertiesBuildItem;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import io.quarkus.resteasy.reactive.spi.ExceptionMapperBuildItem;
import io.quarkus.spring.data.rest.deployment.ResourceImplementor;
import io.quarkus.spring.data.rest.deployment.ResourceMethodsImplementor;
import io.quarkus.spring.data.rest.deployment.ResourcePropertiesProvider;
import io.quarkus.spring.data.rest.deployment.crud.CrudMethodsImplementor;
import io.quarkus.spring.data.rest.deployment.crud.CrudPropertiesProvider;
import io.quarkus.spring.data.rest.deployment.paging.PagingAndSortingMethodsImplementor;
import io.quarkus.spring.data.rest.deployment.paging.PagingAndSortingPropertiesProvider;
import io.quarkus.spring.data.rest.runtime.RestDataPanacheExceptionMapper;
import io.quarkus.spring.data.rest.runtime.jta.TransactionalUpdateExecutor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.PagingAndSortingRepository;

class SpringDataRestProcessor {
    private static final DotName CRUD_REPOSITORY_INTERFACE = DotName.createSimple((String)CrudRepository.class.getName());
    private static final DotName PAGING_AND_SORTING_REPOSITORY_INTERFACE = DotName.createSimple((String)PagingAndSortingRepository.class.getName());
    private static final DotName JPA_REPOSITORY_INTERFACE = DotName.createSimple((String)JpaRepository.class.getName());
    private static final List<DotName> EXCLUDED_INTERFACES = Arrays.asList(CRUD_REPOSITORY_INTERFACE, PAGING_AND_SORTING_REPOSITORY_INTERFACE, JPA_REPOSITORY_INTERFACE);

    SpringDataRestProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.SPRING_DATA_REST);
    }

    @BuildStep
    void registerRestDataPanacheExceptionMapper(BuildProducer<ResteasyJaxrsProviderBuildItem> resteasyJaxrsProviderBuildItemBuildProducer, BuildProducer<ExceptionMapperBuildItem> exceptionMapperBuildItemBuildProducer) {
        resteasyJaxrsProviderBuildItemBuildProducer.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(RestDataPanacheExceptionMapper.class.getName()));
        exceptionMapperBuildItemBuildProducer.produce((BuildItem)new ExceptionMapperBuildItem(RestDataPanacheExceptionMapper.class.getName(), RestDataPanacheException.class.getName(), Integer.valueOf(5100), false));
    }

    @BuildStep
    AdditionalBeanBuildItem registerTransactionalExecutor() {
        return AdditionalBeanBuildItem.unremovableOf(TransactionalUpdateExecutor.class);
    }

    @BuildStep
    void registerCrudRepositories(CombinedIndexBuildItem indexBuildItem, Capabilities capabilities, BuildProducer<GeneratedBeanBuildItem> implementationsProducer, BuildProducer<RestDataResourceBuildItem> restDataResourceProducer, BuildProducer<ResourcePropertiesBuildItem> resourcePropertiesProducer, BuildProducer<UnremovableBeanBuildItem> unremovableBeansProducer) {
        IndexView index = indexBuildItem.getIndex();
        this.implementResources(capabilities, implementationsProducer, restDataResourceProducer, resourcePropertiesProducer, unremovableBeansProducer, new CrudMethodsImplementor(index), new CrudPropertiesProvider(index), this.getRepositoriesToImplement(index, CRUD_REPOSITORY_INTERFACE));
    }

    @BuildStep
    void registerPagingAndSortingRepositories(CombinedIndexBuildItem indexBuildItem, Capabilities capabilities, BuildProducer<GeneratedBeanBuildItem> implementationsProducer, BuildProducer<RestDataResourceBuildItem> restDataResourceProducer, BuildProducer<ResourcePropertiesBuildItem> resourcePropertiesProducer, BuildProducer<UnremovableBeanBuildItem> unremovableBeansProducer) {
        IndexView index = indexBuildItem.getIndex();
        this.implementResources(capabilities, implementationsProducer, restDataResourceProducer, resourcePropertiesProducer, unremovableBeansProducer, new PagingAndSortingMethodsImplementor(index), new PagingAndSortingPropertiesProvider(index), this.getRepositoriesToImplement(index, PAGING_AND_SORTING_REPOSITORY_INTERFACE, JPA_REPOSITORY_INTERFACE));
    }

    private void implementResources(Capabilities capabilities, BuildProducer<GeneratedBeanBuildItem> implementationsProducer, BuildProducer<RestDataResourceBuildItem> restDataResourceProducer, BuildProducer<ResourcePropertiesBuildItem> resourcePropertiesProducer, BuildProducer<UnremovableBeanBuildItem> unremovableBeansProducer, ResourceMethodsImplementor methodsImplementor, ResourcePropertiesProvider propertiesProvider, List<ClassInfo> repositoriesToImplement) {
        GeneratedBeanGizmoAdaptor classOutput = new GeneratedBeanGizmoAdaptor(implementationsProducer);
        ResourceImplementor resourceImplementor = new ResourceImplementor(methodsImplementor);
        for (ClassInfo classInfo : repositoriesToImplement) {
            List<Type> generics = this.getGenericTypes(classInfo);
            String repositoryInterface = classInfo.name().toString();
            String entityType = generics.get(0).toString();
            String idType = generics.get(1).toString();
            String resourceClass = resourceImplementor.implement((ClassOutput)classOutput, repositoryInterface, entityType);
            restDataResourceProducer.produce((BuildItem)new RestDataResourceBuildItem(new ResourceMetadata(resourceClass, repositoryInterface, entityType, idType)));
            ResourceProperties resourceProperties = propertiesProvider.getResourceProperties(repositoryInterface);
            resourcePropertiesProducer.produce((BuildItem)new ResourcePropertiesBuildItem(resourceClass, resourceProperties));
            unremovableBeansProducer.produce((BuildItem)new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanTypeExclusion(DotName.createSimple((String)repositoryInterface))));
        }
    }

    private List<ClassInfo> getRepositoriesToImplement(IndexView indexView, DotName ... repositoryInterfaces) {
        LinkedList<ClassInfo> result = new LinkedList<ClassInfo>();
        for (DotName repositoryInterface : repositoryInterfaces) {
            for (ClassInfo classInfo : indexView.getKnownDirectImplementors(repositoryInterface)) {
                if (this.hasImplementors(indexView, classInfo) || EXCLUDED_INTERFACES.contains(classInfo.name())) continue;
                this.validateResource(classInfo);
                result.add(classInfo);
            }
        }
        return result;
    }

    private boolean hasImplementors(IndexView index, ClassInfo classInfo) {
        return !index.getKnownDirectImplementors(classInfo.name()).isEmpty();
    }

    private void validateResource(ClassInfo classInfo) {
        if (!Modifier.isInterface(classInfo.flags())) {
            throw new RuntimeException(classInfo.name() + " has to be an interface");
        }
    }

    private List<Type> getGenericTypes(ClassInfo classInfo) {
        return ((Type)classInfo.interfaceTypes().stream().findFirst().orElseThrow(() -> new RuntimeException(classInfo.toString() + " does not have generic types"))).asParameterizedType().arguments();
    }
}

