/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.data.rest.deployment;

import io.quarkus.deployment.bean.JavaBeanUtil;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.spring.data.rest.deployment.RepositoryMethodsImplementor;
import jakarta.persistence.Id;
import java.util.List;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class EntityClassHelper {
    private final IndexView index;

    public EntityClassHelper(IndexView index) {
        this.index = index;
    }

    public FieldInfo getIdField(String className) {
        return this.getIdField(this.index.getClassByName(DotName.createSimple((String)className)));
    }

    public FieldInfo getIdField(ClassInfo classInfo) {
        ClassInfo tmpClassInfo = classInfo;
        while (tmpClassInfo != null) {
            for (FieldInfo field : tmpClassInfo.fields()) {
                if (!field.hasAnnotation(DotName.createSimple((String)Id.class.getName()))) continue;
                return field;
            }
            if (tmpClassInfo.superName() != null) {
                tmpClassInfo = this.index.getClassByName(tmpClassInfo.superName());
                continue;
            }
            tmpClassInfo = null;
        }
        throw new IllegalArgumentException("Couldn't find id field of " + classInfo);
    }

    public MethodDescriptor getSetter(String className, FieldInfo field) {
        return this.getSetter(this.index.getClassByName(DotName.createSimple((String)className)), field);
    }

    public MethodDescriptor getSetter(ClassInfo entityClass, FieldInfo field) {
        MethodDescriptor setter = this.getMethod(entityClass, JavaBeanUtil.getSetterName((String)field.name()), field.type());
        if (setter != null) {
            return setter;
        }
        return MethodDescriptor.ofMethod((Object)entityClass.toString(), (String)("$$_hibernate_write_" + field.name()), Void.TYPE, (Object[])new Object[]{field.type().name().toString()});
    }

    public MethodDescriptor getMethod(ClassInfo entityClass, String name, Type ... parameters) {
        if (entityClass == null) {
            return null;
        }
        MethodInfo methodInfo = entityClass.method(name, parameters);
        if (methodInfo != null) {
            return MethodDescriptor.of((MethodInfo)methodInfo);
        }
        if (entityClass.superName() != null) {
            return this.getMethod(this.index.getClassByName(entityClass.superName()), name, parameters);
        }
        return null;
    }

    public boolean isRepositoryInstanceOf(DotName target, String repositoryName) {
        ClassInfo classByName = this.index.getClassByName(repositoryName);
        List types = classByName.interfaceTypes();
        return types.stream().anyMatch(type -> type.name().equals((Object)target));
    }

    public boolean isCrudRepository(String repositoryName) {
        return this.isRepositoryInstanceOf(RepositoryMethodsImplementor.CRUD_REPOSITORY_INTERFACE, repositoryName) || this.isRepositoryInstanceOf(RepositoryMethodsImplementor.LIST_CRUD_REPOSITORY_INTERFACE, repositoryName) || this.isRepositoryInstanceOf(RepositoryMethodsImplementor.JPA_REPOSITORY_INTERFACE, repositoryName);
    }

    public boolean isListCrudRepository(String repositoryName) {
        return this.isRepositoryInstanceOf(RepositoryMethodsImplementor.LIST_CRUD_REPOSITORY_INTERFACE, repositoryName) || this.isRepositoryInstanceOf(RepositoryMethodsImplementor.JPA_REPOSITORY_INTERFACE, repositoryName);
    }

    public boolean isPagingAndSortingRepository(String repositoryName) {
        return this.isRepositoryInstanceOf(RepositoryMethodsImplementor.PAGING_AND_SORTING_REPOSITORY_INTERFACE, repositoryName) || this.isRepositoryInstanceOf(RepositoryMethodsImplementor.LIST_PAGING_AND_SORTING_REPOSITORY_INTERFACE, repositoryName) || this.isRepositoryInstanceOf(RepositoryMethodsImplementor.JPA_REPOSITORY_INTERFACE, repositoryName);
    }

    public boolean isListPagingAndSortingRepository(String repositoryName) {
        return this.isRepositoryInstanceOf(RepositoryMethodsImplementor.LIST_PAGING_AND_SORTING_REPOSITORY_INTERFACE, repositoryName) || this.isRepositoryInstanceOf(RepositoryMethodsImplementor.JPA_REPOSITORY_INTERFACE, repositoryName);
    }

    public boolean containsPagedRepository(List<ClassInfo> repositories) {
        return repositories.stream().anyMatch(r -> this.isPagingAndSortingRepository(r.name().toString()));
    }
}

