/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.scheduled.deployment;

import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.scheduler.Scheduled;
import io.quarkus.scheduler.deployment.ScheduledBusinessMethodItem;
import io.quarkus.scheduler.runtime.SchedulerContext;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class SpringScheduledProcessor {
    static final DotName SPRING_SCHEDULED = DotName.createSimple((String)"org.springframework.scheduling.annotation.Scheduled");
    static final DotName SPRING_SCHEDULES = DotName.createSimple((String)"org.springframework.scheduling.annotation.Schedules");
    private static final DotName QUARKUS_SCHEDULED = DotName.createSimple((String)Scheduled.class.getName());
    private static final Logger LOGGER = Logger.getLogger(SpringScheduledProcessor.class);

    @BuildStep
    FeatureBuildItem registerFeature() {
        return new FeatureBuildItem(Feature.SPRING_SCHEDULED);
    }

    @BuildStep
    public List<UnremovableBeanBuildItem> unremovableBeans() {
        return Arrays.asList(new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(SPRING_SCHEDULED)), new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(SPRING_SCHEDULES)));
    }

    @BuildStep
    void collectScheduledMethods(BeanRegistrationPhaseBuildItem beanRegistrationPhase, BuildProducer<ScheduledBusinessMethodItem> scheduledBusinessMethods) {
        AnnotationStore annotationStore = (AnnotationStore)beanRegistrationPhase.getContext().get(BuildExtension.Key.ANNOTATION_STORE);
        for (BeanInfo bean : beanRegistrationPhase.getContext().beans().classBeans()) {
            ClassInfo classInfo = ((AnnotationTarget)bean.getTarget().get()).asClass();
            for (MethodInfo method : classInfo.methods()) {
                List<AnnotationInstance> schedules = null;
                AnnotationInstance scheduledAnnotation = annotationStore.getAnnotation((AnnotationTarget)method, SPRING_SCHEDULED);
                if (scheduledAnnotation != null) {
                    schedules = Collections.singletonList(scheduledAnnotation);
                } else {
                    AnnotationInstance schedulesAnnotation = annotationStore.getAnnotation((AnnotationTarget)method, SPRING_SCHEDULES);
                    if (schedulesAnnotation != null) {
                        schedules = new ArrayList<AnnotationInstance>();
                        for (AnnotationInstance scheduledInstance : schedulesAnnotation.value().asNestedArray()) {
                            schedules.add(AnnotationInstance.create((DotName)scheduledInstance.name(), (AnnotationTarget)schedulesAnnotation.target(), (List)scheduledInstance.values()));
                        }
                    }
                }
                this.processSpringScheduledAnnotation(scheduledBusinessMethods, bean, method, schedules);
            }
        }
    }

    void processSpringScheduledAnnotation(BuildProducer<ScheduledBusinessMethodItem> scheduledBusinessMethods, BeanInfo bean, MethodInfo method, List<AnnotationInstance> scheduledAnnotations) {
        ArrayList<AnnotationInstance> schedules = new ArrayList<AnnotationInstance>();
        if (scheduledAnnotations != null) {
            for (AnnotationInstance scheduledAnnotation : scheduledAnnotations) {
                List springAnnotationValues = scheduledAnnotation.values();
                ArrayList<AnnotationValue> confValues = new ArrayList<AnnotationValue>();
                if (!springAnnotationValues.isEmpty()) {
                    if (this.annotationsValuesContain(springAnnotationValues, "fixedRate") || this.annotationsValuesContain(springAnnotationValues, "fixedRateString")) {
                        confValues.add(this.buildEveryParam(springAnnotationValues));
                        if (this.annotationsValuesContain(springAnnotationValues, "initialDelay") || this.annotationsValuesContain(springAnnotationValues, "initialDelayString")) {
                            confValues.addAll(this.buildDelayParams(springAnnotationValues));
                        }
                    } else {
                        if (this.annotationsValuesContain(springAnnotationValues, "fixedDelay") || this.annotationsValuesContain(springAnnotationValues, "fixedDelayString")) {
                            throw new IllegalArgumentException("Invalid @Scheduled method '" + method.name() + "': 'fixedDelay' not supported");
                        }
                        if (this.annotationsValuesContain(springAnnotationValues, "cron")) {
                            if (this.annotationsValuesContain(springAnnotationValues, "initialDelay")) {
                                throw new IllegalArgumentException("Invalid @Scheduled method '" + method.name() + "': 'initialDelay' not supported for cron triggers");
                            }
                            confValues.add(this.buildCronParam(springAnnotationValues));
                        }
                    }
                }
                AnnotationInstance regularAnnotationInstance = AnnotationInstance.create((DotName)QUARKUS_SCHEDULED, (AnnotationTarget)scheduledAnnotation.target(), confValues);
                schedules.add(regularAnnotationInstance);
            }
            if (schedules != null) {
                scheduledBusinessMethods.produce((BuildItem)new ScheduledBusinessMethodItem(bean, method, schedules));
                LOGGER.debugf("Found scheduled business method %s declared on %s", (Object)method, (Object)bean);
            }
        }
    }

    AnnotationValue buildCronParam(List<AnnotationValue> springAnnotationValues) {
        String cronExpression = this.getAnnotationValueByName(springAnnotationValues, "cron").get().asString();
        cronExpression = cronExpression.replace("${", "{");
        return AnnotationValue.createStringValue((String)"cron", (String)cronExpression);
    }

    AnnotationValue buildEveryParam(List<AnnotationValue> springAnnotationValues) {
        long fixedRate = this.getLongValueFromParam(springAnnotationValues, "fixedRate");
        String fixedRateString = Duration.ofMillis(fixedRate).toString();
        AnnotationValue every = AnnotationValue.createStringValue((String)"every", (String)fixedRateString);
        return every;
    }

    List<AnnotationValue> buildDelayParams(List<AnnotationValue> springAnnotationValues) {
        ArrayList<AnnotationValue> confValues = new ArrayList<AnnotationValue>();
        long delay = this.getLongValueFromParam(springAnnotationValues, "initialDelay");
        confValues.add(AnnotationValue.createLongValue((String)"delay", (long)delay));
        confValues.add(AnnotationValue.createEnumValue((String)"delayUnit", (DotName)DotName.createSimple((String)"java.util.concurrent.TimeUnit"), (String)TimeUnit.MILLISECONDS.name()));
        return confValues;
    }

    private long getLongValueFromParam(List<AnnotationValue> springAnnotationValues, String paramName) {
        long paramValue = 0L;
        String paramValueString = "";
        if (this.annotationsValuesContain(springAnnotationValues, paramName)) {
            paramValue = this.getAnnotationValueByName(springAnnotationValues, paramName).get().asLong();
        } else {
            paramValueString = this.getAnnotationValueByName(springAnnotationValues, paramName + "String").get().asString();
            paramValue = this.valueOf(paramName, paramValueString);
        }
        return paramValue;
    }

    private long valueOf(String paramName, String paramValueString) {
        long paramValue;
        if (paramValueString.startsWith("${")) {
            paramValueString = paramValueString.replace("${", "{").trim();
            paramValueString = (String)ConfigProviderResolver.instance().getConfig().getValue(SchedulerContext.getConfigProperty((String)paramValueString), String.class);
        }
        try {
            paramValue = Long.valueOf(paramValueString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid '" + paramName + "String' value \"" + paramValueString + "\" - cannot parse into long");
        }
        return paramValue;
    }

    private boolean annotationsValuesContain(List<AnnotationValue> springAnnotationValues, String valueName) {
        return springAnnotationValues.stream().filter(spv -> spv.name().equals(valueName)).findAny().isPresent();
    }

    private Optional<AnnotationValue> getAnnotationValueByName(List<AnnotationValue> springAnnotationValues, String valueName) {
        return springAnnotationValues.stream().filter(spv -> spv.name().equals(valueName)).findAny();
    }
}

