/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.security.runtime.interceptor.check;

import io.quarkus.arc.Arc;
import io.quarkus.security.ForbiddenException;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.interceptor.check.SecurityCheck;
import io.quarkus.spring.security.runtime.interceptor.accessor.StringPropertyAccessor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class PrincipalNameFromParameterObjectSecurityCheck
implements SecurityCheck {
    private final int index;
    private final Class<?> expectedParameterClass;
    private final Class<? extends StringPropertyAccessor> stringPropertyAccessorClass;
    private final String propertyName;

    private PrincipalNameFromParameterObjectSecurityCheck(int index, String expectedParameterClass, String stringPropertyAccessorClass, String propertyName) throws ClassNotFoundException {
        this.index = index;
        this.expectedParameterClass = Class.forName(expectedParameterClass, false, Thread.currentThread().getContextClassLoader());
        this.stringPropertyAccessorClass = Class.forName(stringPropertyAccessorClass, false, Thread.currentThread().getContextClassLoader());
        this.propertyName = propertyName;
    }

    public static PrincipalNameFromParameterObjectSecurityCheck of(int index, String expectedParameterClass, String stringPropertyAccessorClass, String propertyName) {
        try {
            return new PrincipalNameFromParameterObjectSecurityCheck(index, expectedParameterClass, stringPropertyAccessorClass, propertyName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void apply(SecurityIdentity identity, Method method, Object[] parameters) {
        if (this.index > parameters.length - 1) {
            throw this.genericNotApplicableException(method);
        }
        Object parameterValue = parameters[this.index];
        if (!this.expectedParameterClass.equals(parameterValue.getClass())) {
            throw this.genericNotApplicableException(method);
        }
        String parameterValueStr = this.getStringValue(parameterValue);
        if (identity.isAnonymous()) {
            throw new UnauthorizedException();
        }
        String name = identity.getPrincipal().getName();
        if (!name.equals(parameterValueStr)) {
            throw new ForbiddenException();
        }
    }

    private String getStringValue(Object parameterValue) {
        return ((StringPropertyAccessor)Arc.container().instance(this.stringPropertyAccessorClass, new Annotation[0]).get()).access(parameterValue, this.propertyName);
    }

    private IllegalStateException genericNotApplicableException(Method method) {
        return new IllegalStateException("PrincipalNameFromParameterObjectSecurityCheck with index " + this.index + " cannot be applied to " + method);
    }
}

