/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.security.runtime.interceptor.check;

import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.SecurityCheck;
import java.lang.reflect.Method;
import java.util.List;

public class AnyDelegatingSecurityCheck
implements SecurityCheck {
    private final List<SecurityCheck> securityChecks;

    public AnyDelegatingSecurityCheck(List<SecurityCheck> securityChecks) {
        this.securityChecks = securityChecks;
    }

    public void apply(SecurityIdentity identity, Method method, Object[] parameters) {
        SecurityException thrownException = null;
        for (int i = 0; i < this.securityChecks.size(); ++i) {
            try {
                this.securityChecks.get(i).apply(identity, method, parameters);
                return;
            }
            catch (SecurityException e) {
                thrownException = e;
                continue;
            }
        }
        if (thrownException != null) {
            throw thrownException;
        }
    }
}

