/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.security.runtime.interceptor.check;

import io.quarkus.arc.Arc;
import io.quarkus.security.ForbiddenException;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.MethodDescription;
import io.quarkus.security.spi.runtime.SecurityCheck;
import io.quarkus.spring.security.runtime.interceptor.accessor.StringPropertyAccessor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class PrincipalNameFromParameterObjectSecurityCheck
implements SecurityCheck {
    private final int index;
    private final Class<?> expectedParameterClass;
    private final Class<? extends StringPropertyAccessor> stringPropertyAccessorClass;
    private final String propertyName;
    private final CheckType checkType;

    private PrincipalNameFromParameterObjectSecurityCheck(int index, String expectedParameterClass, String stringPropertyAccessorClass, String propertyName, CheckType checkType) throws ClassNotFoundException {
        this.index = index;
        this.expectedParameterClass = Class.forName(expectedParameterClass, false, Thread.currentThread().getContextClassLoader());
        this.stringPropertyAccessorClass = Class.forName(stringPropertyAccessorClass, false, Thread.currentThread().getContextClassLoader());
        this.propertyName = propertyName;
        this.checkType = checkType;
    }

    public static PrincipalNameFromParameterObjectSecurityCheck of(int index, String expectedParameterClass, String stringPropertyAccessorClass, String propertyName, CheckType checkType) {
        try {
            return new PrincipalNameFromParameterObjectSecurityCheck(index, expectedParameterClass, stringPropertyAccessorClass, propertyName, checkType);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void apply(SecurityIdentity identity, Method method, Object[] parameters) {
        this.doApply(identity, parameters, method.getDeclaringClass().getName(), method.getName());
    }

    public void apply(SecurityIdentity identity, MethodDescription methodDescription, Object[] parameters) {
        this.doApply(identity, parameters, methodDescription.getClassName(), methodDescription.getMethodName());
    }

    private void doApply(SecurityIdentity identity, Object[] parameters, String className, String methodName) {
        if (this.index > parameters.length - 1) {
            throw this.genericNotApplicableException(className, methodName);
        }
        Object parameterValue = parameters[this.index];
        if (!this.expectedParameterClass.equals(parameterValue.getClass())) {
            throw this.genericNotApplicableException(className, methodName);
        }
        String parameterValueStr = this.getStringValue(parameterValue);
        if (identity.isAnonymous()) {
            throw new UnauthorizedException();
        }
        String name = identity.getPrincipal().getName();
        if (this.checkType == CheckType.EQ ? !name.equals(parameterValueStr) : this.checkType == CheckType.NEQ && name.equals(parameterValueStr)) {
            throw new ForbiddenException();
        }
    }

    private String getStringValue(Object parameterValue) {
        return ((StringPropertyAccessor)Arc.container().instance(this.stringPropertyAccessorClass, new Annotation[0]).get()).access(parameterValue, this.propertyName);
    }

    private IllegalStateException genericNotApplicableException(String className, String methodName) {
        return new IllegalStateException("PrincipalNameFromParameterObjectSecurityCheck with index " + this.index + " cannot be applied to '" + className + "#" + methodName + "'");
    }

    public static enum CheckType {
        EQ,
        NEQ;

    }
}

