/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.web.deployment;

import org.jboss.jandex.DotName;

public class TypesUtil {
    private final ClassLoader classLoader;

    public TypesUtil(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean isAssignable(Class<?> clazz, DotName dotName) {
        return clazz.isAssignableFrom(this.load(dotName.toString()));
    }

    private Class<?> load(String className) {
        switch (className) {
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        try {
            return Class.forName(className, false, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }
}

