/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.web.deployment;

import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyIgnoreWarningBuildItem;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.resteasy.common.deployment.ResteasyCommonProcessor;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import io.quarkus.resteasy.runtime.ExceptionMapperRecorder;
import io.quarkus.resteasy.runtime.NonJaxRsClassMappings;
import io.quarkus.resteasy.server.common.deployment.ResteasyDeploymentCustomizerBuildItem;
import io.quarkus.resteasy.server.common.spi.AdditionalJaxRsResourceDefiningAnnotationBuildItem;
import io.quarkus.resteasy.server.common.spi.AdditionalJaxRsResourceMethodAnnotationsBuildItem;
import io.quarkus.resteasy.server.common.spi.AdditionalJaxRsResourceMethodParamAnnotations;
import io.quarkus.spring.web.deployment.ControllerAdviceAbstractExceptionMapperGenerator;
import io.quarkus.spring.web.deployment.ResponseStatusOnExceptionGenerator;
import io.quarkus.spring.web.deployment.TypesUtil;
import io.quarkus.spring.web.runtime.ResponseStatusExceptionMapper;
import io.quarkus.undertow.deployment.BlacklistedServletContainerInitializerBuildItem;
import io.quarkus.undertow.deployment.ServletInitParamBuildItem;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Providers;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.resteasy.core.MediaTypeMap;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.spi.metadata.SpringResourceBuilder;
import org.jboss.resteasy.spring.web.ResponseEntityFeature;
import org.jboss.resteasy.spring.web.ResponseStatusFeature;

public class SpringWebProcessor {
    private static final DotName REST_CONTROLLER_ANNOTATION = DotName.createSimple((String)"org.springframework.web.bind.annotation.RestController");
    private static final DotName REQUEST_MAPPING = DotName.createSimple((String)"org.springframework.web.bind.annotation.RequestMapping");
    private static final DotName PATH_VARIABLE = DotName.createSimple((String)"org.springframework.web.bind.annotation.PathVariable");
    private static final List<DotName> MAPPING_ANNOTATIONS = Arrays.asList(REQUEST_MAPPING, DotName.createSimple((String)"org.springframework.web.bind.annotation.GetMapping"), DotName.createSimple((String)"org.springframework.web.bind.annotation.PostMapping"), DotName.createSimple((String)"org.springframework.web.bind.annotation.PutMapping"), DotName.createSimple((String)"org.springframework.web.bind.annotation.DeleteMapping"), DotName.createSimple((String)"org.springframework.web.bind.annotation.PatchMapping"));
    private static final DotName RESPONSE_STATUS = DotName.createSimple((String)"org.springframework.web.bind.annotation.ResponseStatus");
    private static final DotName EXCEPTION_HANDLER = DotName.createSimple((String)"org.springframework.web.bind.annotation.ExceptionHandler");
    private static final DotName REST_CONTROLLER_ADVICE = DotName.createSimple((String)"org.springframework.web.bind.annotation.RestControllerAdvice");
    private static final DotName MODEL_AND_VIEW = DotName.createSimple((String)"org.springframework.web.servlet.ModelAndView");
    private static final DotName VIEW = DotName.createSimple((String)"org.springframework.web.servlet.View");
    private static final DotName MODEL = DotName.createSimple((String)"org.springframework.ui.Model");
    private static final DotName HTTP_ENTITY = DotName.createSimple((String)"org.springframework.http.HttpEntity");
    private static final DotName RESPONSE_ENTITY = DotName.createSimple((String)"org.springframework.http.ResponseEntity");
    private static final Set<DotName> DISALLOWED_EXCEPTION_CONTROLLER_RETURN_TYPES = new HashSet<DotName>(Arrays.asList(MODEL_AND_VIEW, VIEW, MODEL, HTTP_ENTITY));

    @BuildStep
    FeatureBuildItem registerFeature() {
        return new FeatureBuildItem("spring-web");
    }

    @BuildStep
    public BlacklistedServletContainerInitializerBuildItem blacklistSpringServlet() {
        return new BlacklistedServletContainerInitializerBuildItem("org.springframework.web.SpringServletContainerInitializer");
    }

    @BuildStep
    public AdditionalJaxRsResourceDefiningAnnotationBuildItem additionalJaxRsResourceDefiningAnnotation() {
        return new AdditionalJaxRsResourceDefiningAnnotationBuildItem(REST_CONTROLLER_ANNOTATION);
    }

    @BuildStep
    public AdditionalJaxRsResourceMethodAnnotationsBuildItem additionalJaxRsResourceMethodAnnotationsBuildItem() {
        return new AdditionalJaxRsResourceMethodAnnotationsBuildItem(MAPPING_ANNOTATIONS);
    }

    @BuildStep
    public AdditionalJaxRsResourceMethodParamAnnotations additionalJaxRsResourceMethodParamAnnotations() {
        return new AdditionalJaxRsResourceMethodParamAnnotations(Arrays.asList(DotName.createSimple((String)"org.springframework.web.bind.annotation.RequestParam"), PATH_VARIABLE, DotName.createSimple((String)"org.springframework.web.bind.annotation.RequestBody"), DotName.createSimple((String)"org.springframework.web.bind.annotation.MatrixVariable"), DotName.createSimple((String)"org.springframework.web.bind.annotation.RequestHeader"), DotName.createSimple((String)"org.springframework.web.bind.annotation.CookieValue")));
    }

    @BuildStep
    public void ignoreReflectionHierarchy(BuildProducer<ReflectiveHierarchyIgnoreWarningBuildItem> ignore) {
        ignore.produce((BuildItem)new ReflectiveHierarchyIgnoreWarningBuildItem((Predicate)new ReflectiveHierarchyIgnoreWarningBuildItem.DotNameExclusion(RESPONSE_ENTITY)));
        ignore.produce((BuildItem)new ReflectiveHierarchyIgnoreWarningBuildItem((Predicate)new ReflectiveHierarchyIgnoreWarningBuildItem.DotNameExclusion(DotName.createSimple((String)"org.springframework.util.MimeType"))));
        ignore.produce((BuildItem)new ReflectiveHierarchyIgnoreWarningBuildItem((Predicate)new ReflectiveHierarchyIgnoreWarningBuildItem.DotNameExclusion(DotName.createSimple((String)"org.springframework.util.MultiValueMap"))));
    }

    @BuildStep
    public void beanDefiningAnnotations(BuildProducer<BeanDefiningAnnotationBuildItem> beanDefiningAnnotations) {
        beanDefiningAnnotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(REST_CONTROLLER_ANNOTATION, BuiltinScope.SINGLETON.getName()));
        beanDefiningAnnotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(REST_CONTROLLER_ADVICE, BuiltinScope.SINGLETON.getName()));
    }

    @BuildStep
    public void process(BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ServletInitParamBuildItem> initParamProducer, BuildProducer<ResteasyDeploymentCustomizerBuildItem> deploymentCustomizerProducer) {
        IndexView index = beanArchiveIndexBuildItem.getIndex();
        Collection annotations = index.getAnnotations(REST_CONTROLLER_ANNOTATION);
        if (annotations.isEmpty()) {
            return;
        }
        final HashSet<String> classNames = new HashSet<String>();
        for (AnnotationInstance annotation : annotations) {
            classNames.add(annotation.target().asClass().toString());
        }
        initParamProducer.produce((BuildItem)new ServletInitParamBuildItem("resteasy.scanned.resource.classes.with.builder", SpringResourceBuilder.class.getName() + ":" + String.join((CharSequence)",", classNames)));
        deploymentCustomizerProducer.produce((BuildItem)new ResteasyDeploymentCustomizerBuildItem((Consumer)new Consumer<ResteasyDeployment>(){

            @Override
            public void accept(ResteasyDeployment resteasyDeployment) {
                resteasyDeployment.getScannedResourceClassesWithBuilder().put(SpringResourceBuilder.class.getName(), new ArrayList(classNames));
            }
        }));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{SpringResourceBuilder.class.getName()}));
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    public void registerWithDevModeNotFoundMapper(BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, ExceptionMapperRecorder recorder) {
        IndexView index = beanArchiveIndexBuildItem.getIndex();
        Collection restControllerAnnotations = index.getAnnotations(REST_CONTROLLER_ANNOTATION);
        if (restControllerAnnotations.isEmpty()) {
            return;
        }
        HashMap<String, NonJaxRsClassMappings> nonJaxRsPaths = new HashMap<String, NonJaxRsClassMappings>();
        for (AnnotationInstance restControllerInstance : restControllerAnnotations) {
            String basePathFromAnnotation;
            String basePath = "/";
            ClassInfo restControllerAnnotatedClass = restControllerInstance.target().asClass();
            AnnotationInstance requestMappingInstance = restControllerAnnotatedClass.classAnnotation(REQUEST_MAPPING);
            if (requestMappingInstance != null && (basePathFromAnnotation = this.getMappingValue(requestMappingInstance)) != null) {
                basePath = basePathFromAnnotation;
            }
            HashMap<String, String> methodNameToPath = new HashMap<String, String>();
            NonJaxRsClassMappings nonJaxRsClassMappings = new NonJaxRsClassMappings();
            nonJaxRsClassMappings.setMethodNameToPath(methodNameToPath);
            nonJaxRsClassMappings.setBasePath(basePath);
            List methods = restControllerAnnotatedClass.methods();
            block1: for (MethodInfo method : methods) {
                String methodName = method.name();
                for (DotName mappingClass : MAPPING_ANNOTATIONS) {
                    AnnotationInstance mappingClassAnnotation = method.annotation(mappingClass);
                    if (mappingClassAnnotation == null) continue;
                    String methodPath = this.getMappingValue(mappingClassAnnotation);
                    if (methodPath == null) {
                        methodPath = "";
                    } else if (!methodPath.startsWith("/")) {
                        methodPath = "/" + methodPath;
                    }
                    methodNameToPath.put(methodName, methodPath);
                    continue block1;
                }
            }
            if (methodNameToPath.isEmpty()) continue;
            nonJaxRsPaths.put(restControllerAnnotatedClass.name().toString(), nonJaxRsClassMappings);
        }
        if (!nonJaxRsPaths.isEmpty()) {
            recorder.nonJaxRsClassNameToMethodPaths(nonJaxRsPaths);
        }
    }

    private String getMappingValue(AnnotationInstance instance) {
        if (instance == null) {
            return null;
        }
        if (instance.value() != null) {
            return instance.value().asStringArray()[0];
        }
        if (instance.value("path") != null) {
            return instance.value("path").asStringArray()[0];
        }
        return null;
    }

    @BuildStep
    public void registerProviders(BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, BuildProducer<ResteasyJaxrsProviderBuildItem> providersProducer) throws IOException {
        Set availableProviders = ServiceUtil.classNamesNamedIn((ClassLoader)this.getClass().getClassLoader(), (String)("META-INF/services/" + Providers.class.getName()));
        MediaTypeMap categorizedReaders = new MediaTypeMap();
        MediaTypeMap categorizedWriters = new MediaTypeMap();
        MediaTypeMap categorizedContextResolvers = new MediaTypeMap();
        HashSet otherProviders = new HashSet();
        ResteasyCommonProcessor.categorizeProviders((Set)availableProviders, (MediaTypeMap)categorizedReaders, (MediaTypeMap)categorizedWriters, (MediaTypeMap)categorizedContextResolvers, otherProviders);
        boolean useAllAvailable = false;
        Set<String> providersToRegister = new HashSet();
        block0: for (DotName mappingClass : MAPPING_ANNOTATIONS) {
            Collection instances = beanArchiveIndexBuildItem.getIndex().getAnnotations(mappingClass);
            for (AnnotationInstance instance : instances) {
                if (this.collectProviders(providersToRegister, (MediaTypeMap<String>)categorizedWriters, instance, "produces")) {
                    useAllAvailable = true;
                    break block0;
                }
                if (this.collectProviders(providersToRegister, (MediaTypeMap<String>)categorizedContextResolvers, instance, "produces")) {
                    useAllAvailable = true;
                    break block0;
                }
                if (!this.collectProviders(providersToRegister, (MediaTypeMap<String>)categorizedReaders, instance, "consumes")) continue;
                useAllAvailable = true;
                break block0;
            }
        }
        if (useAllAvailable) {
            providersToRegister = availableProviders;
        } else {
            providersToRegister.addAll(categorizedWriters.getPossible(MediaType.APPLICATION_JSON_TYPE));
            providersToRegister.add(ResponseEntityFeature.class.getName());
            providersToRegister.add(ResponseStatusFeature.class.getName());
        }
        for (String provider : providersToRegister) {
            providersProducer.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(provider));
        }
    }

    private boolean collectProviders(Set<String> providersToRegister, MediaTypeMap<String> categorizedProviders, AnnotationInstance instance, String annotationValueName) {
        AnnotationValue producesValue = instance.value(annotationValueName);
        if (producesValue != null) {
            for (String value : producesValue.asStringArray()) {
                MediaType mediaType = MediaType.valueOf((String)value);
                if (MediaType.WILDCARD_TYPE.equals((Object)mediaType)) {
                    return true;
                }
                providersToRegister.addAll(categorizedProviders.getPossible(mediaType));
            }
        }
        return false;
    }

    @BuildStep
    public void generateExceptionMapperProviders(BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, BuildProducer<GeneratedClassBuildItem> generatedExceptionMappers, BuildProducer<ResteasyJaxrsProviderBuildItem> providersProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer) {
        TypesUtil typesUtil = new TypesUtil(Thread.currentThread().getContextClassLoader());
        IndexView index = beanArchiveIndexBuildItem.getIndex();
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedExceptionMappers, true);
        this.generateMappersForResponseStatusOnException(providersProducer, index, (ClassOutput)classOutput, typesUtil);
        this.generateMappersForExceptionHandlerInControllerAdvice(providersProducer, reflectiveClassProducer, index, (ClassOutput)classOutput, typesUtil);
    }

    @BuildStep
    public void registerStandardExceptionMappers(BuildProducer<ResteasyJaxrsProviderBuildItem> providersProducer) {
        providersProducer.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(ResponseStatusExceptionMapper.class.getName()));
    }

    private void generateMappersForResponseStatusOnException(BuildProducer<ResteasyJaxrsProviderBuildItem> providersProducer, IndexView index, ClassOutput classOutput, TypesUtil typesUtil) {
        Collection responseStatusInstances = index.getAnnotations(RESPONSE_STATUS);
        if (responseStatusInstances.isEmpty()) {
            return;
        }
        for (AnnotationInstance instance : responseStatusInstances) {
            if (AnnotationTarget.Kind.CLASS != instance.target().kind() || !typesUtil.isAssignable(Exception.class, instance.target().asClass().name())) continue;
            String name = new ResponseStatusOnExceptionGenerator(instance.target().asClass(), classOutput).generate();
            providersProducer.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(name));
        }
    }

    private void generateMappersForExceptionHandlerInControllerAdvice(BuildProducer<ResteasyJaxrsProviderBuildItem> providersProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, IndexView index, ClassOutput classOutput, TypesUtil typesUtil) {
        AnnotationInstance controllerAdviceInstance = this.getSingleControllerAdviceInstance(index);
        if (controllerAdviceInstance == null) {
            return;
        }
        ClassInfo controllerAdvice = controllerAdviceInstance.target().asClass();
        List methods = controllerAdvice.methods();
        for (MethodInfo method : methods) {
            Type[] handledExceptionTypes;
            AnnotationInstance exceptionHandlerInstance = method.annotation(EXCEPTION_HANDLER);
            if (exceptionHandlerInstance == null) continue;
            if (!Modifier.isPublic(method.flags()) || Modifier.isStatic(method.flags())) {
                throw new IllegalStateException("@ExceptionHandler methods in @ControllerAdvice must be public instance methods");
            }
            DotName returnTypeDotName = method.returnType().name();
            if (DISALLOWED_EXCEPTION_CONTROLLER_RETURN_TYPES.contains(returnTypeDotName)) {
                throw new IllegalStateException("@ExceptionHandler methods in @ControllerAdvice classes can only have void, ResponseEntity or POJO return types");
            }
            if (!RESPONSE_ENTITY.equals((Object)returnTypeDotName)) {
                reflectiveClassProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{returnTypeDotName.toString()}));
            }
            for (Type handledExceptionType : handledExceptionTypes = exceptionHandlerInstance.value().asClassArray()) {
                String name = new ControllerAdviceAbstractExceptionMapperGenerator(method, handledExceptionType.name(), classOutput, typesUtil).generate();
                providersProducer.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(name));
            }
        }
    }

    private AnnotationInstance getSingleControllerAdviceInstance(IndexView index) {
        Collection controllerAdviceInstances = index.getAnnotations(REST_CONTROLLER_ADVICE);
        if (controllerAdviceInstances.isEmpty()) {
            return null;
        }
        if (controllerAdviceInstances.size() > 1) {
            throw new IllegalStateException("You can only have a single class annotated with @ControllerAdvice");
        }
        return (AnnotationInstance)controllerAdviceInstances.iterator().next();
    }
}

