/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.web.deployment;

import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyIgnoreWarningBuildItem;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.jaxrs.spi.deployment.AdditionalJaxRsResourceMethodAnnotationsBuildItem;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import io.quarkus.resteasy.reactive.spi.ExceptionMapperBuildItem;
import io.quarkus.spring.web.deployment.ControllerAdviceExceptionMapperGenerator;
import io.quarkus.spring.web.deployment.ResponseStatusOnExceptionGenerator;
import io.quarkus.spring.web.deployment.TypesUtil;
import jakarta.ws.rs.core.HttpHeaders;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class SpringWebProcessor {
    private static final DotName REST_CONTROLLER_ANNOTATION = DotName.createSimple((String)"org.springframework.web.bind.annotation.RestController");
    private static final DotName REQUEST_MAPPING = DotName.createSimple((String)"org.springframework.web.bind.annotation.RequestMapping");
    private static final DotName PATH_VARIABLE = DotName.createSimple((String)"org.springframework.web.bind.annotation.PathVariable");
    private static final List<DotName> MAPPING_ANNOTATIONS = Arrays.asList(REQUEST_MAPPING, DotName.createSimple((String)"org.springframework.web.bind.annotation.GetMapping"), DotName.createSimple((String)"org.springframework.web.bind.annotation.PostMapping"), DotName.createSimple((String)"org.springframework.web.bind.annotation.PutMapping"), DotName.createSimple((String)"org.springframework.web.bind.annotation.DeleteMapping"), DotName.createSimple((String)"org.springframework.web.bind.annotation.PatchMapping"));
    private static final DotName RESPONSE_STATUS = DotName.createSimple((String)"org.springframework.web.bind.annotation.ResponseStatus");
    private static final DotName EXCEPTION_HANDLER = DotName.createSimple((String)"org.springframework.web.bind.annotation.ExceptionHandler");
    private static final DotName REST_CONTROLLER_ADVICE = DotName.createSimple((String)"org.springframework.web.bind.annotation.RestControllerAdvice");
    private static final DotName MODEL_AND_VIEW = DotName.createSimple((String)"org.springframework.web.servlet.ModelAndView");
    private static final DotName VIEW = DotName.createSimple((String)"org.springframework.web.servlet.View");
    private static final DotName MODEL = DotName.createSimple((String)"org.springframework.ui.Model");
    private static final DotName HTTP_ENTITY = DotName.createSimple((String)"org.springframework.http.HttpEntity");
    private static final DotName RESPONSE_ENTITY = DotName.createSimple((String)"org.springframework.http.ResponseEntity");
    private static final Set<DotName> DISALLOWED_EXCEPTION_CONTROLLER_RETURN_TYPES = new HashSet<DotName>(Arrays.asList(MODEL_AND_VIEW, VIEW, MODEL, HTTP_ENTITY));

    @BuildStep
    FeatureBuildItem registerFeature() {
        return new FeatureBuildItem(Feature.SPRING_WEB);
    }

    @BuildStep
    public AdditionalJaxRsResourceMethodAnnotationsBuildItem additionalJaxRsResourceMethodAnnotationsBuildItem() {
        return new AdditionalJaxRsResourceMethodAnnotationsBuildItem(MAPPING_ANNOTATIONS);
    }

    @BuildStep
    public void ignoreReflectionHierarchy(BuildProducer<ReflectiveHierarchyIgnoreWarningBuildItem> ignore) {
        ignore.produce((BuildItem)new ReflectiveHierarchyIgnoreWarningBuildItem((Predicate)new ReflectiveHierarchyIgnoreWarningBuildItem.DotNameExclusion(RESPONSE_ENTITY)));
        ignore.produce((BuildItem)new ReflectiveHierarchyIgnoreWarningBuildItem((Predicate)new ReflectiveHierarchyIgnoreWarningBuildItem.DotNameExclusion(DotName.createSimple((String)"org.springframework.util.MimeType"))));
        ignore.produce((BuildItem)new ReflectiveHierarchyIgnoreWarningBuildItem((Predicate)new ReflectiveHierarchyIgnoreWarningBuildItem.DotNameExclusion(DotName.createSimple((String)"org.springframework.util.MultiValueMap"))));
    }

    @BuildStep
    public void beanDefiningAnnotations(BuildProducer<BeanDefiningAnnotationBuildItem> beanDefiningAnnotations) {
        beanDefiningAnnotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(REST_CONTROLLER_ANNOTATION, BuiltinScope.SINGLETON.getName()));
        beanDefiningAnnotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(REST_CONTROLLER_ADVICE, BuiltinScope.SINGLETON.getName()));
    }

    @BuildStep
    public void exceptionHandlingSupport(CombinedIndexBuildItem index, BuildProducer<GeneratedClassBuildItem> generatedExceptionMappers, BuildProducer<ResteasyJaxrsProviderBuildItem> providersProducer, BuildProducer<ExceptionMapperBuildItem> exceptionMapperProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, BuildProducer<UnremovableBeanBuildItem> unremovableBeanProducer, Capabilities capabilities) {
        boolean isResteasyClassicAvailable = capabilities.isPresent("io.quarkus.resteasy.json.jackson");
        boolean isResteasyReactiveAvailable = capabilities.isPresent("io.quarkus.resteasy.reactive.json.jackson");
        if (!isResteasyClassicAvailable && !isResteasyReactiveAvailable) {
            throw new IllegalStateException("Spring Web can only work if 'quarkus-resteasy-jackson' or 'quarkus-rest-jackson' is present");
        }
        TypesUtil typesUtil = new TypesUtil(Thread.currentThread().getContextClassLoader());
        IndexView indexView = index.getIndex();
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedExceptionMappers, true);
        this.generateMappersForResponseStatusOnException(providersProducer, exceptionMapperProducer, indexView, (ClassOutput)classOutput, typesUtil, isResteasyClassicAvailable);
        this.generateMappersForExceptionHandlerInControllerAdvice(providersProducer, exceptionMapperProducer, reflectiveClassProducer, unremovableBeanProducer, indexView, (ClassOutput)classOutput, typesUtil, isResteasyClassicAvailable);
    }

    private void generateMappersForResponseStatusOnException(BuildProducer<ResteasyJaxrsProviderBuildItem> providersProducer, BuildProducer<ExceptionMapperBuildItem> exceptionMapperProducer, IndexView index, ClassOutput classOutput, TypesUtil typesUtil, boolean isResteasyClassic) {
        Collection responseStatusInstances = index.getAnnotations(RESPONSE_STATUS);
        if (responseStatusInstances.isEmpty()) {
            return;
        }
        for (AnnotationInstance instance : responseStatusInstances) {
            DotName dotName;
            if (AnnotationTarget.Kind.CLASS != instance.target().kind() || !typesUtil.isAssignable(Exception.class, dotName = instance.target().asClass().name())) continue;
            String name = new ResponseStatusOnExceptionGenerator(instance.target().asClass(), classOutput, isResteasyClassic).generate();
            providersProducer.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(name));
            exceptionMapperProducer.produce((BuildItem)new ExceptionMapperBuildItem(name, dotName.toString(), Integer.valueOf(5000), false));
        }
    }

    private void generateMappersForExceptionHandlerInControllerAdvice(BuildProducer<ResteasyJaxrsProviderBuildItem> providersProducer, BuildProducer<ExceptionMapperBuildItem> exceptionMapperProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, BuildProducer<UnremovableBeanBuildItem> unremovableBeanProducer, IndexView index, ClassOutput classOutput, TypesUtil typesUtil, boolean isResteasyClassic) {
        AnnotationInstance controllerAdviceInstance = this.getSingleControllerAdviceInstance(index);
        if (controllerAdviceInstance == null) {
            return;
        }
        ClassInfo controllerAdvice = controllerAdviceInstance.target().asClass();
        List methods = controllerAdvice.methods();
        for (MethodInfo method : methods) {
            Type[] handledExceptionTypes;
            AnnotationInstance exceptionHandlerInstance = method.annotation(EXCEPTION_HANDLER);
            if (exceptionHandlerInstance == null) continue;
            if (!Modifier.isPublic(method.flags()) || Modifier.isStatic(method.flags())) {
                throw new IllegalStateException("@ExceptionHandler methods in @ControllerAdvice must be public instance methods");
            }
            DotName returnTypeDotName = method.returnType().name();
            if (DISALLOWED_EXCEPTION_CONTROLLER_RETURN_TYPES.contains(returnTypeDotName)) {
                throw new IllegalStateException("@ExceptionHandler methods in @ControllerAdvice classes can only have void, ResponseEntity or POJO return types");
            }
            if (!RESPONSE_ENTITY.equals((Object)returnTypeDotName)) {
                reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{returnTypeDotName.toString()}).methods().fields().build());
            }
            for (Type handledExceptionType : handledExceptionTypes = exceptionHandlerInstance.value().asClassArray()) {
                String name = new ControllerAdviceExceptionMapperGenerator(method, handledExceptionType.name(), classOutput, typesUtil, isResteasyClassic).generate();
                providersProducer.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(name));
                exceptionMapperProducer.produce((BuildItem)new ExceptionMapperBuildItem(name, handledExceptionType.name().toString(), Integer.valueOf(5000), false));
            }
        }
        if (!isResteasyClassic) {
            unremovableBeanProducer.produce((BuildItem)UnremovableBeanBuildItem.beanClassNames((String[])new String[]{"org.jboss.resteasy.reactive.server.injection.ContextProducers", HttpHeaders.class.getName()}));
        }
    }

    private AnnotationInstance getSingleControllerAdviceInstance(IndexView index) {
        Collection controllerAdviceInstances = index.getAnnotations(REST_CONTROLLER_ADVICE);
        if (controllerAdviceInstances.isEmpty()) {
            return null;
        }
        if (controllerAdviceInstances.size() > 1) {
            throw new IllegalStateException("You can only have a single class annotated with @ControllerAdvice");
        }
        return (AnnotationInstance)controllerAdviceInstances.iterator().next();
    }
}

