/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.swaggerui.deployment;

import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.configuration.ConfigurationError;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.smallrye.openapi.common.deployment.SmallRyeOpenApiConfig;
import io.quarkus.swaggerui.runtime.SwaggerUiRecorder;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.vertx.core.Handler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.jboss.logging.Logger;

public class SwaggerUiProcessor {
    private static final Logger log = Logger.getLogger((String)SwaggerUiProcessor.class.getName());
    private static final String SWAGGER_UI_WEBJAR_GROUP_ID = "org.webjars";
    private static final String SWAGGER_UI_WEBJAR_ARTIFACT_ID = "swagger-ui";
    private static final String SWAGGER_UI_WEBJAR_PREFIX = "META-INF/resources/webjars/swagger-ui";
    private static final String SWAGGER_UI_FINAL_DESTINATION = "META-INF/swagger-ui-files";
    private static final Pattern SWAGGER_UI_DEFAULT_API_URL_PATTERN = Pattern.compile("(.* url: \")(.*)(\",.*)", 32);
    private static final String TEMP_DIR_PREFIX = "quarkus-swagger-ui_" + System.nanoTime();
    SwaggerUiConfig swaggerUiConfig;
    SmallRyeOpenApiConfig openapi;
    @Inject
    private LaunchModeBuildItem launch;

    @BuildStep
    void feature(BuildProducer<FeatureBuildItem> feature) {
        if (this.swaggerUiConfig.enable && (this.launch.getLaunchMode().isDevOrTest() || this.swaggerUiConfig.alwaysInclude)) {
            feature.produce((BuildItem)new FeatureBuildItem(Feature.SWAGGER_UI));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void registerSwaggerUiServletExtension(SwaggerUiRecorder recorder, BuildProducer<RouteBuildItem> routes, BeanContainerBuildItem container, BuildProducer<GeneratedResourceBuildItem> generatedResources, BuildProducer<NativeImageResourceBuildItem> nativeImageResourceBuildItemBuildProducer, LiveReloadBuildItem liveReloadBuildItem, HttpRootPathBuildItem httpRootPathBuildItem, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> displayableEndpoints, CurateOutcomeBuildItem curateOutcomeBuildItem) throws Exception {
        if ("/".equals(this.swaggerUiConfig.path)) {
            throw new ConfigurationError("quarkus.swagger-ui.path was set to \"/\", this is not allowed as it blocks the application from serving anything else.");
        }
        if (!this.swaggerUiConfig.enable) {
            return;
        }
        String openApiPath = httpRootPathBuildItem.adjustPath(this.openapi.path);
        if (this.launch.getLaunchMode().isDevOrTest()) {
            boolean extractionNeeded;
            CachedSwaggerUI cached = (CachedSwaggerUI)liveReloadBuildItem.getContextObject(CachedSwaggerUI.class);
            boolean bl = extractionNeeded = cached == null;
            if (cached != null && !cached.cachedOpenAPIPath.equals(openApiPath)) {
                try {
                    FileUtil.deleteDirectory((Path)Paths.get(cached.cachedDirectory, new String[0]));
                }
                catch (IOException e) {
                    log.error((Object)"Failed to clean Swagger UI temp directory on restart", (Throwable)e);
                }
                extractionNeeded = true;
            }
            if (extractionNeeded) {
                if (cached == null) {
                    cached = new CachedSwaggerUI();
                    liveReloadBuildItem.setContextObject(CachedSwaggerUI.class, (Object)cached);
                    Runtime.getRuntime().addShutdownHook(new Thread((Runnable)cached, "Swagger UI Shutdown Hook"));
                }
                try {
                    AppArtifact artifact = this.getSwaggerUiArtifact(curateOutcomeBuildItem);
                    Path tempDir = Files.createTempDirectory(TEMP_DIR_PREFIX, new FileAttribute[0]).toRealPath(new LinkOption[0]);
                    this.extractSwaggerUi(artifact, tempDir);
                    this.updateApiUrl(tempDir.resolve("index.html"), openApiPath);
                    cached.cachedDirectory = tempDir.toAbsolutePath().toString();
                    cached.cachedOpenAPIPath = openApiPath;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            Handler handler = recorder.handler(cached.cachedDirectory, httpRootPathBuildItem.adjustPath(this.swaggerUiConfig.path));
            routes.produce((BuildItem)new RouteBuildItem(this.swaggerUiConfig.path, handler));
            routes.produce((BuildItem)new RouteBuildItem(this.swaggerUiConfig.path + "/*", handler));
            displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(this.swaggerUiConfig.path + "/"));
        } else if (this.swaggerUiConfig.alwaysInclude) {
            AppArtifact artifact = this.getSwaggerUiArtifact(curateOutcomeBuildItem);
            String versionedSwaggerUiWebjarPrefix = String.format("%s/%s/", SWAGGER_UI_WEBJAR_PREFIX, artifact.getVersion());
            for (Path p : artifact.getPaths()) {
                File artifactFile = p.toFile();
                JarFile jarFile = new JarFile(artifactFile);
                Throwable throwable = null;
                try {
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (!entry.getName().startsWith(versionedSwaggerUiWebjarPrefix) || entry.isDirectory()) continue;
                        InputStream inputStream = jarFile.getInputStream(entry);
                        Throwable throwable2 = null;
                        try {
                            String filename = entry.getName().replace(versionedSwaggerUiWebjarPrefix, "");
                            byte[] content = FileUtil.readFileContents((InputStream)inputStream);
                            if (entry.getName().endsWith("index.html")) {
                                content = this.updateApiUrl(new String(content, StandardCharsets.UTF_8), openApiPath).getBytes(StandardCharsets.UTF_8);
                            }
                            String fileName = "META-INF/swagger-ui-files/" + filename;
                            generatedResources.produce((BuildItem)new GeneratedResourceBuildItem(fileName, content));
                            nativeImageResourceBuildItemBuildProducer.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{fileName}));
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (inputStream == null) continue;
                            if (throwable2 != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            inputStream.close();
                        }
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (jarFile == null) continue;
                    if (throwable != null) {
                        try {
                            jarFile.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    jarFile.close();
                }
            }
            Iterator handler = recorder.handler(SWAGGER_UI_FINAL_DESTINATION, httpRootPathBuildItem.adjustPath(this.swaggerUiConfig.path));
            routes.produce((BuildItem)new RouteBuildItem(this.swaggerUiConfig.path, (Handler)handler));
            routes.produce((BuildItem)new RouteBuildItem(this.swaggerUiConfig.path + "/*", (Handler)handler));
        }
    }

    private AppArtifact getSwaggerUiArtifact(CurateOutcomeBuildItem curateOutcomeBuildItem) {
        for (AppDependency dep : curateOutcomeBuildItem.getEffectiveModel().getFullDeploymentDeps()) {
            if (!dep.getArtifact().getArtifactId().equals(SWAGGER_UI_WEBJAR_ARTIFACT_ID) || !dep.getArtifact().getGroupId().equals(SWAGGER_UI_WEBJAR_GROUP_ID)) continue;
            return dep.getArtifact();
        }
        throw new RuntimeException("Could not find artifact org.webjars:swagger-ui among the application dependencies");
    }

    private void extractSwaggerUi(AppArtifact artifact, Path resourceDir) throws IOException {
        String versionedSwaggerUiWebjarPrefix = String.format("%s/%s/", SWAGGER_UI_WEBJAR_PREFIX, artifact.getVersion());
        for (Path p : artifact.getPaths()) {
            File artifactFile = p.toFile();
            JarFile jarFile = new JarFile(artifactFile);
            Throwable throwable = null;
            try {
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (!entry.getName().startsWith(versionedSwaggerUiWebjarPrefix) || entry.isDirectory()) continue;
                    InputStream inputStream = jarFile.getInputStream(entry);
                    Throwable throwable2 = null;
                    try {
                        String filename = entry.getName().replace(versionedSwaggerUiWebjarPrefix, "");
                        Files.copy(inputStream, resourceDir.resolve(filename), new CopyOption[0]);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (jarFile == null) continue;
                if (throwable != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                jarFile.close();
            }
        }
    }

    private void updateApiUrl(Path indexHtml, String openApiPath) throws IOException {
        String content = new String(Files.readAllBytes(indexHtml), StandardCharsets.UTF_8);
        String result = this.updateApiUrl(content, openApiPath);
        if (result != null) {
            Files.write(indexHtml, result.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    public String updateApiUrl(String original, String openApiPath) {
        Matcher uriMatcher = SWAGGER_UI_DEFAULT_API_URL_PATTERN.matcher(original);
        if (uriMatcher.matches()) {
            return uriMatcher.replaceFirst("$1" + openApiPath + "$3");
        }
        log.warn((Object)"Unable to replace the default URL of Swagger UI");
        return null;
    }

    private static final class CachedSwaggerUI
    implements Runnable {
        String cachedOpenAPIPath;
        String cachedDirectory;

        private CachedSwaggerUI() {
        }

        @Override
        public void run() {
            try {
                FileUtil.deleteDirectory((Path)Paths.get(this.cachedDirectory, new String[0]));
            }
            catch (IOException e) {
                log.error((Object)"Failed to clean Swagger UI temp directory on shutdown", (Throwable)e);
            }
        }
    }

    @ConfigRoot
    static final class SwaggerUiConfig {
        @ConfigItem(defaultValue="/swagger-ui")
        String path;
        @ConfigItem
        boolean alwaysInclude;
        @ConfigItem(defaultValue="true")
        boolean enable;

        SwaggerUiConfig() {
        }
    }
}

