/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.swaggerui.runtime;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.swaggerui.runtime.SwaggerUiRuntimeConfig;
import io.quarkus.vertx.http.runtime.devmode.FileSystemStaticHandler;
import io.quarkus.vertx.http.runtime.webjar.WebJarNotFoundHandler;
import io.quarkus.vertx.http.runtime.webjar.WebJarStaticHandler;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.io.Closeable;
import java.util.List;

@Recorder
public class SwaggerUiRecorder {
    private final RuntimeValue<SwaggerUiRuntimeConfig> runtimeConfig;

    public SwaggerUiRecorder(RuntimeValue<SwaggerUiRuntimeConfig> runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
    }

    public Handler<RoutingContext> handler(String swaggerUiFinalDestination, String swaggerUiPath, List<FileSystemStaticHandler.StaticWebRootConfiguration> webRootConfigurations, ShutdownContext shutdownContext) {
        if (((SwaggerUiRuntimeConfig)this.runtimeConfig.getValue()).enable()) {
            WebJarStaticHandler handler = new WebJarStaticHandler(swaggerUiFinalDestination, swaggerUiPath, webRootConfigurations);
            shutdownContext.addShutdownTask((Runnable)new ShutdownContext.CloseRunnable((Closeable)handler));
            return handler;
        }
        return new WebJarNotFoundHandler();
    }
}

