/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class PathTestHelper {
    private static final String TEST_CLASSES_FRAGMENT_MAVEN = File.separator + "test-classes";
    private static final String CLASSES_FRAGMENT_MAVEN = File.separator + "classes";
    private static final String TEST_CLASSES_FRAGMENT_GRADLE = "classes" + File.separator + "java" + File.separator + "test";
    private static final String CLASSES_FRAGMENT_GRADLE = "classes" + File.separator + "java" + File.separator + "main";

    private PathTestHelper() {
    }

    public static Path getTestClassesLocation(Class<?> testClass) {
        String classFileName = testClass.getName().replace('.', File.separatorChar) + ".class";
        URL resource = testClass.getClassLoader().getResource(classFileName);
        try {
            Path path = Paths.get(resource.toURI());
            if (path.toString().contains(TEST_CLASSES_FRAGMENT_MAVEN) || path.toString().contains(TEST_CLASSES_FRAGMENT_GRADLE)) {
                return path.getRoot().resolve(path.subpath(0, path.getNameCount() - Paths.get(classFileName, new String[0]).getNameCount()));
            }
            throw new RuntimeException("The test class " + testClass + " is not located in the " + TEST_CLASSES_FRAGMENT_MAVEN + " nor in " + TEST_CLASSES_FRAGMENT_GRADLE + " directory.");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static Path getAppClassLocation(Class<?> testClass) {
        String testClassPath = PathTestHelper.getTestClassesLocation(testClass).toString();
        if (testClassPath.contains(TEST_CLASSES_FRAGMENT_MAVEN)) {
            return Paths.get(PathTestHelper.getTestClassesLocation(testClass).toString().replace(TEST_CLASSES_FRAGMENT_MAVEN, CLASSES_FRAGMENT_MAVEN), new String[0]);
        }
        return Paths.get(PathTestHelper.getTestClassesLocation(testClass).toString().replace(TEST_CLASSES_FRAGMENT_GRADLE, CLASSES_FRAGMENT_GRADLE), new String[0]);
    }

    public static boolean isTestClass(String className, ClassLoader classLoader) {
        String classFileName = className.replace('.', File.separatorChar) + ".class";
        URL resource = classLoader.getResource(classFileName);
        if (resource == null || !resource.getProtocol().startsWith("file")) {
            return false;
        }
        try {
            Path path = Paths.get(resource.toURI());
            return path.toString().contains(TEST_CLASSES_FRAGMENT_MAVEN) || path.toString().contains(TEST_CLASSES_FRAGMENT_GRADLE);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

