/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import io.quarkus.test.common.PathTestHelper;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;

public class TestResourceManager {
    private final Set<QuarkusTestResourceLifecycleManager> testResources;
    private Map<String, String> oldSystemProps;

    public TestResourceManager(Class<?> testClass) {
        this.testResources = this.getTestResources(testClass);
    }

    public Map<String, String> start() {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (QuarkusTestResourceLifecycleManager quarkusTestResourceLifecycleManager : this.testResources) {
            try {
                ret.putAll(quarkusTestResourceLifecycleManager.start());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to start Quarkus test resource " + quarkusTestResourceLifecycleManager, e);
            }
        }
        this.oldSystemProps = new HashMap<String, String>();
        for (Map.Entry entry : ret.entrySet()) {
            this.oldSystemProps.put((String)entry.getKey(), System.getProperty((String)entry.getKey()));
            System.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return ret;
    }

    public void stop() {
        for (Map.Entry<String, String> e : this.oldSystemProps.entrySet()) {
            if (e.getValue() == null) {
                System.clearProperty(e.getKey());
                continue;
            }
            System.setProperty(e.getKey(), e.getValue());
        }
        this.oldSystemProps = null;
        for (QuarkusTestResourceLifecycleManager testResource : this.testResources) {
            try {
                testResource.stop();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to start Quarkus test resource " + testResource, e);
            }
        }
    }

    private Set<QuarkusTestResourceLifecycleManager> getTestResources(Class<?> testClass) {
        IndexView index = this.indexTestClasses(testClass);
        LinkedHashSet testResourceRunnerClasses = new LinkedHashSet();
        for (AnnotationInstance annotation : index.getAnnotations(DotName.createSimple((String)QuarkusTestResource.class.getName()))) {
            try {
                testResourceRunnerClasses.add(Class.forName(annotation.value().asString()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("Unable to find the class for the test resource " + annotation.value().asString());
            }
        }
        LinkedHashSet<QuarkusTestResourceLifecycleManager> testResourceRunners = new LinkedHashSet<QuarkusTestResourceLifecycleManager>();
        for (Class clazz : testResourceRunnerClasses) {
            try {
                testResourceRunners.add((QuarkusTestResourceLifecycleManager)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException("Unable to instantiate the test resource " + clazz);
            }
        }
        for (QuarkusTestResourceLifecycleManager quarkusTestResourceLifecycleManager : ServiceLoader.load(QuarkusTestResourceLifecycleManager.class)) {
            testResourceRunners.add(quarkusTestResourceLifecycleManager);
        }
        return testResourceRunners;
    }

    private IndexView indexTestClasses(Class<?> testClass) {
        final Indexer indexer = new Indexer();
        try {
            Files.walkFileTree(PathTestHelper.getTestClassesLocation(testClass), (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (!file.toString().endsWith(".class")) {
                        return FileVisitResult.CONTINUE;
                    }
                    try (InputStream inputStream = Files.newInputStream(file, StandardOpenOption.READ);){
                        indexer.index(inputStream);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to index the test-classes/ directory.", e);
        }
        return indexer.complete();
    }
}

