/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public final class PathTestHelper {
    private static final Map<String, String> TEST_TO_MAIN_DIR_FRAGMENTS = new HashMap<String, String>();

    private PathTestHelper() {
    }

    public static Path getTestClassesLocation(Class<?> testClass) {
        String classFileName = testClass.getName().replace('.', File.separatorChar) + ".class";
        URL resource = testClass.getClassLoader().getResource(classFileName);
        if (resource.getProtocol().equals("jar")) {
            try {
                resource = URI.create(resource.getFile().substring(0, resource.getFile().indexOf(33))).toURL();
                return PathTestHelper.toPath(resource);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to resolve the location of the JAR containing " + testClass, e);
            }
        }
        if (!PathTestHelper.isInTestDir(resource)) {
            throw new RuntimeException("The test class " + testClass + " is not located in any of the directories " + TEST_TO_MAIN_DIR_FRAGMENTS.keySet());
        }
        Path path = PathTestHelper.toPath(resource);
        return path.getRoot().resolve(path.subpath(0, path.getNameCount() - Paths.get(classFileName, new String[0]).getNameCount()));
    }

    public static Path getAppClassLocation(Class<?> testClass) {
        String testClassPath = PathTestHelper.getTestClassesLocation(testClass).toString();
        if (testClassPath.endsWith(".jar")) {
            if (testClassPath.endsWith("-tests.jar")) {
                return Paths.get(new StringBuilder().append(testClassPath, 0, testClassPath.length() - "-tests.jar".length()).append(".jar").toString(), new String[0]);
            }
            return Paths.get(testClassPath, new String[0]);
        }
        return TEST_TO_MAIN_DIR_FRAGMENTS.entrySet().stream().filter(e -> testClassPath.contains((CharSequence)e.getKey())).map(e -> Paths.get(testClassPath.replace((CharSequence)e.getKey(), (CharSequence)e.getValue()), new String[0])).findFirst().orElseThrow(() -> new IllegalStateException("Unable to translate path for " + testClass.getName()));
    }

    public static boolean isTestClass(String className, ClassLoader classLoader) {
        String classFileName = className.replace('.', File.separatorChar) + ".class";
        URL resource = classLoader.getResource(classFileName);
        return resource != null && resource.getProtocol().startsWith("file") && PathTestHelper.isInTestDir(resource);
    }

    private static boolean isInTestDir(URL resource) {
        String path = PathTestHelper.toPath(resource).toString();
        return TEST_TO_MAIN_DIR_FRAGMENTS.keySet().stream().anyMatch(path::contains);
    }

    private static Path toPath(URL resource) {
        try {
            return Paths.get(resource.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Failed to convert URL " + resource, e);
        }
    }

    static {
        TEST_TO_MAIN_DIR_FRAGMENTS.put("bin" + File.separator + "test", "bin" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "java" + File.separator + "test", "classes" + File.separator + "java" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put("classes" + File.separator + "kotlin" + File.separator + "test", "classes" + File.separator + "kotlin" + File.separator + "main");
        TEST_TO_MAIN_DIR_FRAGMENTS.put(File.separator + "test-classes", File.separator + "classes");
    }
}

