/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import java.lang.reflect.Field;
import org.eclipse.microprofile.config.ConfigProvider;

public class RestAssuredURLManager {
    private static final int DEFAULT_HTTP_PORT = 8081;
    private static final int DEFAULT_HTTPS_PORT = 8444;
    private static final Field portField;
    private static final Field baseURIField;
    private int oldPort;
    private String oldBaseURI;
    private final boolean useSecureConnection;

    public RestAssuredURLManager(boolean useSecureConnection) {
        this.useSecureConnection = useSecureConnection;
    }

    private static int getPortFromConfig(String key, int defaultValue) {
        return ConfigProvider.getConfig().getOptionalValue(key, Integer.class).orElse(defaultValue);
    }

    public void setURL() {
        if (portField != null) {
            try {
                this.oldPort = (Integer)portField.get(null);
                int port = this.useSecureConnection ? RestAssuredURLManager.getPortFromConfig("quarkus.https.test-port", 8444) : RestAssuredURLManager.getPortFromConfig("quarkus.http.test-port", 8081);
                portField.set(null, port);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (baseURIField != null) {
            try {
                this.oldBaseURI = (String)baseURIField.get(null);
                String protocol = this.useSecureConnection ? "https://" : "http://";
                String baseURI = protocol + ConfigProvider.getConfig().getOptionalValue("quarkus.http.host", String.class).orElse("localhost");
                baseURIField.set(null, baseURI);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public void clearURL() {
        if (portField != null) {
            try {
                portField.set(null, this.oldPort);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (baseURIField != null) {
            try {
                baseURIField.set(null, this.oldBaseURI);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        Field base;
        Field p;
        try {
            Class<?> restAssured = Class.forName("io.restassured.RestAssured");
            p = restAssured.getField("port");
            p.setAccessible(true);
            base = restAssured.getField("baseURI");
            base.setAccessible(true);
        }
        catch (Exception e) {
            p = null;
            base = null;
        }
        portField = p;
        baseURIField = base;
    }
}

