/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common.http;

import io.quarkus.test.common.http.TestHTTPResource;
import io.quarkus.test.common.http.TestHTTPResourceProvider;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.eclipse.microprofile.config.ConfigProvider;

public class TestHTTPResourceManager {
    public static String getUri() {
        return (String)ConfigProvider.getConfig().getValue("test.url", String.class);
    }

    public static String getSslUri() {
        return (String)ConfigProvider.getConfig().getValue("test.url.ssl", String.class);
    }

    public static void inject(Object testCase) {
        Map<Class<?>, TestHTTPResourceProvider<?>> providers = TestHTTPResourceManager.getProviders();
        for (Class<?> c = testCase.getClass(); c != Object.class; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                TestHTTPResource resource = f.getAnnotation(TestHTTPResource.class);
                if (resource == null) continue;
                TestHTTPResourceProvider<?> provider = providers.get(f.getType());
                if (provider == null) {
                    throw new RuntimeException("Unable to inject TestHTTPResource field " + f + " as no provider exists for the type");
                }
                String path = resource.value();
                String val = resource.ssl() ? (path.startsWith("/") ? TestHTTPResourceManager.getSslUri() + path : TestHTTPResourceManager.getSslUri() + "/" + path) : (path.startsWith("/") ? TestHTTPResourceManager.getUri() + path : TestHTTPResourceManager.getUri() + "/" + path);
                f.setAccessible(true);
                try {
                    f.set(testCase, provider.provide(new URI(val), f));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static Map<Class<?>, TestHTTPResourceProvider<?>> getProviders() {
        HashMap map = new HashMap();
        for (TestHTTPResourceProvider i : ServiceLoader.load(TestHTTPResourceProvider.class)) {
            map.put(i.getProvidedType(), i);
        }
        return Collections.unmodifiableMap(map);
    }
}

