/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManagerComparator;
import io.quarkus.test.common.TestClassIndexer;
import java.io.Closeable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;

public class TestResourceManager
implements Closeable {
    private final List<QuarkusTestResourceLifecycleManager> testResources;
    private Map<String, String> oldSystemProps;

    public TestResourceManager(Class<?> testClass) {
        this.testResources = this.getTestResources(testClass);
    }

    public Map<String, String> start() {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (QuarkusTestResourceLifecycleManager quarkusTestResourceLifecycleManager : this.testResources) {
            try {
                Map<String, String> start = quarkusTestResourceLifecycleManager.start();
                if (start == null) continue;
                ret.putAll(start);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to start Quarkus test resource " + quarkusTestResourceLifecycleManager, e);
            }
        }
        this.oldSystemProps = new HashMap<String, String>();
        for (Map.Entry entry : ret.entrySet()) {
            this.oldSystemProps.put((String)entry.getKey(), System.getProperty((String)entry.getKey()));
            if (entry.getValue() == null) {
                System.clearProperty((String)entry.getKey());
                continue;
            }
            System.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return ret;
    }

    public void inject(Object testInstance) {
        for (QuarkusTestResourceLifecycleManager testResource : this.testResources) {
            testResource.inject(testInstance);
        }
    }

    @Override
    public void close() {
        if (this.oldSystemProps != null) {
            for (Map.Entry entry : this.oldSystemProps.entrySet()) {
                if (entry.getValue() == null) {
                    System.clearProperty((String)entry.getKey());
                    continue;
                }
                System.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.oldSystemProps = null;
        for (QuarkusTestResourceLifecycleManager quarkusTestResourceLifecycleManager : this.testResources) {
            try {
                quarkusTestResourceLifecycleManager.stop();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to stop Quarkus test resource " + quarkusTestResourceLifecycleManager, e);
            }
        }
        try {
            ConfigProviderResolver cpr = ConfigProviderResolver.instance();
            cpr.releaseConfig(cpr.getConfig());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private List<QuarkusTestResourceLifecycleManager> getTestResources(Class<?> testClass) {
        Index index = TestClassIndexer.readIndex(testClass);
        LinkedHashSet testResourceRunnerClasses = new LinkedHashSet();
        HashSet testResourceAnnotations = new HashSet();
        testResourceAnnotations.addAll(index.getAnnotations(DotName.createSimple((String)QuarkusTestResource.class.getName())));
        for (AnnotationInstance annotation : index.getAnnotations(DotName.createSimple((String)QuarkusTestResource.List.class.getName()))) {
            Collections.addAll(testResourceAnnotations, annotation.value().asNestedArray());
        }
        for (AnnotationInstance annotation : testResourceAnnotations) {
            try {
                testResourceRunnerClasses.add(Class.forName(annotation.value().asString(), true, Thread.currentThread().getContextClassLoader()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("Unable to find the class for the test resource " + annotation.value().asString());
            }
        }
        ArrayList<QuarkusTestResourceLifecycleManager> testResourceRunners = new ArrayList<QuarkusTestResourceLifecycleManager>();
        for (Class clazz : testResourceRunnerClasses) {
            try {
                testResourceRunners.add((QuarkusTestResourceLifecycleManager)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException("Unable to instantiate the test resource " + clazz);
            }
        }
        for (QuarkusTestResourceLifecycleManager quarkusTestResourceLifecycleManager : ServiceLoader.load(QuarkusTestResourceLifecycleManager.class, Thread.currentThread().getContextClassLoader())) {
            testResourceRunners.add(quarkusTestResourceLifecycleManager);
        }
        Collections.sort(testResourceRunners, new QuarkusTestResourceLifecycleManagerComparator());
        return testResourceRunners;
    }
}

