/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.runtime.configuration.QuarkusConfigFactory;
import io.quarkus.test.common.ListeningAddress;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import io.smallrye.config.SmallRyeConfig;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;

final class LauncherUtil {
    private LauncherUtil() {
    }

    static Config installAndGetSomeConfig() {
        SmallRyeConfig config = ConfigUtils.configBuilder((boolean)false, (LaunchMode)LaunchMode.NORMAL).build();
        QuarkusConfigFactory.setConfig((SmallRyeConfig)config);
        ConfigProviderResolver cpr = ConfigProviderResolver.instance();
        try {
            Config installed = cpr.getConfig();
            if (installed != config) {
                cpr.releaseConfig(installed);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return config;
    }

    static Process launchProcess(List<String> args) throws IOException {
        Process process = Runtime.getRuntime().exec(args.toArray(new String[0]));
        new Thread(new ProcessReader(process.getInputStream())).start();
        new Thread(new ProcessReader(process.getErrorStream())).start();
        return process;
    }

    static ListeningAddress waitForCapturedListeningData(Process quarkusProcess, Path logFile, long waitTimeSeconds) {
        CountDownLatch signal = new CountDownLatch(1);
        AtomicReference<ListeningAddress> resultReference = new AtomicReference<ListeningAddress>();
        CaptureListeningDataReader captureListeningDataReader = new CaptureListeningDataReader(logFile, Duration.ofSeconds(waitTimeSeconds), signal, resultReference);
        new Thread((Runnable)captureListeningDataReader, "capture-listening-data").start();
        try {
            signal.await(10L, TimeUnit.SECONDS);
            ListeningAddress result = resultReference.get();
            if (result != null) {
                return result;
            }
            quarkusProcess.destroyForcibly();
            throw new IllegalStateException("Unable to determine the status of the running process. See the above logs for details");
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting to capture listening process port and protocol");
        }
    }

    static void updateConfigForPort(Integer effectivePort) {
        System.setProperty("quarkus.http.port", effectivePort.toString());
        System.setProperty("quarkus.http.test-port", effectivePort.toString());
        LauncherUtil.installAndGetSomeConfig();
        System.setProperty("test.url", TestHTTPResourceManager.getUri());
    }

    private static class ProcessReader
    implements Runnable {
        private final InputStream inputStream;

        private ProcessReader(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public void run() {
            byte[] b = new byte[100];
            try {
                int i;
                while ((i = this.inputStream.read(b)) > 0) {
                    System.out.print(new String(b, 0, i, StandardCharsets.UTF_8));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class CaptureListeningDataReader
    implements Runnable {
        private final Path processOutput;
        private final Duration waitTime;
        private final CountDownLatch signal;
        private final AtomicReference<ListeningAddress> resultReference;
        private final Pattern listeningRegex = Pattern.compile("Listening on:\\s+(https?)://\\S*:(\\d+)");

        public CaptureListeningDataReader(Path processOutput, Duration waitTime, CountDownLatch signal, AtomicReference<ListeningAddress> resultReference) {
            this.processOutput = processOutput;
            this.waitTime = waitTime;
            this.signal = signal;
            this.resultReference = resultReference;
        }

        @Override
        public void run() {
            if (!this.ensureProcessOutputFileExists()) {
                return;
            }
            long bailoutTime = System.currentTimeMillis() + this.waitTime.toMillis();
            try (BufferedReader reader = new BufferedReader(new FileReader(this.processOutput.toFile()));){
                while (true) {
                    if (reader.ready()) {
                        String line = reader.readLine();
                        Matcher regexMatcher = this.listeningRegex.matcher(line);
                        if (regexMatcher.find()) {
                            this.dataDetermined(regexMatcher.group(1), Integer.valueOf(regexMatcher.group(2)));
                            return;
                        }
                        if (!line.contains("Failed to start application (with profile")) continue;
                        this.unableToDetermineData("Application was not started: " + line);
                        return;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        this.unableToDetermineData("Thread interrupted while waiting for more data to become available in proccess output file: " + this.processOutput.toAbsolutePath().toString());
                        reader.close();
                        return;
                    }
                    if (System.currentTimeMillis() > bailoutTime) break;
                }
                this.unableToDetermineData("Waited " + this.waitTime.getSeconds() + "seconds for " + this.processOutput + " to contain info about the listening port and protocol but no such info was found");
                return;
            }
            catch (Exception e) {
                this.unableToDetermineData("Exception occurred while reading process output from file " + this.processOutput);
                e.printStackTrace();
                return;
            }
        }

        private boolean ensureProcessOutputFileExists() {
            int i = 0;
            while (i++ < 25) {
                if (Files.exists(this.processOutput, new LinkOption[0])) {
                    return true;
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    this.unableToDetermineData("Thread interrupted while waiting for process output file to be created");
                    return false;
                }
            }
            return false;
        }

        private void dataDetermined(String protocolValue, Integer portValue) {
            this.resultReference.set(new ListeningAddress(portValue, protocolValue));
            this.signal.countDown();
        }

        private void unableToDetermineData(String errorMessage) {
            System.err.println(errorMessage);
            this.resultReference.set(null);
            this.signal.countDown();
        }
    }
}

