/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.common.QuarkusTestResourceConfigurableLifecycleManager;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManagerComparator;
import io.quarkus.test.common.ResourceArg;
import io.quarkus.test.common.TestClassIndexer;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;

public class TestResourceManager
implements Closeable {
    public static final String CLOSEABLE_NAME = TestResourceManager.class.getName() + ".closeable";
    private static final int ANNOTATION = 8192;
    private final List<TestResourceEntry> sequentialTestResourceEntries;
    private final List<TestResourceEntry> parallelTestResourceEntries;
    private final List<TestResourceEntry> allTestResourceEntries;
    private final Map<String, String> configProperties = new ConcurrentHashMap<String, String>();
    private boolean started = false;
    private boolean hasPerTestResources = false;

    public TestResourceManager(Class<?> testClass) {
        this(testClass, null, Collections.emptyList(), false);
    }

    public TestResourceManager(Class<?> testClass, Class<?> profileClass, List<TestResourceClassEntry> additionalTestResources, boolean disableGlobalTestResources) {
        this.parallelTestResourceEntries = new ArrayList<TestResourceEntry>();
        this.sequentialTestResourceEntries = new ArrayList<TestResourceEntry>();
        Set<TestResourceClassEntry> uniqueEntries = disableGlobalTestResources ? new HashSet<TestResourceClassEntry>(additionalTestResources) : this.getUniqueTestResourceClassEntries(testClass, profileClass, additionalTestResources);
        Set<TestResourceClassEntry> remainingUniqueEntries = this.initParallelTestResources(uniqueEntries);
        this.initSequentialTestResources(remainingUniqueEntries);
        this.allTestResourceEntries = new ArrayList<TestResourceEntry>(this.sequentialTestResourceEntries);
        this.allTestResourceEntries.addAll(this.parallelTestResourceEntries);
    }

    public void init() {
        for (TestResourceEntry entry : this.allTestResourceEntries) {
            try {
                QuarkusTestResourceLifecycleManager testResource = entry.getTestResource();
                if (testResource instanceof QuarkusTestResourceConfigurableLifecycleManager && entry.getConfigAnnotation() != null) {
                    ((QuarkusTestResourceConfigurableLifecycleManager)testResource).init(entry.getConfigAnnotation());
                    continue;
                }
                testResource.init(entry.getArgs());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable initialize test resource " + entry.getTestResource(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> start() {
        this.started = true;
        ConcurrentHashMap<String, String> ret = new ConcurrentHashMap<String, String>();
        ExecutorService executor = this.newExecutor(this.parallelTestResourceEntries.size() + 1);
        try {
            ArrayList<Future> startFutures = new ArrayList<Future>();
            for (TestResourceEntry entry : this.parallelTestResourceEntries) {
                Future<?> startFuture = executor.submit(() -> {
                    try {
                        Map<String, String> start = entry.getTestResource().start();
                        if (start != null) {
                            ret.putAll(start);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to start Quarkus test resource " + entry.getTestResource(), e);
                    }
                });
                startFutures.add(startFuture);
            }
            Future<?> sequentialStartFuture = executor.submit(() -> {
                for (TestResourceEntry entry : this.sequentialTestResourceEntries) {
                    try {
                        Map<String, String> start = entry.getTestResource().start();
                        if (start == null) continue;
                        ret.putAll(start);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to start Quarkus test resource " + entry.getTestResource(), e);
                    }
                }
            });
            startFutures.add(sequentialStartFuture);
            this.waitForAllFutures(startFutures);
        }
        finally {
            executor.shutdown();
        }
        this.configProperties.putAll(ret);
        return ret;
    }

    private void waitForAllFutures(List<Future> startFutures) {
        for (Future future : startFutures) {
            try {
                future.get();
            }
            catch (InterruptedException | CancellationException | ExecutionException e) {
                throw new RuntimeException("Error waiting for test resource future to finish.", e);
            }
        }
    }

    private ExecutorService newExecutor(int poolSize) {
        return Executors.newFixedThreadPool(poolSize);
    }

    public void inject(Object testInstance) {
        for (TestResourceEntry entry : this.allTestResourceEntries) {
            entry.getTestResource().inject(testInstance);
        }
    }

    @Override
    public void close() {
        if (!this.started) {
            return;
        }
        this.started = false;
        for (TestResourceEntry entry : this.allTestResourceEntries) {
            try {
                entry.getTestResource().stop();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to stop Quarkus test resource " + entry.getTestResource(), e);
            }
        }
        try {
            ConfigProviderResolver cpr = ConfigProviderResolver.instance();
            cpr.releaseConfig(cpr.getConfig());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.configProperties.clear();
    }

    public Map<String, String> getConfigProperties() {
        return this.configProperties;
    }

    private Set<TestResourceClassEntry> initParallelTestResources(Set<TestResourceClassEntry> uniqueEntries) {
        HashSet<TestResourceClassEntry> remainingUniqueEntries = new HashSet<TestResourceClassEntry>(uniqueEntries);
        for (TestResourceClassEntry entry : uniqueEntries) {
            if (!entry.isParallel()) continue;
            TestResourceEntry testResourceEntry = this.buildTestResourceEntry(entry);
            this.parallelTestResourceEntries.add(testResourceEntry);
            remainingUniqueEntries.remove(entry);
        }
        this.parallelTestResourceEntries.sort(new Comparator<TestResourceEntry>(){
            private final QuarkusTestResourceLifecycleManagerComparator lifecycleManagerComparator = new QuarkusTestResourceLifecycleManagerComparator();

            @Override
            public int compare(TestResourceEntry o1, TestResourceEntry o2) {
                return this.lifecycleManagerComparator.compare(o1.getTestResource(), o2.getTestResource());
            }
        });
        return remainingUniqueEntries;
    }

    private Set<TestResourceClassEntry> initSequentialTestResources(Set<TestResourceClassEntry> uniqueEntries) {
        TestResourceEntry testResourceEntry;
        HashSet<TestResourceClassEntry> remainingUniqueEntries = new HashSet<TestResourceClassEntry>(uniqueEntries);
        for (TestResourceClassEntry entry : uniqueEntries) {
            if (entry.isParallel()) continue;
            testResourceEntry = this.buildTestResourceEntry(entry);
            this.sequentialTestResourceEntries.add(testResourceEntry);
            remainingUniqueEntries.remove(entry);
        }
        for (QuarkusTestResourceLifecycleManager quarkusTestResourceLifecycleManager : ServiceLoader.load(QuarkusTestResourceLifecycleManager.class, Thread.currentThread().getContextClassLoader())) {
            testResourceEntry = new TestResourceEntry(quarkusTestResourceLifecycleManager);
            this.sequentialTestResourceEntries.add(testResourceEntry);
        }
        this.sequentialTestResourceEntries.sort(new Comparator<TestResourceEntry>(){
            private final QuarkusTestResourceLifecycleManagerComparator lifecycleManagerComparator = new QuarkusTestResourceLifecycleManagerComparator();

            @Override
            public int compare(TestResourceEntry o1, TestResourceEntry o2) {
                return this.lifecycleManagerComparator.compare(o1.getTestResource(), o2.getTestResource());
            }
        });
        return remainingUniqueEntries;
    }

    private TestResourceEntry buildTestResourceEntry(TestResourceClassEntry entry) {
        Class<? extends QuarkusTestResourceLifecycleManager> testResourceClass = entry.clazz;
        try {
            return new TestResourceEntry(testResourceClass.getConstructor(new Class[0]).newInstance(new Object[0]), entry.args, entry.configAnnotation);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Unable to instantiate the test resource " + testResourceClass.getName(), e);
        }
    }

    private Set<TestResourceClassEntry> getUniqueTestResourceClassEntries(Class<?> testClass, Class<?> profileClass, List<TestResourceClassEntry> additionalTestResources) {
        Class<?> profileClassFromTCCL;
        Class<?> testClassFromTCCL;
        Index index = TestClassIndexer.readIndex(testClass);
        HashSet<TestResourceClassEntry> uniqueEntries = new HashSet<TestResourceClassEntry>();
        try {
            testClassFromTCCL = Class.forName(testClass.getName(), false, Thread.currentThread().getContextClassLoader());
            profileClassFromTCCL = profileClass != null ? Class.forName(profileClass.getName(), false, Thread.currentThread().getContextClassLoader()) : null;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.collectMetaAnnotations(testClassFromTCCL, uniqueEntries);
        if (profileClassFromTCCL != null) {
            this.collectMetaAnnotations(profileClassFromTCCL, uniqueEntries);
        }
        for (AnnotationInstance annotation : this.findQuarkusTestResourceInstances(testClass, (IndexView)index)) {
            try {
                AnnotationValue restrict;
                Map<String, String> args;
                Class<? extends QuarkusTestResourceLifecycleManager> testResourceClass = this.loadTestResourceClassFromTCCL(annotation.value().asString());
                AnnotationValue argsAnnotationValue = annotation.value("initArgs");
                if (argsAnnotationValue == null) {
                    args = Collections.emptyMap();
                } else {
                    AnnotationInstance[] resourceArgsInstances;
                    args = new HashMap();
                    for (AnnotationInstance resourceArgsInstance : resourceArgsInstances = argsAnnotationValue.asNestedArray()) {
                        args.put(resourceArgsInstance.value("name").asString(), resourceArgsInstance.value().asString());
                    }
                }
                boolean isParallel = false;
                AnnotationValue parallelAnnotationValue = annotation.value("parallel");
                if (parallelAnnotationValue != null) {
                    isParallel = parallelAnnotationValue.asBoolean();
                }
                if ((restrict = annotation.value("restrictToAnnotatedClass")) != null && restrict.asBoolean()) {
                    this.hasPerTestResources = true;
                }
                uniqueEntries.add(new TestResourceClassEntry(testResourceClass, args, null, isParallel));
            }
            catch (IllegalArgumentException | SecurityException e) {
                throw new RuntimeException("Unable to instantiate the test resource " + annotation.value().asString(), e);
            }
        }
        uniqueEntries.addAll(additionalTestResources);
        return uniqueEntries;
    }

    private void collectMetaAnnotations(Class<?> testClassFromTCCL, Set<TestResourceClassEntry> uniqueEntries) {
        while (!testClassFromTCCL.getName().equals("java.lang.Object")) {
            block1: for (Annotation reflAnnotation : testClassFromTCCL.getAnnotations()) {
                for (Annotation annotationAnnotation : reflAnnotation.annotationType().getAnnotations()) {
                    Map<String, String> args;
                    if (annotationAnnotation.annotationType() != QuarkusTestResource.class) continue;
                    QuarkusTestResource testResource = (QuarkusTestResource)annotationAnnotation;
                    Class<? extends QuarkusTestResourceLifecycleManager> testResourceClass = testResource.value();
                    ResourceArg[] argsAnnotationValue = testResource.initArgs();
                    if (argsAnnotationValue.length == 0) {
                        args = Collections.emptyMap();
                    } else {
                        args = new HashMap();
                        for (ResourceArg arg : argsAnnotationValue) {
                            args.put(arg.name(), arg.value());
                        }
                    }
                    boolean isParallel = testResource.parallel();
                    this.hasPerTestResources = true;
                    uniqueEntries.add(new TestResourceClassEntry(testResourceClass, args, reflAnnotation, isParallel));
                    continue block1;
                }
            }
            testClassFromTCCL = testClassFromTCCL.getSuperclass();
        }
    }

    private Class<? extends QuarkusTestResourceLifecycleManager> loadTestResourceClassFromTCCL(String className) {
        try {
            return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Collection<AnnotationInstance> findQuarkusTestResourceInstances(Class<?> testClass, IndexView index) {
        HashSet<String> testClasses = new HashSet<String>();
        while (testClass != Object.class) {
            testClasses.add(testClass.getName());
            testClass = testClass.getSuperclass();
        }
        HashSet<AnnotationInstance> testResourceAnnotations = new HashSet<AnnotationInstance>();
        for (AnnotationInstance annotation : index.getAnnotations(DotName.createSimple((String)QuarkusTestResource.class.getName()))) {
            if (!this.keepTestResourceAnnotation(annotation, annotation.target().asClass(), testClasses)) continue;
            testResourceAnnotations.add(annotation);
        }
        for (AnnotationInstance annotation : index.getAnnotations(DotName.createSimple((String)QuarkusTestResource.List.class.getName()))) {
            for (AnnotationInstance nestedAnnotation : annotation.value().asNestedArray()) {
                if (!this.keepTestResourceAnnotation(nestedAnnotation, annotation.target().asClass(), testClasses)) continue;
                testResourceAnnotations.add(nestedAnnotation);
            }
        }
        return testResourceAnnotations;
    }

    public boolean hasPerTestResources() {
        return this.hasPerTestResources;
    }

    private boolean keepTestResourceAnnotation(AnnotationInstance annotation, ClassInfo targetClass, Set<String> testClasses) {
        if (this.isAnnotation(targetClass)) {
            return false;
        }
        AnnotationValue restrict = annotation.value("restrictToAnnotatedClass");
        if (restrict != null && restrict.asBoolean()) {
            return testClasses.contains(targetClass.name().toString('.'));
        }
        return true;
    }

    private boolean isAnnotation(ClassInfo info) {
        return (info.flags() & 0x2000) != 0;
    }

    private static class TestResourceEntry {
        private final QuarkusTestResourceLifecycleManager testResource;
        private final Map<String, String> args;
        private final Annotation configAnnotation;

        public TestResourceEntry(QuarkusTestResourceLifecycleManager testResource) {
            this(testResource, Collections.emptyMap(), null);
        }

        public TestResourceEntry(QuarkusTestResourceLifecycleManager testResource, Map<String, String> args, Annotation configAnnotation) {
            this.testResource = testResource;
            this.args = args;
            this.configAnnotation = configAnnotation;
        }

        public QuarkusTestResourceLifecycleManager getTestResource() {
            return this.testResource;
        }

        public Map<String, String> getArgs() {
            return this.args;
        }

        public Annotation getConfigAnnotation() {
            return this.configAnnotation;
        }
    }

    public static class TestResourceClassEntry {
        private Class<? extends QuarkusTestResourceLifecycleManager> clazz;
        private Map<String, String> args;
        private boolean parallel;
        private Annotation configAnnotation;

        public TestResourceClassEntry(Class<? extends QuarkusTestResourceLifecycleManager> clazz, Map<String, String> args, Annotation configAnnotation, boolean parallel) {
            this.clazz = clazz;
            this.args = args;
            this.configAnnotation = configAnnotation;
            this.parallel = parallel;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestResourceClassEntry that = (TestResourceClassEntry)o;
            return this.clazz.equals(that.clazz) && this.args.equals(that.args) && Objects.equals(this.configAnnotation, that.configAnnotation) && this.parallel == that.parallel;
        }

        public int hashCode() {
            return Objects.hash(this.clazz, this.args, this.configAnnotation, this.parallel);
        }

        public boolean isParallel() {
            return this.parallel;
        }
    }
}

