/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import io.quarkus.runtime.util.ContainerRuntimeUtil;
import io.quarkus.test.common.ArtifactLauncher;
import io.quarkus.test.common.DefaultJarLauncher;
import io.quarkus.test.common.DockerContainerArtifactLauncher;
import io.quarkus.test.common.IntegrationTestStartedNotifier;
import io.quarkus.test.common.LauncherUtil;
import io.quarkus.test.common.ListeningAddress;
import io.quarkus.test.common.PropertyTestUtil;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import io.smallrye.config.common.utils.StringUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.io.input.TeeInputStream;
import org.apache.commons.lang3.RandomStringUtils;

public class DefaultDockerContainerLauncher
implements DockerContainerArtifactLauncher {
    private int httpPort;
    private int httpsPort;
    private long waitTimeSeconds;
    private String testProfile;
    private List<String> argLine;
    private ArtifactLauncher.InitContext.DevServicesLaunchResult devServicesLaunchResult;
    private String containerImage;
    private boolean pullRequired;
    private Map<Integer, Integer> additionalExposedPorts;
    private final Map<String, String> systemProps = new HashMap<String, String>();
    private boolean isSsl;
    private String containerName;
    private String containerRuntimeBinaryName;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();

    @Override
    public void init(DockerContainerArtifactLauncher.DockerInitContext initContext) {
        this.httpPort = initContext.httpPort();
        this.httpsPort = initContext.httpsPort();
        this.waitTimeSeconds = initContext.waitTime().getSeconds();
        this.testProfile = initContext.testProfile();
        this.argLine = initContext.argLine();
        this.devServicesLaunchResult = initContext.getDevServicesLaunchResult();
        this.containerImage = initContext.containerImage();
        this.pullRequired = initContext.pullRequired();
        this.additionalExposedPorts = initContext.additionalExposedPorts();
    }

    @Override
    public ArtifactLauncher.LaunchResult runToCompletion(String[] args) {
        throw new UnsupportedOperationException("not implemented for docker yet");
    }

    @Override
    public void start() throws IOException {
        this.containerRuntimeBinaryName = this.determineBinary();
        if (this.pullRequired) {
            System.out.println("Pulling container image '" + this.containerImage + "'");
            try {
                int pullResult = new ProcessBuilder(new String[0]).redirectError(ProcessBuilder.Redirect.DISCARD).redirectOutput(ProcessBuilder.Redirect.DISCARD).command(this.containerRuntimeBinaryName, "pull", this.containerImage).start().waitFor();
                if (pullResult > 0) {
                    throw new RuntimeException("Pulling container image '" + this.containerImage + "' completed unsuccessfully");
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Unable to pull container image '" + this.containerImage + "'", e);
            }
        }
        System.setProperty("test.url", TestHTTPResourceManager.getUri());
        if (this.httpPort == 0) {
            this.httpPort = this.getRandomPort();
        }
        if (this.httpsPort == 0) {
            this.httpsPort = this.getRandomPort();
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.containerRuntimeBinaryName);
        args.add("run");
        if (!this.argLine.isEmpty()) {
            args.addAll(this.argLine);
        }
        args.add("--name");
        this.containerName = "quarkus-integration-test-" + RandomStringUtils.random((int)5, (boolean)true, (boolean)false);
        args.add(this.containerName);
        args.add("--rm");
        args.add("-p");
        args.add(this.httpPort + ":" + this.httpPort);
        args.add("-p");
        args.add(this.httpsPort + ":" + this.httpsPort);
        for (Map.Entry<Integer, Integer> entry : this.additionalExposedPorts.entrySet()) {
            args.add("-p");
            args.add(entry.getKey() + ":" + entry.getValue());
        }
        if (this.devServicesLaunchResult.networkId() != null) {
            args.add("--net=" + this.devServicesLaunchResult.networkId());
        }
        if (DefaultJarLauncher.HTTP_PRESENT) {
            args.addAll(this.toEnvVar("quarkus.http.port", "" + this.httpPort));
            args.addAll(this.toEnvVar("quarkus.http.ssl-port", "" + this.httpsPort));
            args.addAll(this.toEnvVar("test.url", TestHTTPResourceManager.getUri()));
        }
        if (this.testProfile != null) {
            args.addAll(this.toEnvVar("quarkus.profile", this.testProfile));
        }
        for (Map.Entry<Object, Object> entry : this.systemProps.entrySet()) {
            args.addAll(this.toEnvVar((String)entry.getKey(), (String)entry.getValue()));
        }
        args.add(this.containerImage);
        Path logFile = PropertyTestUtil.getLogFilePath();
        Files.deleteIfExists(logFile);
        Files.createDirectories(logFile.getParent(), new FileAttribute[0]);
        Path path = Paths.get("target", "container.log");
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        FileOutputStream containerLogOutputStream = new FileOutputStream(path.toFile(), true);
        System.out.println("Executing \"" + String.join((CharSequence)" ", args) + "\"");
        Function<IntegrationTestStartedNotifier.Context, IntegrationTestStartedNotifier.Result> startedFunction = LauncherUtil.createStartedFunction();
        Process quarkusProcess = new ProcessBuilder(args).redirectError(ProcessBuilder.Redirect.PIPE).redirectOutput(ProcessBuilder.Redirect.PIPE).start();
        TeeInputStream tee = new TeeInputStream(quarkusProcess.getInputStream(), (OutputStream)new FileOutputStream(logFile.toFile()));
        this.executorService.submit(() -> DefaultDockerContainerLauncher.lambda$start$0((InputStream)tee, containerLogOutputStream));
        if (startedFunction != null) {
            IntegrationTestStartedNotifier.Result result = LauncherUtil.waitForStartedFunction(startedFunction, quarkusProcess, this.waitTimeSeconds, logFile);
            this.isSsl = result.isSsl();
        } else {
            ListeningAddress result = LauncherUtil.waitForCapturedListeningData(quarkusProcess, logFile, this.waitTimeSeconds);
            LauncherUtil.updateConfigForPort(result.getPort());
            this.isSsl = result.isSsl();
        }
    }

    private String determineBinary() {
        return ContainerRuntimeUtil.detectContainerRuntime().getExecutableName();
    }

    private int getRandomPort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }

    @Override
    public boolean listensOnSsl() {
        return this.isSsl;
    }

    @Override
    public void includeAsSysProps(Map<String, String> systemProps) {
        this.systemProps.putAll(systemProps);
    }

    private List<String> toEnvVar(String property, String value) {
        if (property != null && !property.isEmpty()) {
            ArrayList<String> result = new ArrayList<String>(2);
            result.add("--env");
            result.add(String.format("%s=%s", this.convertPropertyToEnvVar(property), value));
            return result;
        }
        return Collections.emptyList();
    }

    private String convertPropertyToEnvVar(String property) {
        return StringUtil.replaceNonAlphanumericByUnderscores((String)property).toUpperCase();
    }

    @Override
    public void close() {
        try {
            Process dockerStopProcess = new ProcessBuilder(this.containerRuntimeBinaryName, "stop", this.containerName).redirectError(ProcessBuilder.Redirect.DISCARD).redirectOutput(ProcessBuilder.Redirect.DISCARD).start();
            dockerStopProcess.waitFor(10L, TimeUnit.SECONDS);
        }
        catch (IOException | InterruptedException e) {
            System.out.println("Unable to stop container '" + this.containerName + "'");
        }
        this.executorService.shutdown();
    }

    private static /* synthetic */ Long lambda$start$0(InputStream tee, FileOutputStream containerLogOutputStream) throws Exception {
        return tee.transferTo(containerLogOutputStream);
    }
}

