/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.keycloak.client;

import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.test.common.DevServicesContext;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.microprofile.config.ConfigProvider;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.util.JsonSerialization;

public class KeycloakTestClient
implements DevServicesContext.ContextAware {
    private static final String CLIENT_AUTH_SERVER_URL_PROP = "client.quarkus.oidc.auth-server-url";
    private static final String AUTH_SERVER_URL_PROP = "quarkus.oidc.auth-server-url";
    private static final String CLIENT_ID_PROP = "quarkus.oidc.client-id";
    private static final String CLIENT_SECRET_PROP = "quarkus.oidc.credentials.secret";
    private DevServicesContext testContext;

    public String getAccessToken(String userName) {
        return this.getAccessToken(userName, this.getClientId());
    }

    public String getAccessToken(String userName, String clientId) {
        return this.getAccessToken(userName, userName, clientId);
    }

    public String getAccessToken(String userName, String userSecret, String clientId) {
        return this.getAccessToken(userName, userSecret, clientId, this.getClientSecret());
    }

    public String getAccessToken(String userName, String userSecret, String clientId, String clientSecret) {
        return this.getAccessTokenInternal(userName, userSecret, clientId, clientSecret, this.getAuthServerUrl());
    }

    private String getAccessTokenInternal(String userName, String userSecret, String clientId, String clientSecret, String authServerUrl) {
        RequestSpecification requestSpec = RestAssured.given().param("grant_type", new Object[]{"password"}).param("username", new Object[]{userName}).param("password", new Object[]{userSecret}).param("client_id", new Object[]{clientId});
        if (clientSecret != null && !clientSecret.isBlank()) {
            requestSpec = requestSpec.param("client_secret", new Object[]{clientSecret});
        }
        return ((AccessTokenResponse)((Response)requestSpec.when().post(authServerUrl + "/protocol/openid-connect/token", new Object[0])).as(AccessTokenResponse.class)).getToken();
    }

    private String getClientId() {
        return this.getPropertyValue(CLIENT_ID_PROP, "quarkus-app");
    }

    private String getClientSecret() {
        return this.getPropertyValue(CLIENT_SECRET_PROP, "secret");
    }

    public String getAdminAccessToken() {
        return this.getAccessTokenInternal("admin", "admin", "admin-cli", null, this.getAuthServerBaseUrl() + "/realms/master");
    }

    public String getAuthServerBaseUrl() {
        try {
            URI uri = new URI(this.getAuthServerUrl());
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath().startsWith("/auth") ? "/auth" : null, null, null).toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String getAuthServerUrl() {
        String authServerUrl = this.getPropertyValue(CLIENT_AUTH_SERVER_URL_PROP, null);
        if (authServerUrl == null) {
            authServerUrl = this.getPropertyValue(AUTH_SERVER_URL_PROP, null);
        }
        if (authServerUrl == null) {
            throw new ConfigurationException(String.format("Unable to obtain the Auth Server URL as neither '%s' or '%s' is set", CLIENT_AUTH_SERVER_URL_PROP, AUTH_SERVER_URL_PROP));
        }
        return authServerUrl;
    }

    public void createRealm(RealmRepresentation realm) {
        try {
            ((ValidatableResponse)((Response)RestAssured.given().auth().oauth2(this.getAdminAccessToken()).contentType("application/json").body(JsonSerialization.writeValueAsBytes((Object)realm)).when().post(this.getAuthServerBaseUrl() + "/admin/realms", new Object[0])).then()).statusCode(201);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteRealm(String realm) {
        ((ValidatableResponse)((Response)RestAssured.given().auth().oauth2(this.getAdminAccessToken()).when().delete(this.getAuthServerBaseUrl() + "/admin/realms/" + realm, new Object[0])).then()).statusCode(204);
    }

    private String getPropertyValue(String prop, String defaultValue) {
        return ConfigProvider.getConfig().getOptionalValue(prop, String.class).orElseGet(() -> this.getDevProperty(prop, defaultValue));
    }

    private String getDevProperty(String prop, String defaultValue) {
        String value = this.testContext == null ? null : (String)this.testContext.devServicesProperties().get(prop);
        return value == null ? defaultValue : value;
    }

    public void setIntegrationTestContext(DevServicesContext context) {
        this.testContext = context;
    }

    static {
        RestAssured.useRelaxedHTTPSValidation();
    }
}

