/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.kubernetes.client;

import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.server.mock.KubernetesMockServer;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import io.quarkus.test.kubernetes.client.MockServer;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class KubernetesMockServerTestResource
implements QuarkusTestResourceLifecycleManager {
    private KubernetesMockServer mockServer;

    public Map<String, String> start() {
        HashMap<String, String> systemProps = new HashMap<String, String>();
        systemProps.put("kubernetes.trust.certificates", "true");
        systemProps.put("kubernetes.auth.tryKubeConfig", "false");
        systemProps.put("kubernetes.auth.tryServiceAccount", "false");
        systemProps.put("kubernetes.namespace", "test");
        systemProps.put("http2.disable", "true");
        this.mockServer = this.createMockServer();
        this.mockServer.init();
        try (NamespacedKubernetesClient client = this.mockServer.createClient();){
            systemProps.put("kubernetes.master", client.getConfiguration().getMasterUrl());
        }
        this.configureMockServer(this.mockServer);
        return systemProps;
    }

    protected KubernetesMockServer createMockServer() {
        return new KubernetesMockServer(this.useHttps());
    }

    public void configureMockServer(KubernetesMockServer mockServer) {
    }

    public void stop() {
        if (this.mockServer != null) {
            this.mockServer.destroy();
        }
    }

    public void inject(Object testInstance) {
        for (Class<?> c = testInstance.getClass(); c != Object.class; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                if (f.getAnnotation(MockServer.class) == null) continue;
                if (!KubernetesMockServer.class.isAssignableFrom(f.getType())) {
                    throw new RuntimeException("@MockServer can only be used on fields of type KubernetesMockServer");
                }
                f.setAccessible(true);
                try {
                    f.set(testInstance, this.mockServer);
                    return;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    protected boolean useHttps() {
        return Boolean.getBoolean("quarkus.kubernetes-client.test.https");
    }
}

