/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.kubernetes.client;

import io.fabric8.kubernetes.client.GenericKubernetesClient;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractKubernetesTestResource<T>
implements QuarkusTestResourceLifecycleManager {
    protected T server;

    public Map<String, String> start() {
        HashMap<String, String> systemProps = new HashMap<String, String>();
        systemProps.put("kubernetes.trust.certificates", "true");
        systemProps.put("kubernetes.auth.tryKubeConfig", "false");
        systemProps.put("kubernetes.auth.tryServiceAccount", "false");
        systemProps.put("kubernetes.namespace", "test");
        systemProps.put("http2.disable", "true");
        this.server = this.createServer();
        this.initServer();
        try (GenericKubernetesClient<?> client = this.getClient();){
            systemProps.put("kubernetes.master", client.getConfiguration().getMasterUrl());
        }
        this.configureServer();
        return systemProps;
    }

    protected abstract GenericKubernetesClient<?> getClient();

    protected void configureServer() {
    }

    protected void initServer() {
    }

    protected abstract T createServer();

    protected boolean useHttps() {
        return Boolean.getBoolean("quarkus.kubernetes-client.test.https");
    }

    public void inject(Object testInstance) {
        Class<Annotation> annotation = this.getInjectionAnnotation();
        Class<?> injectedClass = this.getInjectedClass();
        for (Class<?> c = testInstance.getClass(); c != Object.class; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                if (f.getAnnotation(annotation) == null) continue;
                if (!injectedClass.isAssignableFrom(f.getType())) {
                    throw new RuntimeException(annotation + " can only be used on fields of type " + injectedClass);
                }
                f.setAccessible(true);
                try {
                    f.set(testInstance, this.server);
                    return;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    protected abstract Class<?> getInjectedClass();

    protected abstract Class<? extends Annotation> getInjectionAnnotation();
}

