/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.kubernetes.client;

import io.fabric8.kubernetes.client.GenericKubernetesClient;
import io.fabric8.kubernetes.client.server.mock.KubernetesServer;
import io.quarkus.test.common.QuarkusTestResourceConfigurableLifecycleManager;
import io.quarkus.test.kubernetes.client.AbstractKubernetesTestResource;
import io.quarkus.test.kubernetes.client.KubernetesTestServer;
import io.quarkus.test.kubernetes.client.WithKubernetesTestServer;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.util.Collections;
import java.util.function.Consumer;

public class KubernetesServerTestResource
extends AbstractKubernetesTestResource<KubernetesServer>
implements QuarkusTestResourceConfigurableLifecycleManager<WithKubernetesTestServer> {
    private boolean https = false;
    private boolean crud = true;
    private int port = 0;
    private Consumer<KubernetesServer> setup;

    public void init(WithKubernetesTestServer annotation) {
        this.https = annotation.https();
        this.crud = annotation.crud();
        this.port = annotation.port();
        try {
            this.setup = annotation.setup().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected GenericKubernetesClient<?> getClient() {
        return ((KubernetesServer)this.server).getClient();
    }

    @Override
    protected void initServer() {
        ((KubernetesServer)this.server).before();
    }

    @Override
    protected void configureServer() {
        if (this.setup != null) {
            this.setup.accept((KubernetesServer)this.server);
        }
    }

    @Override
    protected KubernetesServer createServer() {
        return new KubernetesServer(this.https, this.crud, InetAddress.getLoopbackAddress(), this.port, Collections.emptyList());
    }

    public void stop() {
        if (this.server != null) {
            ((KubernetesServer)this.server).after();
            this.server = null;
        }
    }

    @Override
    protected Class<?> getInjectedClass() {
        return KubernetesServer.class;
    }

    @Override
    protected Class<? extends Annotation> getInjectionAnnotation() {
        return KubernetesTestServer.class;
    }
}

