/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.kubernetes.client;

import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.quarkus.test.common.QuarkusTestResourceConfigurableLifecycleManager;
import io.quarkus.test.kubernetes.client.AbstractKubernetesTestResource;
import io.quarkus.test.kubernetes.client.KubernetesServer;
import io.quarkus.test.kubernetes.client.KubernetesTestServer;
import io.quarkus.test.kubernetes.client.WithKubernetesTestServer;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.function.Consumer;

public class KubernetesServerTestResource
extends AbstractKubernetesTestResource<KubernetesServer, NamespacedKubernetesClient>
implements QuarkusTestResourceConfigurableLifecycleManager<WithKubernetesTestServer> {
    private boolean https = false;
    private boolean crud = true;
    private int port = 0;
    private Consumer<KubernetesServer> setup;

    public void init(WithKubernetesTestServer annotation) {
        this.https = annotation.https();
        this.crud = annotation.crud();
        this.port = annotation.port();
        try {
            this.setup = annotation.setup().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected NamespacedKubernetesClient getClient() {
        return ((KubernetesServer)this.server).getClient();
    }

    @Override
    protected void initServer() {
        ((KubernetesServer)this.server).before();
    }

    @Override
    protected void configureServer() {
        if (this.setup != null) {
            this.setup.accept((KubernetesServer)this.server);
        }
    }

    @Override
    protected KubernetesServer createServer() {
        return new KubernetesServer(this.https, this.crud, InetAddress.getLoopbackAddress(), this.port, Collections.emptyList());
    }

    public void stop() {
        if (this.server != null) {
            ((KubernetesServer)this.server).after();
            this.server = null;
        }
    }

    @Override
    protected Class<?> getInjectedClass() {
        return KubernetesServer.class;
    }

    @Override
    protected Class<? extends Annotation> getInjectionAnnotation() {
        return KubernetesTestServer.class;
    }
}

