/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.it.assertions;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.assertj.core.api.Assertions;

class JarVerifier {
    private File jarFile;

    JarVerifier(File jarFile) {
        this.jarFile = jarFile;
    }

    void assertThatJarIsCreated() {
        Assertions.assertThat((File)this.jarFile).isNotNull();
        Assertions.assertThat((File)this.jarFile).isFile();
    }

    void assertThatJarHasManifest() throws Exception {
        try (JarFile jf = new JarFile(this.jarFile);){
            Manifest manifest = jf.getManifest();
            Assertions.assertThat((Object)manifest).isNotNull();
        }
    }

    void assertThatFileIsContained(String file) throws Exception {
        try (JarFile jf = new JarFile(this.jarFile);){
            Assertions.assertThat((Object)jf.getJarEntry(file)).isNotNull();
        }
    }

    void assertThatFileIsNotContained(String file) throws Exception {
        try (JarFile jf = new JarFile(this.jarFile);){
            Assertions.assertThat((Object)jf.getJarEntry(file)).isNull();
        }
    }

    void assertThatFileContains(String path, String[] lines) throws Exception {
        try (JarFile jf = new JarFile(this.jarFile);){
            ZipEntry entry = jf.getEntry(path);
            Assertions.assertThat((Object)entry).isNotNull();
            String content = JarVerifier.read(jf.getInputStream(entry));
            Assertions.assertThat((String)content).containsSubsequence((CharSequence[])lines);
        }
    }

    private static String read(InputStream input) throws IOException {
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            String string = buffer.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }
}

