/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.it.verifier;

import io.quarkus.maven.it.verifier.MavenProcessInvocationResult;
import java.io.File;
import org.apache.maven.shared.invoker.CommandLineConfigurationException;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.InvokerLogger;
import org.apache.maven.shared.invoker.MavenCommandLineBuilder;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.invoker.SystemOutHandler;
import org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.shared.utils.cli.Commandline;
import org.apache.maven.shared.utils.cli.StreamConsumer;
import org.apache.maven.shared.utils.cli.StreamPumper;

public class MavenProcessInvoker
extends DefaultInvoker {
    private static final InvocationOutputHandler DEFAULT_OUTPUT_HANDLER = new SystemOutHandler();
    private InvocationOutputHandler outputHandler = DEFAULT_OUTPUT_HANDLER;
    private InvocationOutputHandler errorHandler = DEFAULT_OUTPUT_HANDLER;

    public InvocationResult execute(InvocationRequest request) throws MavenInvocationException {
        Commandline cli;
        File workingDirectory;
        File mavenExecutable;
        File mavenHome;
        File localRepo;
        MavenCommandLineBuilder cliBuilder = new MavenCommandLineBuilder();
        InvokerLogger logger = this.getLogger();
        if (logger != null) {
            cliBuilder.setLogger(this.getLogger());
        }
        if ((localRepo = this.getLocalRepositoryDirectory()) != null) {
            cliBuilder.setLocalRepositoryDirectory(this.getLocalRepositoryDirectory());
        }
        if ((mavenHome = this.getMavenHome()) != null) {
            cliBuilder.setMavenHome(this.getMavenHome());
        }
        if ((mavenExecutable = this.getMavenExecutable()) != null) {
            cliBuilder.setMavenExecutable(mavenExecutable);
        }
        if ((workingDirectory = this.getWorkingDirectory()) != null) {
            cliBuilder.setBaseDirectory(this.getWorkingDirectory());
        }
        request.setBatchMode(true);
        try {
            cli = cliBuilder.build(request);
        }
        catch (CommandLineConfigurationException e) {
            throw new MavenInvocationException("Error configuring command-line. Reason: " + e.getMessage(), (Throwable)e);
        }
        MavenProcessInvocationResult result = new MavenProcessInvocationResult();
        try {
            Process process = this.executeCommandLine(cli, request);
            result.setProcess(process);
        }
        catch (CommandLineException e) {
            result.setException(e);
        }
        return result;
    }

    private Process executeCommandLine(Commandline cli, InvocationRequest request) throws CommandLineException {
        InvocationOutputHandler outputHandler = request.getOutputHandler(this.outputHandler);
        InvocationOutputHandler errorHandler = request.getErrorHandler(this.errorHandler);
        return MavenProcessInvoker.executeCommandLine(cli, (StreamConsumer)outputHandler, (StreamConsumer)errorHandler);
    }

    private static Process executeCommandLine(Commandline cl, StreamConsumer systemOut, StreamConsumer systemErr) throws CommandLineException {
        if (cl == null) {
            throw new IllegalArgumentException("the command line cannot be null.");
        }
        Process p = cl.execute();
        StreamPumper outputPumper = new StreamPumper(p.getInputStream(), systemOut);
        StreamPumper errorPumper = new StreamPumper(p.getErrorStream(), systemErr);
        outputPumper.start();
        errorPumper.start();
        new Thread(() -> {
            try {
                p.waitFor();
                outputPumper.waitUntilDone();
                errorPumper.waitUntilDone();
            }
            catch (Exception e) {
                outputPumper.disable();
                errorPumper.disable();
                e.printStackTrace();
            }
        }).start();
        return p;
    }
}

