/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.oidc.server;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.responsetemplating.ResponseTemplateTransformer;
import com.github.tomakehurst.wiremock.extension.responsetemplating.TemplateEngine;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.google.common.collect.ImmutableSet;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import io.quarkus.test.oidc.server.OidcWireMock;
import io.smallrye.jwt.build.Jwt;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.jose4j.keys.X509Util;

public class OidcWiremockTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOG = Logger.getLogger(OidcWiremockTestResource.class);
    private static final String TOKEN_ISSUER = System.getProperty("quarkus.test.oidc.token.issuer", "https://server.example.com");
    private static final String TOKEN_AUDIENCE = System.getProperty("quarkus.test.oidc.token.audience", "https://server.example.com");
    private static final String TOKEN_USER_ROLES = System.getProperty("quarkus.test.oidc.token.user-roles", "user");
    private static final String TOKEN_ADMIN_ROLES = System.getProperty("quarkus.test.oidc.token.admin-roles", "user,admin");
    private static final String ENCODED_X5C = "MIIC+zCCAeOgAwIBAgIGAXx/E9rgMA0GCSqGSIb3DQEBCwUAMBQxEjAQBgNVBAMMCWxvY2FsaG9zdDAeFw0yMTEwMTQxMzUzMDBaFw0yMjEwMTQxMzUzMDBaMBQxEjAQBgNVBAMMCWxvY2FsaG9zdDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAIicN95dXlQLBqEZUsqPhQopnjnPgGmW80NohEgNzZLqN0xW9cyJJrdJM5Z1lRrePHZGiJdd1XXn4fYasP6/cjRfMWal9X6dD5wlnOTP01/4beX5vctE6W4lZrI3kTFmZ+I69w7BaLsUPWgV1CYrtuldL3dr6xAnngK3hU+JraB2Ndw9llXib26HOZhCXKedCTYcUQieVJGPI0f8H1JNk88+PnwI+cUGgXHF56iTLv9QujI6AhIgextXdd21T0XiHgBkSlSSBeqIKAjfCW6zoXP+PJU+Lso24J3duG3mrbilqHZlmIWnLRaG0RmKOeedXIDHvAaMaVUOLaN9HBgNKo0CAwEAAaNTMFEwHQYDVR0OBBYEFMYGoBNHBTMvMT4DwClVHVVwn+5VMB8GA1UdIwQYMBaAFMYGoBNHBTMvMT4DwClVHVVwn+5VMA8GA1UdEwEB/wQFMAMBAf8wDQYJKoZIhvcNAQELBQADggEBAFulB0DKhykXGbGPIBPcj63ItLNilgl1i8i43my8fYdV6OBWLIhZ4InhpX1+XmYCNPNtu94Jy1csS00K2/Hhn4ByBd+6nd5DSr0W0VdVQyhLz3GW1nf0J3X2N+tD818O0KtKKPTq4p9reg/XtV+DNv7DeDAGzlfgRL4E4fQx6OYeuu35kGrPvAddIA70leJMELJRylCLfEcl2ne/Bht8cZVp7ZCxnfXnsc+7hCW84mhzGjJycA3E6TnZPD3pD+q9FoIAQMxMQqUCH71u9vTvz1Q5JdokuJJY2eTHSUKyHA9MwSFq8DFDICJFBoQuFyDlK5yxSUcQpR3mBwKdimj6oA0=";
    private WireMockServer server;

    public Map<String, String> start() {
        WireMockConfiguration wireMockConfiguration = WireMockConfiguration.wireMockConfig();
        this.server = new WireMockServer((Options)wireMockConfiguration.extensions(new Extension[]{new ResponseTemplateTransformer(TemplateEngine.defaultTemplateEngine(), false, wireMockConfiguration.filesRoot(), Collections.emptyList())}).dynamicPort());
        this.server.start();
        this.server.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/auth/realms/quarkus/.well-known/openid-configuration")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{\n    \"jwks_uri\": \"" + this.server.baseUrl() + "/auth/realms/quarkus/protocol/openid-connect/certs\",\n    \"token_introspection_endpoint\": \"" + this.server.baseUrl() + "/auth/realms/quarkus/protocol/openid-connect/token/introspect\",\n    \"authorization_endpoint\": \"" + this.server.baseUrl() + "/auth/realms/quarkus\",    \"userinfo_endpoint\": \"" + this.server.baseUrl() + "/auth/realms/quarkus/protocol/openid-connect/userinfo\",    \"token_endpoint\": \"" + this.server.baseUrl() + "/auth/realms/quarkus/token\",    \"issuer\" : \"" + TOKEN_ISSUER + "\",    \"introspection_endpoint\": \"" + this.server.baseUrl() + "/auth/realms/quarkus/protocol/openid-connect/token/introspect\",    \"end_session_endpoint\": \"" + this.server.baseUrl() + "/auth/realms/quarkus/protocol/openid-connect/end-session\"}")));
        this.server.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/auth/realms/quarkus/protocol/openid-connect/certs")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{\n  \"keys\" : [\n    {\n      \"kid\": \"1\",\n      \"kty\":\"RSA\",\n      \"n\":\"iJw33l1eVAsGoRlSyo-FCimeOc-AaZbzQ2iESA3Nkuo3TFb1zIkmt0kzlnWVGt48dkaIl13Vdefh9hqw_r9yNF8xZqX1fp0PnCWc5M_TX_ht5fm9y0TpbiVmsjeRMWZn4jr3DsFouxQ9aBXUJiu26V0vd2vrECeeAreFT4mtoHY13D2WVeJvboc5mEJcp50JNhxRCJ5UkY8jR_wfUk2Tzz4-fAj5xQaBccXnqJMu_1C6MjoCEiB7G1d13bVPReIeAGRKVJIF6ogoCN8JbrOhc_48lT4uyjbgnd24beatuKWodmWYhactFobRGYo5551cgMe8BoxpVQ4to30cGA0qjQ\",\n      \"e\":\"AQAB\"\n    },\n    {      \"kty\": \"RSA\",      \"alg\": \"RS256\",      \"n\":\"iJw33l1eVAsGoRlSyo-FCimeOc-AaZbzQ2iESA3Nkuo3TFb1zIkmt0kzlnWVGt48dkaIl13Vdefh9hqw_r9yNF8xZqX1fp0PnCWc5M_TX_ht5fm9y0TpbiVmsjeRMWZn4jr3DsFouxQ9aBXUJiu26V0vd2vrECeeAreFT4mtoHY13D2WVeJvboc5mEJcp50JNhxRCJ5UkY8jR_wfUk2Tzz4-fAj5xQaBccXnqJMu_1C6MjoCEiB7G1d13bVPReIeAGRKVJIF6ogoCN8JbrOhc_48lT4uyjbgnd24beatuKWodmWYhactFobRGYo5551cgMe8BoxpVQ4to30cGA0qjQ\",\n      \"e\":\"AQAB\",\n      \"x5c\": [          \"MIIC+zCCAeOgAwIBAgIGAXx/E9rgMA0GCSqGSIb3DQEBCwUAMBQxEjAQBgNVBAMMCWxvY2FsaG9zdDAeFw0yMTEwMTQxMzUzMDBaFw0yMjEwMTQxMzUzMDBaMBQxEjAQBgNVBAMMCWxvY2FsaG9zdDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAIicN95dXlQLBqEZUsqPhQopnjnPgGmW80NohEgNzZLqN0xW9cyJJrdJM5Z1lRrePHZGiJdd1XXn4fYasP6/cjRfMWal9X6dD5wlnOTP01/4beX5vctE6W4lZrI3kTFmZ+I69w7BaLsUPWgV1CYrtuldL3dr6xAnngK3hU+JraB2Ndw9llXib26HOZhCXKedCTYcUQieVJGPI0f8H1JNk88+PnwI+cUGgXHF56iTLv9QujI6AhIgextXdd21T0XiHgBkSlSSBeqIKAjfCW6zoXP+PJU+Lso24J3duG3mrbilqHZlmIWnLRaG0RmKOeedXIDHvAaMaVUOLaN9HBgNKo0CAwEAAaNTMFEwHQYDVR0OBBYEFMYGoBNHBTMvMT4DwClVHVVwn+5VMB8GA1UdIwQYMBaAFMYGoBNHBTMvMT4DwClVHVVwn+5VMA8GA1UdEwEB/wQFMAMBAf8wDQYJKoZIhvcNAQELBQADggEBAFulB0DKhykXGbGPIBPcj63ItLNilgl1i8i43my8fYdV6OBWLIhZ4InhpX1+XmYCNPNtu94Jy1csS00K2/Hhn4ByBd+6nd5DSr0W0VdVQyhLz3GW1nf0J3X2N+tD818O0KtKKPTq4p9reg/XtV+DNv7DeDAGzlfgRL4E4fQx6OYeuu35kGrPvAddIA70leJMELJRylCLfEcl2ne/Bht8cZVp7ZCxnfXnsc+7hCW84mhzGjJycA3E6TnZPD3pD+q9FoIAQMxMQqUCH71u9vTvz1Q5JdokuJJY2eTHSUKyHA9MwSFq8DFDICJFBoQuFyDlK5yxSUcQpR3mBwKdimj6oA0=\"      ]    }  ]\n}")));
        this.server.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/auth/realms/quarkus/single-key-without-kid-thumbprint")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{\n  \"keys\" : [\n    {\n      \"kty\":\"RSA\",\n      \"n\":\"iJw33l1eVAsGoRlSyo-FCimeOc-AaZbzQ2iESA3Nkuo3TFb1zIkmt0kzlnWVGt48dkaIl13Vdefh9hqw_r9yNF8xZqX1fp0PnCWc5M_TX_ht5fm9y0TpbiVmsjeRMWZn4jr3DsFouxQ9aBXUJiu26V0vd2vrECeeAreFT4mtoHY13D2WVeJvboc5mEJcp50JNhxRCJ5UkY8jR_wfUk2Tzz4-fAj5xQaBccXnqJMu_1C6MjoCEiB7G1d13bVPReIeAGRKVJIF6ogoCN8JbrOhc_48lT4uyjbgnd24beatuKWodmWYhactFobRGYo5551cgMe8BoxpVQ4to30cGA0qjQ\",\n      \"e\":\"AQAB\"\n    }  ]\n}")));
        this.defineUserInfoStubForOpaqueToken("alice");
        this.defineUserInfoStubForOpaqueToken("admin");
        this.defineUserInfoStubForJwt();
        this.defineValidIntrospectionMockTokenStubForUserWithRoles("alice", (Set<String>)ImmutableSet.copyOf(this.getUserRoles()));
        this.defineValidIntrospectionMockTokenStubForUserWithRoles("admin", (Set<String>)ImmutableSet.copyOf(this.getAdminRoles()));
        this.defineInvalidIntrospectionMockTokenStubForUserWithRoles("expired", Collections.emptySet());
        this.defineCodeFlowAuthorizationMockTokenStub();
        this.defineCodeFlowAuthorizationMockEncryptedTokenStub();
        this.defineJwtBearerGrantTokenStub();
        this.server.stubFor(WireMock.get((UrlPattern)WireMock.urlPathMatching((String)"/auth/realms/quarkus[/]?")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"text/html"}).withBody("<html>\n<body>\n <form action=\"/login\" name=\"form\">\n  <input type=\"text\" id=\"username\" name=\"username\"/>\n  <input type=\"password\" id=\"password\" name=\"password\"/>\n  <input type=\"hidden\" id=\"state\" name=\"state\" value=\"{{request.query.state}}\"/>\n  <input type=\"hidden\" id=\"redirect_uri\" name=\"redirect_uri\" value=\"{{request.query.redirect_uri}}\"/>\n  <input type=\"submit\" id=\"login\" value=\"login\"/>\n</form>\n</body>\n</html> ").withTransformers(new String[]{"response-template"})));
        this.server.stubFor(WireMock.get((UrlPattern)WireMock.urlPathMatching((String)"/auth/realms/quarkus-form-post[/]?")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"text/html"}).withBody("<html>\n<body>\n <form action=\"/login-form-post\" name=\"form\">\n  <input type=\"text\" id=\"username\" name=\"username\"/>\n  <input type=\"password\" id=\"password\" name=\"password\"/>\n  <input type=\"hidden\" id=\"state\" name=\"state\" value=\"{{request.query.state}}\"/>\n  <input type=\"hidden\" id=\"redirect_uri\" name=\"redirect_uri\" value=\"{{request.query.redirect_uri}}\"/>\n  <input type=\"submit\" id=\"login\" value=\"login\"/>\n</form>\n</body>\n</html> ").withTransformers(new String[]{"response-template"})));
        this.server.stubFor(WireMock.get((UrlPattern)WireMock.urlPathMatching((String)"/login")).willReturn(WireMock.aResponse().withHeader("Location", new String[]{"{{request.query.redirect_uri}}?state={{request.query.state}}&code=58af24f2-9093-4674-a431-4a9d66be719c.50437113-cd78-48a2-838e-b936fe458c5d.0ac5df91-e044-4051-bd03-106a3a5fb9cc"}).withStatus(302).withTransformers(new String[]{"response-template"})));
        this.server.stubFor(WireMock.get((UrlPattern)WireMock.urlPathMatching((String)"/login-form-post")).willReturn(WireMock.aResponse().withBody("<html>\n   <head><title>Submit This Form</title></head>\n   <body onload=\"javascript:document.forms[0].submit()\">\n    <form method=\"post\" action=\"{{request.query.redirect_uri}}\">\n      <input type=\"hidden\" name=\"state\"\n       value=\"{{request.query.state}}\"/>\n      <input type=\"hidden\" name=\"code\"\n       value=\"58af24f2-9093-4674-a431-4a9d66be719c.50437113-cd78-48a2-838e-b936fe458c5d.0ac5df91-e044-4051-bd03-106a3a5fb9cc\"/>\n    </form>\n   </body>\n  </html>\n").withTransformers(new String[]{"response-template"})));
        LOG.infof("Keycloak started in mock mode: %s", (Object)this.server.baseUrl());
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("keycloak.url", this.server.baseUrl() + "/auth");
        conf.put("smallrye.jwt.sign.key.location", "privateKey.jwk");
        return conf;
    }

    private void defineUserInfoStubForOpaqueToken(String user) {
        this.server.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/auth/realms/quarkus/protocol/openid-connect/userinfo")).withHeader("Authorization", WireMock.matching((String)("Bearer " + user))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{\n      \"preferred_username\": \"" + user + "\"}")));
    }

    private void defineUserInfoStubForJwt() {
        this.server.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/auth/realms/quarkus/protocol/openid-connect/userinfo")).withHeader("Authorization", WireMock.containing((String)"Bearer ey")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{\n      \"preferred_username\": \"alice\"}")));
    }

    private void defineValidIntrospectionMockTokenStubForUserWithRoles(String user, Set<String> roles) {
        long exp = OidcWiremockTestResource.now() + 300L;
        this.server.stubFor(WireMock.post((String)"/auth/realms/quarkus/protocol/openid-connect/token/introspect").withRequestBody((ContentPattern)WireMock.matching((String)("token=" + user + "&token_type_hint=access_token"))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{\"active\":true,\"scope\":\"" + roles.stream().collect(Collectors.joining(" ")) + "\",\"username\":\"" + user + "\",\"iat\":1,\"exp\":" + exp + ",\"expires_in\":" + exp + ",\"client_id\":\"my_client_id\"}")));
    }

    private static final long now() {
        return System.currentTimeMillis();
    }

    private void defineInvalidIntrospectionMockTokenStubForUserWithRoles(String user, Set<String> roles) {
        this.server.stubFor(WireMock.post((String)"/auth/realms/quarkus/protocol/openid-connect/token/introspect").withRequestBody((ContentPattern)WireMock.matching((String)("token=" + user + "&token_type_hint=access_token"))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{\"active\":true,\"scope\":\"" + roles.stream().collect(Collectors.joining(" ")) + "\",\"username\":\"" + user + "\",\"iat\":1562315654,\"exp\":1,\"expires_in\":1,\"client_id\":\"my_client_id\"}")));
    }

    private void defineJwtBearerGrantTokenStub() {
        this.server.stubFor(WireMock.post((String)"/auth/realms/quarkus/jwt-bearer-token").withRequestBody((ContentPattern)WireMock.containing((String)"client_id=quarkus-app")).withRequestBody((ContentPattern)WireMock.containing((String)"client_secret=secret")).withRequestBody((ContentPattern)WireMock.containing((String)"grant_type=urn%3Aietf%3Aparams%3Aoauth%3Agrant-type%3Ajwt-bearer")).withRequestBody((ContentPattern)WireMock.containing((String)"scope=https%3A%2F%2Fgraph.microsoft.com%2Fuser.read+offline_access")).withRequestBody((ContentPattern)WireMock.containing((String)"requested_token_use=on_behalf_of")).withRequestBody((ContentPattern)WireMock.containing((String)"assertion")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{\n  \"access_token\": \"" + OidcWiremockTestResource.getAccessToken("bob", this.getUserRoles()) + "\"}")));
    }

    private void defineCodeFlowAuthorizationMockTokenStub() {
        this.server.stubFor(WireMock.post((String)"/auth/realms/quarkus/token").withRequestBody((ContentPattern)WireMock.containing((String)"authorization_code")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{\n  \"access_token\": \"" + OidcWiremockTestResource.getAccessToken("alice", this.getAdminRoles()) + "\",\n  \"refresh_token\": \"07e08903-1263-4dd1-9fd1-4a59b0db5283\",\n  \"id_token\": \"" + OidcWiremockTestResource.getIdToken("alice", this.getAdminRoles()) + "\"\n}")));
    }

    private void defineCodeFlowAuthorizationMockEncryptedTokenStub() {
        this.server.stubFor(WireMock.post((String)"/auth/realms/quarkus/encrypted-id-token").withRequestBody((ContentPattern)WireMock.containing((String)"authorization_code")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{\n  \"access_token\": \"" + OidcWiremockTestResource.getAccessToken("alice", this.getAdminRoles()) + "\",\n  \"refresh_token\": \"07e08903-1263-4dd1-9fd1-4a59b0db5283\",\n  \"id_token\": \"" + OidcWiremockTestResource.getEncryptedIdToken("alice", this.getAdminRoles()) + "\"\n}")));
    }

    public static String getEncryptedIdToken(String userName, Set<String> groups) {
        return Jwt.preferredUserName((String)userName).groups(groups).issuer(TOKEN_ISSUER).audience(TOKEN_AUDIENCE).subject("123456").jws().keyId("1").innerSign("privateKey.jwk").encrypt("publicKey.jwk");
    }

    public static X509Certificate getCertificate() {
        try {
            return new X509Util().fromBase64Der(ENCODED_X5C);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private Set<String> getAdminRoles() {
        return new HashSet<String>(Arrays.asList(TOKEN_ADMIN_ROLES.split(",")));
    }

    private Set<String> getUserRoles() {
        return new HashSet<String>(Arrays.asList(TOKEN_USER_ROLES.split(",")));
    }

    public static String getAccessToken(String userName, Set<String> groups) {
        return OidcWiremockTestResource.generateJwtToken(userName, groups);
    }

    public static String getIdToken(String userName, Set<String> groups) {
        return OidcWiremockTestResource.generateJwtToken(userName, groups);
    }

    public static String generateJwtToken(String userName, Set<String> groups) {
        return Jwt.preferredUserName((String)userName).groups(groups).issuer(TOKEN_ISSUER).audience(TOKEN_AUDIENCE).claim("sid", (Object)"session-id").subject("123456").jws().keyId("1").sign("privateKey.jwk");
    }

    public static String getLogoutToken() {
        return Jwt.issuer((String)TOKEN_ISSUER).audience(TOKEN_AUDIENCE).subject("123456").claim("events", (Object)OidcWiremockTestResource.createEventsClaim()).claim("sid", (Object)"session-id").jws().keyId("1").sign("privateKey.jwk");
    }

    public static String getLogoutToken(String sub) {
        return Jwt.issuer((String)TOKEN_ISSUER).audience(TOKEN_AUDIENCE).subject(sub).claim("events", (Object)OidcWiremockTestResource.createEventsClaim()).claim("sid", (Object)"session-id").jws().keyId("1").sign("privateKey.jwk");
    }

    private static JsonObject createEventsClaim() {
        return Json.createObjectBuilder().add("http://schemas.openid.net/event/backchannel-logout", (JsonValue)Json.createObjectBuilder().build()).build();
    }

    public void inject(QuarkusTestResourceLifecycleManager.TestInjector testInjector) {
        testInjector.injectIntoFields((Object)this.server, (Predicate)new QuarkusTestResourceLifecycleManager.TestInjector.AnnotatedAndMatchesType(OidcWireMock.class, WireMockServer.class));
    }

    public synchronized void stop() {
        if (this.server != null) {
            this.server.stop();
            LOG.info((Object)"Keycloak was shut down");
            this.server = null;
        }
    }
}

