/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.kubernetes.client;

import io.fabric8.openshift.client.NamespacedOpenShiftClient;
import io.fabric8.openshift.client.server.mock.OpenShiftServer;
import io.quarkus.test.common.QuarkusTestResourceConfigurableLifecycleManager;
import io.quarkus.test.kubernetes.client.AbstractKubernetesTestResource;
import io.quarkus.test.kubernetes.client.OpenShiftTestServer;
import io.quarkus.test.kubernetes.client.WithOpenShiftTestServer;
import java.lang.annotation.Annotation;
import java.util.function.Consumer;

public class OpenShiftServerTestResource
extends AbstractKubernetesTestResource<OpenShiftServer, NamespacedOpenShiftClient>
implements QuarkusTestResourceConfigurableLifecycleManager<WithOpenShiftTestServer> {
    private boolean https = false;
    private boolean crud = true;
    private Consumer<OpenShiftServer> setup;

    public void init(WithOpenShiftTestServer annotation) {
        this.https = annotation.https();
        this.crud = annotation.crud();
        try {
            this.setup = annotation.setup().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    protected NamespacedOpenShiftClient getClient() {
        return ((OpenShiftServer)this.server).getOpenshiftClient();
    }

    protected void initServer() {
        ((OpenShiftServer)this.server).before();
    }

    protected void configureServer() {
        if (this.setup != null) {
            this.setup.accept((OpenShiftServer)this.server);
        }
    }

    protected OpenShiftServer createServer() {
        return new OpenShiftServer(this.https, this.crud);
    }

    public void stop() {
        if (this.server != null) {
            ((OpenShiftServer)this.server).after();
            this.server = null;
        }
    }

    protected Class<?> getInjectedClass() {
        return OpenShiftServer.class;
    }

    protected Class<? extends Annotation> getInjectionAnnotation() {
        return OpenShiftTestServer.class;
    }
}

