/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.security.oidc;

import io.quarkus.arc.Unremovable;
import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.oidc.IdTokenCredential;
import io.quarkus.oidc.OidcConfigurationMetadata;
import io.quarkus.oidc.TokenIntrospection;
import io.quarkus.oidc.UserInfo;
import io.quarkus.oidc.runtime.OidcJwtCallerPrincipal;
import io.quarkus.security.credential.Credential;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.test.security.TestSecurityIdentityAugmentor;
import io.quarkus.test.security.oidc.OidcSecurity;
import io.smallrye.jwt.build.Jwt;
import io.smallrye.jwt.util.KeyUtils;
import io.vertx.core.json.JsonObject;
import java.lang.annotation.Annotation;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonObjectBuilder;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.jwt.Claims;
import org.jose4j.jwt.JwtClaims;

@ApplicationScoped
public class OidcTestSecurityIdentityAugmentorProducer {
    @Inject
    @ConfigProperty(name="quarkus.oidc.token.issuer")
    Optional<String> issuer;
    PrivateKey privateKey;

    @PostConstruct
    public void init() {
        try {
            this.privateKey = KeyUtils.generateKeyPair((int)2048).getPrivate();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Produces
    @Unremovable
    public TestSecurityIdentityAugmentor produce() {
        return new OidcTestSecurityIdentityAugmentor();
    }

    private class OidcTestSecurityIdentityAugmentor
    implements TestSecurityIdentityAugmentor {
        private OidcTestSecurityIdentityAugmentor() {
        }

        public SecurityIdentity augment(SecurityIdentity identity, Annotation[] annotations) {
            boolean introspectionRequired;
            QuarkusSecurityIdentity.Builder builder = QuarkusSecurityIdentity.builder((SecurityIdentity)identity);
            OidcSecurity oidcSecurity = this.findOidcSecurity(annotations);
            boolean bl = introspectionRequired = oidcSecurity != null && oidcSecurity.introspectionRequired();
            if (!introspectionRequired) {
                JwtClaims claims = new JwtClaims();
                claims.setClaim(Claims.preferred_username.name(), (Object)identity.getPrincipal().getName());
                claims.setClaim(Claims.groups.name(), identity.getRoles().stream().collect(Collectors.toList()));
                if (oidcSecurity != null && oidcSecurity.claims() != null) {
                    for (Annotation annotation : oidcSecurity.claims()) {
                        claims.setClaim(annotation.key(), (Object)annotation.value());
                    }
                }
                String jwt = this.generateToken(claims);
                IdTokenCredential idToken = new IdTokenCredential(jwt);
                AccessTokenCredential accessToken = new AccessTokenCredential(jwt);
                OidcJwtCallerPrincipal oidcJwtCallerPrincipal = new OidcJwtCallerPrincipal(claims, (TokenCredential)idToken);
                builder.setPrincipal((Principal)oidcJwtCallerPrincipal);
                builder.addCredential((Credential)idToken);
                builder.addCredential((Credential)accessToken);
            } else {
                JsonObjectBuilder introspectionBuilder = Json.createObjectBuilder();
                introspectionBuilder.add("active", true);
                introspectionBuilder.add("username", identity.getPrincipal().getName());
                introspectionBuilder.add("scope", identity.getRoles().stream().collect(Collectors.joining(" ")));
                if (oidcSecurity != null && oidcSecurity.introspection() != null) {
                    for (Annotation annotation : oidcSecurity.introspection()) {
                        introspectionBuilder.add(annotation.key(), annotation.value());
                    }
                }
                builder.addAttribute("introspection", (Object)new TokenIntrospection(introspectionBuilder.build()));
                builder.addCredential((Credential)new AccessTokenCredential(UUID.randomUUID().toString(), null));
            }
            if (oidcSecurity != null && oidcSecurity.userinfo() != null) {
                JsonObjectBuilder userInfoBuilder = Json.createObjectBuilder();
                for (Annotation annotation : oidcSecurity.userinfo()) {
                    userInfoBuilder.add(annotation.key(), annotation.value());
                }
                builder.addAttribute("userinfo", (Object)new UserInfo(userInfoBuilder.build()));
            }
            JsonObject configMetadataBuilder = new JsonObject();
            if (OidcTestSecurityIdentityAugmentorProducer.this.issuer.isPresent()) {
                configMetadataBuilder.put("issuer", (Object)OidcTestSecurityIdentityAugmentorProducer.this.issuer.get());
            }
            if (oidcSecurity != null && oidcSecurity.config() != null) {
                for (Annotation annotation : oidcSecurity.config()) {
                    configMetadataBuilder.put(annotation.key(), (Object)annotation.value());
                }
            }
            builder.addAttribute("configuration-metadata", (Object)new OidcConfigurationMetadata(configMetadataBuilder));
            return builder.build();
        }

        private String generateToken(JwtClaims claims) {
            try {
                return Jwt.claims((Map)claims.getClaimsMap()).sign(OidcTestSecurityIdentityAugmentorProducer.this.privateKey);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        private OidcSecurity findOidcSecurity(Annotation[] annotations) {
            for (Annotation ann : annotations) {
                if (!(ann instanceof OidcSecurity)) continue;
                return (OidcSecurity)ann;
            }
            return null;
        }
    }
}

