/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.security.webauthn;

import io.quarkus.security.webauthn.WebAuthnUserProvider;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.auth.webauthn.Authenticator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class WebAuthnTestUserProvider
implements WebAuthnUserProvider {
    private List<Authenticator> auths = new ArrayList<Authenticator>();

    public Uni<List<Authenticator>> findWebAuthnCredentialsByUserName(String userId) {
        ArrayList<Authenticator> ret = new ArrayList<Authenticator>();
        for (Authenticator authenticator : this.auths) {
            if (!authenticator.getUserName().equals(userId)) continue;
            ret.add(authenticator);
        }
        return Uni.createFrom().item(ret);
    }

    public Uni<List<Authenticator>> findWebAuthnCredentialsByCredID(String credId) {
        ArrayList<Authenticator> ret = new ArrayList<Authenticator>();
        for (Authenticator authenticator : this.auths) {
            if (!authenticator.getCredID().equals(credId)) continue;
            ret.add(authenticator);
        }
        return Uni.createFrom().item(ret);
    }

    public Uni<Void> updateOrStoreWebAuthnCredentials(Authenticator authenticator) {
        Authenticator existing = this.find(authenticator.getUserName(), authenticator.getCredID());
        if (existing != null) {
            existing.setCounter(authenticator.getCounter());
        } else {
            this.store(authenticator);
        }
        return Uni.createFrom().nullItem();
    }

    private Authenticator find(String userName, String credID) {
        for (Authenticator auth : this.auths) {
            if (!userName.equals(auth.getUserName()) || !credID.equals(auth.getCredID())) continue;
            return auth;
        }
        return null;
    }

    public Set<String> getRoles(String userId) {
        return Collections.singleton("admin");
    }

    public void store(Authenticator authenticator) {
        this.auths.add(authenticator);
    }

    public void update(String userName, String credID, long counter) {
        Authenticator authenticator = this.find(userName, credID);
        authenticator.setCounter(counter);
    }
}

